/*
 * Decompiled with CFR 0.152.
 */
package git4idea.workingTrees;

import com.intellij.openapi.util.registry.Registry;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitWorkingTree;
import git4idea.repo.GitRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgit4idea/workingTrees/GitWorkingTreesUtil;", "", "<init>", "()V", "TOOLWINDOW_TAB_ID", "", "isWorkingTreesFeatureEnabled", "", "getWorkingTreeWithRef", "Lgit4idea/GitWorkingTree;", "reference", "Lgit4idea/GitReference;", "repository", "Lgit4idea/repo/GitRepository;", "skipCurrentWorkingTree", "intellij.vcs.git"})
public final class GitWorkingTreesUtil {
    @NotNull
    public static final GitWorkingTreesUtil INSTANCE = new GitWorkingTreesUtil();
    @NotNull
    public static final String TOOLWINDOW_TAB_ID = "Working Trees";

    private GitWorkingTreesUtil() {
    }

    public final boolean isWorkingTreesFeatureEnabled() {
        return Registry.Companion.is("git.enable.working.trees.feature", false);
    }

    @Nullable
    public final GitWorkingTree getWorkingTreeWithRef(@NotNull GitReference reference, @NotNull GitRepository repository2, boolean skipCurrentWorkingTree) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            if (!this.isWorkingTreesFeatureEnabled() || !(reference instanceof GitLocalBranch)) {
                return null;
            }
            Iterable iterable = repository2.getWorkingTreeHolder().getWorkingTrees();
            for (Object t : iterable) {
                GitWorkingTree it = (GitWorkingTree)t;
                boolean bl = false;
                if (!((!skipCurrentWorkingTree || !it.isCurrent()) && Intrinsics.areEqual((Object)it.getCurrentBranch(), (Object)reference))) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }
}

