/*
 * Decompiled with CFR 0.152.
 */
package git4idea.workingTrees.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.git.repo.GitRepositoriesHolder;
import git4idea.GitStandardLocalBranch;
import git4idea.GitWorkingTree;
import git4idea.actions.workingTree.GitWorkingTreeTabActionsDataKeys;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitWorkingTreeHolder;
import git4idea.workingTrees.GitWorkingTreesService;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0005\n\u000b\f\r\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgit4idea/workingTrees/ui/GitWorkingTreesContentProvider;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "initTabContent", "", "content", "Lcom/intellij/ui/content/Content;", "Companion", "GitWorkingTreesUi", "WorkingTreesList", "WorkingTreesListModel", "WorkingTreesListRenderer", "intellij.vcs.git"})
public final class GitWorkingTreesContentProvider
implements ChangesViewContentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    public static final String GIT_WORKING_TREE_TOOLWINDOW_TAB_TOOLBAR = "GitWorkingTreeToolWindowTabToolbar";

    public GitWorkingTreesContentProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void initTabContent(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        content.setComponent((JComponent)((Object)new GitWorkingTreesUi()));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/workingTrees/ui/GitWorkingTreesContentProvider$Companion;", "", "<init>", "()V", "GIT_WORKING_TREE_TOOLWINDOW_TAB_TOOLBAR", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lgit4idea/workingTrees/ui/GitWorkingTreesContentProvider$GitWorkingTreesUi;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "<init>", "(Lgit4idea/workingTrees/ui/GitWorkingTreesContentProvider;)V", "intellij.vcs.git"})
    private final class GitWorkingTreesUi
    extends BorderLayoutPanel {
        public GitWorkingTreesUi() {
            WorkingTreesList list = new WorkingTreesList(GitWorkingTreesContentProvider.this.project);
            JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)((Object)list)), (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
            JScrollPane scrollPane = jScrollPane;
            this.addToCenter(scrollPane);
            ActionManager actionManager = ActionManager.getInstance();
            AnAction anAction = actionManager.getAction("Git.WorkingTrees.ToolwindowGroup.Toolbar");
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
            ActionGroup toolbarActionGroup = (ActionGroup)anAction;
            ActionToolbar actionToolbar = actionManager.createActionToolbar(GitWorkingTreesContentProvider.GIT_WORKING_TREE_TOOLWINDOW_TAB_TOOLBAR, toolbarActionGroup, false);
            Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
            ActionToolbar toolbar = actionToolbar;
            toolbar.setTargetComponent((JComponent)((Object)list));
            toolbar.setLayoutStrategy(ToolbarLayoutStrategy.AUTOLAYOUT_STRATEGY);
            toolbar.setOrientation(1);
            this.addToLeft(toolbar.getComponent());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgit4idea/workingTrees/ui/GitWorkingTreesContentProvider$WorkingTreesList;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "model", "Lgit4idea/workingTrees/ui/GitWorkingTreesContentProvider$WorkingTreesListModel;", "list", "Lcom/intellij/ui/components/JBList;", "Lgit4idea/GitWorkingTree;", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "intellij.vcs.git"})
    private static final class WorkingTreesList
    extends BorderLayoutPanel
    implements UiDataProvider {
        @NotNull
        private final WorkingTreesListModel model;
        @NotNull
        private final JBList<GitWorkingTree> list;

        public WorkingTreesList(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.model = new WorkingTreesListModel(project);
            this.list = new JBList((ListModel)this.model);
            this.list.setCellRenderer((ListCellRenderer)((Object)new WorkingTreesListRenderer()));
            this.list.getEmptyText().setText(GitBundle.message((String)"toolwindow.working.trees.tab.empty.text", (Object[])new Object[0]));
            this.addToCenter((Component)this.list);
            this.list.addMouseListener((MouseListener)new PopupHandler(){

                public void invokePopup(Component comp, int x, int y) {
                    Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                    int index = list.locationToIndex(new Point(x, y));
                    if (index != -1 && list.getCellBounds(index, index).contains(x, y)) {
                        list.setSelectedIndex(index);
                    }
                    AnAction anAction = ActionManager.getInstance().getAction("Git.WorkingTrees.ToolwindowGroup.Popup");
                    Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
                    ActionGroup actionGroup = (ActionGroup)anAction;
                    ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("popup", actionGroup);
                    Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"createActionPopupMenu(...)");
                    ActionPopupMenu popupMenu = actionPopupMenu;
                    popupMenu.setTargetComponent((JComponent)list);
                    popupMenu.getComponent().show(comp, x, y);
                }
            });
            project.getMessageBus().connect(GitWorkingTreesService.Companion.getInstance(project).getCoroutineScope()).subscribe(GitRepositoriesHolder.Companion.getUPDATES(), arg_0 -> WorkingTreesList._init_$lambda$0(this, project, arg_0));
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            sink.set(GitWorkingTreeTabActionsDataKeys.SELECTED_WORKING_TREES, (Object)this.list.getSelectedValuesList());
            sink.set(GitWorkingTreeTabActionsDataKeys.CURRENT_REPOSITORY, (Object)this.model.getRepository());
        }

        private static final void lambda$0$0(WorkingTreesList this$0, Project $project) {
            this$0.model.reload($project);
        }

        private static final void _init_$lambda$0(WorkingTreesList this$0, Project $project, GitRepositoriesHolder.UpdateType event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event == GitRepositoriesHolder.UpdateType.WORKING_TREES_LOADED) {
                ApplicationManager.getApplication().invokeLater(() -> WorkingTreesList.lambda$0$0(this$0, $project));
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0004R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lgit4idea/workingTrees/ui/GitWorkingTreesContentProvider$WorkingTreesListModel;", "Ljavax/swing/DefaultListModel;", "Lgit4idea/GitWorkingTree;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "value", "Lgit4idea/repo/GitRepository;", "repository", "getRepository", "()Lgit4idea/repo/GitRepository;", "reload", "", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitWorkingTreesContentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitWorkingTreesContentProvider.kt\ngit4idea/workingTrees/ui/GitWorkingTreesContentProvider$WorkingTreesListModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n1915#2,2:191\n*S KotlinDebug\n*F\n+ 1 GitWorkingTreesContentProvider.kt\ngit4idea/workingTrees/ui/GitWorkingTreesContentProvider$WorkingTreesListModel\n*L\n117#1:191,2\n*E\n"})
    private static final class WorkingTreesListModel
    extends DefaultListModel<GitWorkingTree> {
        @Nullable
        private GitRepository repository;

        public WorkingTreesListModel(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.reload(project);
        }

        @Nullable
        public final GitRepository getRepository() {
            return this.repository;
        }

        public final void reload(@NotNull Project project) {
            Collection<GitWorkingTree> workingTrees;
            GitRepository currentRepository;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.clear();
            this.repository = currentRepository = GitWorkingTreesService.Companion.getRepoForWorkingTreesSupport(project);
            Object object = currentRepository;
            Collection<GitWorkingTree> collection = object != null && (object = object.getWorkingTreeHolder()) != null ? ((GitWorkingTreeHolder)object).getWorkingTrees() : (workingTrees = null);
            if (workingTrees != null && workingTrees.size() > 1) {
                Iterable $this$forEach$iv = workingTrees;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GitWorkingTree it = (GitWorkingTree)element$iv;
                    boolean bl = false;
                    if (it.isMain()) {
                        this.add(0, it);
                        continue;
                    }
                    this.addElement(it);
                }
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J<\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lgit4idea/workingTrees/ui/GitWorkingTreesContentProvider$WorkingTreesListRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lgit4idea/GitWorkingTree;", "<init>", "()V", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "intellij.vcs.git"})
    private static final class WorkingTreesListRenderer
    extends ColoredListCellRenderer<GitWorkingTree> {
        protected void customizeCellRenderer(@NotNull JList<? extends GitWorkingTree> list, @Nullable GitWorkingTree value, int index, boolean selected, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            if (value == null) {
                return;
            }
            if (value.isCurrent()) {
                this.setIcon(AllIcons.Actions.Checked);
            } else {
                this.setIcon(AllIcons.Empty);
            }
            this.append(" ");
            this.append(value.getPath().getName(), value.isMain() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.append("   ");
            GitStandardLocalBranch branch = value.getCurrentBranch();
            String string = branch == null ? GitBundle.message((String)"toolwindow.working.trees.tab.detached.working.tree.branch.text", (Object[])new Object[0]) : branch.getName();
            Intrinsics.checkNotNull((Object)string);
            String presentableBranchName = string;
            this.append(presentableBranchName, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }
}

