/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages;

import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.platform.util.io.storages.DataExternalizerEx;
import com.intellij.platform.util.io.storages.KeyDescriptorEx;
import com.intellij.util.io.IOUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class CommonKeyDescriptors {
    private static final KeyDescriptorEx<Integer> INTEGER_DESCRIPTOR = new KeyDescriptorEx<Integer>(){

        @Override
        public int getHashCode(@NotNull Integer value) {
            if (value == null) {
                1.$$$reportNull$$$0(0);
            }
            return value.hashCode();
        }

        @Override
        public boolean isEqual(@NotNull Integer key1, @NotNull Integer key2) {
            if (key1 == null) {
                1.$$$reportNull$$$0(1);
            }
            if (key2 == null) {
                1.$$$reportNull$$$0(2);
            }
            return Objects.equals(key1, key2);
        }

        @Override
        public Integer read(@NotNull ByteBuffer input) throws IOException {
            if (input == null) {
                1.$$$reportNull$$$0(3);
            }
            return input.getInt();
        }

        @Override
        public DataExternalizerEx.KnownSizeRecordWriter writerFor(@NotNull Integer value) throws IOException {
            if (value == null) {
                1.$$$reportNull$$$0(4);
            }
            return new IntegerRecordWriter(value);
        }

        @Override
        public int recordSizeIfConstant() {
            return 4;
        }

        public String toString() {
            return "KeyDescriptorEx[Int32]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/platform/util/io/storages/CommonKeyDescriptors$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHashCode";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEqual";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writerFor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private record IntegerRecordWriter(int value) implements DataExternalizerEx.KnownSizeRecordWriter
        {
            @Override
            public ByteBuffer write(@NotNull ByteBuffer data) throws IOException {
                if (data == null) {
                    IntegerRecordWriter.$$$reportNull$$$0(0);
                }
                return data.putInt(this.value);
            }

            @Override
            public int recordSize() {
                return 4;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/platform/util/io/storages/CommonKeyDescriptors$1$IntegerRecordWriter", "write"));
            }
        }
    };
    private static final KeyDescriptorEx<ByteArraySequence> BYTE_ARRAY_SEQUENCE_DESCRIPTOR = new KeyDescriptorEx<ByteArraySequence>(){

        @Override
        public int getHashCode(@NotNull ByteArraySequence value) {
            if (value == null) {
                2.$$$reportNull$$$0(0);
            }
            return value.hashCode();
        }

        @Override
        public boolean isEqual(@NotNull ByteArraySequence key1, @NotNull ByteArraySequence key2) {
            if (key1 == null) {
                2.$$$reportNull$$$0(1);
            }
            if (key2 == null) {
                2.$$$reportNull$$$0(2);
            }
            return Objects.equals(key1, key2);
        }

        @Override
        public ByteArraySequence read(@NotNull ByteBuffer input) throws IOException {
            if (input == null) {
                2.$$$reportNull$$$0(3);
            }
            byte[] array = new byte[input.remaining()];
            input.get(array);
            return ByteArraySequence.create((byte[])array);
        }

        @Override
        public DataExternalizerEx.KnownSizeRecordWriter writerFor(final @NotNull ByteArraySequence value) throws IOException {
            if (value == null) {
                2.$$$reportNull$$$0(4);
            }
            return new DataExternalizerEx.KnownSizeRecordWriter(){

                @Override
                public ByteBuffer write(@NotNull ByteBuffer data) throws IOException {
                    if (data == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return data.put(value.getInternalBuffer(), value.getOffset(), value.length());
                }

                @Override
                public int recordSize() {
                    return value.length();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/platform/util/io/storages/CommonKeyDescriptors$2$1", "write"));
                }
            };
        }

        public String toString() {
            return "KeyDescriptorEx[ByteArraySequence]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/platform/util/io/storages/CommonKeyDescriptors$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHashCode";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEqual";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writerFor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final KeyDescriptorEx<String> STRING_AS_UTF8_DESCRIPTOR = new KeyDescriptorEx<String>(){

        @Override
        public int getHashCode(@NotNull String value) {
            if (value == null) {
                3.$$$reportNull$$$0(0);
            }
            return value.hashCode();
        }

        @Override
        public boolean isEqual(@NotNull String key1, @NotNull String key2) {
            if (key1 == null) {
                3.$$$reportNull$$$0(1);
            }
            if (key2 == null) {
                3.$$$reportNull$$$0(2);
            }
            return key1.equals(key2);
        }

        @Override
        @NotNull
        public String read(@NotNull ByteBuffer input) throws IOException {
            if (input == null) {
                3.$$$reportNull$$$0(3);
            }
            String string = IOUtil.readString((ByteBuffer)input);
            if (string == null) {
                3.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public DataExternalizerEx.KnownSizeRecordWriter writerFor(@NotNull String key) throws IOException {
            if (key == null) {
                3.$$$reportNull$$$0(5);
            }
            return DataExternalizerEx.fromBytes(key.getBytes(StandardCharsets.UTF_8));
        }

        public String toString() {
            return "StringAsUTF8";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/util/io/storages/CommonKeyDescriptors$3";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/util/io/storages/CommonKeyDescriptors$3";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "read";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getHashCode";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isEqual";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "read";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "writerFor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    };

    private CommonKeyDescriptors() {
        throw new AssertionError((Object)"Bug: not for instantiation");
    }

    public static KeyDescriptorEx<Integer> integer() {
        return INTEGER_DESCRIPTOR;
    }

    public static KeyDescriptorEx<ByteArraySequence> byteArraySequence() {
        return BYTE_ARRAY_SEQUENCE_DESCRIPTOR;
    }

    public static KeyDescriptorEx<String> stringAsUTF8() {
        return STRING_AS_UTF8_DESCRIPTOR;
    }
}

