/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext.transforms;

import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.parser.ExternalNameInfo;
import com.android.tools.idea.gradle.dsl.parser.GradleDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.android.FakeSdkElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.VersionConstraint;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkOrPreviewTransform
extends PropertyTransform {
    @NotNull
    private final ModelPropertyDescription propertyDescription;
    @NotNull
    private final String genericSetter;
    @NotNull
    private final String sdkSetter;
    @NotNull
    private final String previewSetter;
    @Nullable
    private VersionConstraint versionConstraint;
    @Nullable
    private Integer position;

    public SdkOrPreviewTransform(@NotNull ModelPropertyDescription propertyDescription, @NotNull String genericSetter, @NotNull String sdkSetter, @NotNull String previewSetter, @Nullable VersionConstraint versionConstraint, @Nullable Integer position) {
        if (propertyDescription == null) {
            SdkOrPreviewTransform.$$$reportNull$$$0(0);
        }
        if (genericSetter == null) {
            SdkOrPreviewTransform.$$$reportNull$$$0(1);
        }
        if (sdkSetter == null) {
            SdkOrPreviewTransform.$$$reportNull$$$0(2);
        }
        if (previewSetter == null) {
            SdkOrPreviewTransform.$$$reportNull$$$0(3);
        }
        this.propertyDescription = propertyDescription;
        this.genericSetter = genericSetter;
        this.sdkSetter = sdkSetter;
        this.previewSetter = previewSetter;
        this.versionConstraint = versionConstraint;
        this.position = position;
    }

    public SdkOrPreviewTransform(@NotNull ModelPropertyDescription propertyDescription, @NotNull String genericSetter, @NotNull String sdkSetter, @NotNull String previewSetter, @Nullable VersionConstraint versionConstraint) {
        if (propertyDescription == null) {
            SdkOrPreviewTransform.$$$reportNull$$$0(4);
        }
        if (genericSetter == null) {
            SdkOrPreviewTransform.$$$reportNull$$$0(5);
        }
        if (sdkSetter == null) {
            SdkOrPreviewTransform.$$$reportNull$$$0(6);
        }
        if (previewSetter == null) {
            SdkOrPreviewTransform.$$$reportNull$$$0(7);
        }
        this(propertyDescription, genericSetter, sdkSetter, previewSetter, versionConstraint, null);
    }

    @Override
    public boolean test(@Nullable GradleDslElement e, @NotNull GradleDslElement holder) {
        if (holder == null) {
            SdkOrPreviewTransform.$$$reportNull$$$0(8);
        }
        return e == null || e.getModelProperty() == this.propertyDescription;
    }

    @Override
    @Nullable
    public GradleDslElement transform(@Nullable GradleDslElement e) {
        if (e == null) {
            return null;
        }
        if (e instanceof GradleDslSimpleExpression && this.previewSetter.equals(e.getNameElement().getLocalName())) {
            GradleDslSimpleExpression expression = (GradleDslSimpleExpression)e;
            return new FakeSdkElement(expression.getParent(), GradleNameElement.copy(expression.getNameElement()), expression, true);
        }
        return e;
    }

    @Override
    @NotNull
    public GradleDslExpression bind(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull Object value, @NotNull String name2) {
        ExternalNameInfo.ExternalNameSyntax syntax;
        String operatorName;
        if (holder == null) {
            SdkOrPreviewTransform.$$$reportNull$$$0(9);
        }
        if (value == null) {
            SdkOrPreviewTransform.$$$reportNull$$$0(10);
        }
        if (name2 == null) {
            SdkOrPreviewTransform.$$$reportNull$$$0(11);
        }
        if (this.versionConstraint == null || this.versionConstraint.isOkWith(holder.getDslFile().getContext().getAgpVersion())) {
            if (value instanceof ReferenceTo) {
                operatorName = this.genericSetter;
                syntax = ExternalNameInfo.ExternalNameSyntax.METHOD;
            } else if (value instanceof Integer) {
                operatorName = this.sdkSetter;
                syntax = Objects.equals("gradle", holder.getDslFile().getFile().getExtension()) ? ExternalNameInfo.ExternalNameSyntax.METHOD : ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT;
            } else if (value instanceof String && ((String)value).startsWith("android-")) {
                String valueAfterAndroid = ((String)value).substring("android-".length());
                if (this.isPreviewHash((String)value)) {
                    operatorName = this.previewSetter;
                    syntax = Objects.equals("gradle", holder.getDslFile().getFile().getExtension()) ? ExternalNameInfo.ExternalNameSyntax.METHOD : ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT;
                    value = valueAfterAndroid;
                } else {
                    try {
                        int sdkVersion = Integer.parseInt(valueAfterAndroid);
                        operatorName = this.sdkSetter;
                        syntax = Objects.equals("gradle", holder.getDslFile().getFile().getExtension()) ? ExternalNameInfo.ExternalNameSyntax.METHOD : ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT;
                        value = sdkVersion;
                    }
                    catch (NumberFormatException e) {
                        operatorName = this.genericSetter;
                        syntax = holder.getDslFile().getWriter().getKind() == GradleDslNameConverter.Kind.DECLARATIVE ? ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT : ExternalNameInfo.ExternalNameSyntax.METHOD;
                    }
                }
            } else {
                operatorName = this.genericSetter;
                syntax = holder.getDslFile().getWriter().getKind() == GradleDslNameConverter.Kind.DECLARATIVE ? ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT : ExternalNameInfo.ExternalNameSyntax.METHOD;
            }
        } else {
            operatorName = this.genericSetter;
            syntax = holder.getDslFile().getWriter().getKind() == GradleDslNameConverter.Kind.DECLARATIVE ? ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT : ExternalNameInfo.ExternalNameSyntax.METHOD;
        }
        GradleDslSimpleExpression expression = PropertyUtil.createBasicExpression(holder, value, GradleNameElement.create(operatorName));
        expression.setModelEffect(new ModelEffectDescription(this.propertyDescription, ModelSemanticsDescription.CREATE_WITH_VALUE));
        expression.setExternalSyntax(syntax);
        GradleDslSimpleExpression gradleDslSimpleExpression = expression;
        if (gradleDslSimpleExpression == null) {
            SdkOrPreviewTransform.$$$reportNull$$$0(12);
        }
        return gradleDslSimpleExpression;
    }

    private boolean isPreviewHash(String value) {
        return value.startsWith("android-") && Character.isAlphabetic(value.charAt(value.length() - 1));
    }

    @Override
    @NotNull
    public GradleDslElement replace(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull GradleDslExpression newElement, @NotNull String name2) {
        if (holder == null) {
            SdkOrPreviewTransform.$$$reportNull$$$0(13);
        }
        if (newElement == null) {
            SdkOrPreviewTransform.$$$reportNull$$$0(14);
        }
        if (name2 == null) {
            SdkOrPreviewTransform.$$$reportNull$$$0(15);
        }
        GradlePropertiesDslElement propertiesHolder = (GradlePropertiesDslElement)holder;
        if (oldElement != null) {
            propertiesHolder.replaceElement(oldElement, newElement);
        } else if (this.position != null) {
            propertiesHolder.addNewElementAt(this.position, newElement);
        } else {
            propertiesHolder.setNewElement(newElement);
        }
        GradleDslExpression gradleDslExpression = newElement;
        if (gradleDslExpression == null) {
            SdkOrPreviewTransform.$$$reportNull$$$0(16);
        }
        return gradleDslExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescription";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericSetter";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkSetter";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewSetter";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/ext/transforms/SdkOrPreviewTransform";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/ext/transforms/SdkOrPreviewTransform";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "bind";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "test";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "bind";
                break;
            }
            case 12: 
            case 16: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 16 -> new IllegalStateException(string);
        };
    }
}

