/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.RememberCheckBoxState;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Ref;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.PasswordStringProvider;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ui.AppIcon;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001eB\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B)\b\u0012\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\fB\u001b\b\u0017\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u000fB\u001b\b\u0017\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0012J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ssh/DialogSshSudoPasswordStringProvider;", "Lcom/intellij/ssh/PasswordStringProvider;", "sshPath", "", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "DialogSshSudoPasswordStringProvider", "(Ljava/lang/String;Lcom/intellij/openapi/application/ModalityState;)V", "host", "port", "", "username", "(Ljava/lang/String;ILjava/lang/String;Lcom/intellij/openapi/application/ModalityState;)V", "remoteCredentials", "Lcom/intellij/remote/RemoteCredentials;", "(Lcom/intellij/remote/RemoteCredentials;Lcom/intellij/openapi/application/ModalityState;)V", "sshConfig", "Lcom/intellij/ssh/config/unified/SshConfig;", "(Lcom/intellij/ssh/config/unified/SshConfig;Lcom/intellij/openapi/application/ModalityState;)V", "getModalityState", "()Lcom/intellij/openapi/application/ModalityState;", "serviceName", "provide", "tellThatPreviousPasswordWasWrong", "", "previousPasswordWasWrong", "", "b", "Lcom/intellij/ssh/DialogSshSudoPasswordStringProvider$PasswordDialogResult;", "tryAgainMessage", "PasswordDialogResult", "intellij.platform.ssh.ui"})
public final class DialogSshSudoPasswordStringProvider
implements PasswordStringProvider {
    @NotNull
    private final String sshPath;
    @NotNull
    private final ModalityState modalityState;
    @NotNull
    private final String serviceName;

    @JvmOverloads
    public DialogSshSudoPasswordStringProvider(@NotNull String sshPath, @NotNull ModalityState modalityState) {
        Intrinsics.checkNotNullParameter((Object)sshPath, (String)"sshPath");
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        this.sshPath = sshPath;
        this.modalityState = modalityState;
        this.serviceName = "IDEA sudo for " + this.sshPath;
    }

    public /* synthetic */ DialogSshSudoPasswordStringProvider(String string, ModalityState modalityState, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ModalityState modalityState2 = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState2, (String)"defaultModalityState(...)");
            modalityState = modalityState2;
        }
        this(string, modalityState);
    }

    @NotNull
    public final ModalityState getModalityState() {
        return this.modalityState;
    }

    private DialogSshSudoPasswordStringProvider(String host, int port, String username, ModalityState modalityState) {
        this("ssh://" + username + "@" + (String)(port == 22 ? host : host + ":" + port), modalityState);
    }

    @JvmOverloads
    public DialogSshSudoPasswordStringProvider(@NotNull RemoteCredentials remoteCredentials, @NotNull ModalityState modalityState) {
        Intrinsics.checkNotNullParameter((Object)remoteCredentials, (String)"remoteCredentials");
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        String string = remoteCredentials.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        this(string, remoteCredentials.getPort(), String.valueOf(remoteCredentials.getUserName()), modalityState);
    }

    public /* synthetic */ DialogSshSudoPasswordStringProvider(RemoteCredentials remoteCredentials, ModalityState modalityState, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ModalityState modalityState2 = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState2, (String)"defaultModalityState(...)");
            modalityState = modalityState2;
        }
        this(remoteCredentials, modalityState);
    }

    @JvmOverloads
    public DialogSshSudoPasswordStringProvider(@NotNull SshConfig sshConfig, @NotNull ModalityState modalityState) {
        Intrinsics.checkNotNullParameter((Object)sshConfig, (String)"sshConfig");
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        String string = sshConfig.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        int n = sshConfig.getPort();
        String string2 = sshConfig.getUsername();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUsername(...)");
        this(string, n, string2, modalityState);
    }

    public /* synthetic */ DialogSshSudoPasswordStringProvider(SshConfig sshConfig, ModalityState modalityState, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ModalityState modalityState2 = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState2, (String)"defaultModalityState(...)");
            modalityState = modalityState2;
        }
        this(sshConfig, modalityState);
    }

    @Override
    @Nullable
    public String provide(boolean tellThatPreviousPasswordWasWrong) {
        String string;
        Object object = PasswordSafe.Companion.getInstance().get(new CredentialAttributes(this.serviceName));
        if (object != null && (object = object.getPasswordAsString()) != null) {
            Object object2 = object;
            boolean bl = false;
            if (((CharSequence)object2).length() > 0) {
                return object2;
            }
        }
        PasswordDialogResult passwordDialogResult = this.b(tellThatPreviousPasswordWasWrong);
        if (passwordDialogResult != null) {
            PasswordDialogResult passwordDialogResult2 = passwordDialogResult;
            boolean bl = false;
            char[] cArray = passwordDialogResult2.component1();
            boolean bl2 = passwordDialogResult2.component2();
            Credentials credentials = new Credentials(this.serviceName, cArray);
            PasswordSafe.Companion.getInstance().set(CredentialAttributes.copy$default((CredentialAttributes)new CredentialAttributes(this.serviceName), null, null, (!bl2 ? 1 : 0) != 0, (boolean)false, (int)11, null), credentials);
            string = String.valueOf(credentials.getPassword());
        } else {
            string = null;
        }
        return string;
    }

    @Override
    public void previousPasswordWasWrong() {
        PasswordSafe.Companion.getInstance().set(new CredentialAttributes(this.serviceName), null);
    }

    private final PasswordDialogResult b(boolean bl) {
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        Ref ref2 = ref;
        ApplicationManager.getApplication().invokeAndWait(() -> DialogSshSudoPasswordStringProvider.b(this, ref2, bl), this.modalityState);
        return (PasswordDialogResult)ref2.get();
    }

    @JvmOverloads
    public DialogSshSudoPasswordStringProvider(@NotNull String sshPath) {
        Intrinsics.checkNotNullParameter((Object)sshPath, (String)"sshPath");
        this(sshPath, null, 2, null);
    }

    @JvmOverloads
    public DialogSshSudoPasswordStringProvider(@NotNull RemoteCredentials remoteCredentials) {
        Intrinsics.checkNotNullParameter((Object)remoteCredentials, (String)"remoteCredentials");
        this(remoteCredentials, null, 2, null);
    }

    @JvmOverloads
    public DialogSshSudoPasswordStringProvider(@NotNull SshConfig sshConfig) {
        Intrinsics.checkNotNullParameter((Object)sshConfig, (String)"sshConfig");
        this(sshConfig, null, 2, null);
    }

    private static final Unit b(Ref.ObjectRef objectRef, Ref.ObjectRef objectRef2, JBPasswordField jBPasswordField) {
        JPasswordField jPasswordField;
        DialogWrapper dialogWrapper;
        Intrinsics.checkNotNullParameter((Object)jBPasswordField, (String)"it");
        if (objectRef.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialog");
            dialogWrapper = null;
        } else {
            dialogWrapper = (DialogWrapper)objectRef.element;
        }
        if (objectRef2.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"passwordField");
            jPasswordField = null;
        } else {
            jPasswordField = (JPasswordField)objectRef2.element;
        }
        char[] cArray = jPasswordField.getPassword();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
        dialogWrapper.setOKActionEnabled(!(cArray.length == 0));
        return Unit.INSTANCE;
    }

    private static final Unit b(Row row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"$this$row");
        String string = SshBundle.message("sudo.prompt.try_again", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        row.label(string);
        return Unit.INSTANCE;
    }

    private static final Unit b(Ref.ObjectRef objectRef, Ref.ObjectRef objectRef2, Row row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"$this$row");
        objectRef.element = row.passwordField().align((Align)AlignX.FILL.INSTANCE).focused().onChanged(arg_0 -> DialogSshSudoPasswordStringProvider.b(objectRef2, objectRef, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit b(JCheckBox jCheckBox, Row row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"$this$row");
        row.cell((JComponent)jCheckBox);
        return Unit.INSTANCE;
    }

    private static final Unit b(boolean bl, Ref.ObjectRef objectRef, Ref.ObjectRef objectRef2, JCheckBox jCheckBox, Panel panel) {
        Intrinsics.checkNotNullParameter((Object)panel, (String)"$this$panel");
        if (bl) {
            Panel.row$default((Panel)panel, null, DialogSshSudoPasswordStringProvider::b, (int)1, null);
        }
        String string = SshBundle.message("sudo.prompt.password", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        panel.row(string, arg_0 -> DialogSshSudoPasswordStringProvider.b(objectRef, objectRef2, arg_0));
        Panel.row$default((Panel)panel, null, arg_0 -> DialogSshSudoPasswordStringProvider.b(jCheckBox, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void b(DialogSshSudoPasswordStringProvider dialogSshSudoPasswordStringProvider, Ref ref, boolean bl) {
        PasswordDialogResult passwordDialogResult;
        DialogWrapper dialogWrapper;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        JCheckBox jCheckBox = RememberCheckBoxState.INSTANCE.createCheckBox(SshBundle.message("password.dialog.remember.tooltip", new Object[0]));
        DialogPanel dialogPanel = BuilderKt.panel(arg_0 -> DialogSshSudoPasswordStringProvider.b(bl, objectRef2, objectRef, jCheckBox, arg_0));
        AppIcon.getInstance().requestAttention(null, true);
        Object[] objectArray = new Object[]{dialogSshSudoPasswordStringProvider.sshPath};
        String string = SshBundle.message("sudo.dialog.title.password_for", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectRef.element = ComponentsKt.dialog$default((String)string, (JComponent)((JComponent)dialogPanel), (boolean)false, null, (boolean)false, null, null, null, null, null, null, (int)1996, null);
        if (objectRef.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialog");
            dialogWrapper = null;
        } else {
            dialogWrapper = (DialogWrapper)objectRef.element;
        }
        if (dialogWrapper.showAndGet()) {
            JPasswordField jPasswordField;
            RememberCheckBoxState.update((JCheckBox)jCheckBox);
            if (objectRef2.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"passwordField");
                jPasswordField = null;
            } else {
                jPasswordField = (JPasswordField)objectRef2.element;
            }
            char[] cArray = jPasswordField.getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
            passwordDialogResult = new PasswordDialogResult(cArray, jCheckBox.isSelected());
        } else {
            passwordDialogResult = null;
        }
        ref.set(passwordDialogResult);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\t\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\r\u001a\u00020\u000eH\u00d6\u0081\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u00d6\u0081\u0004R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ssh/DialogSshSudoPasswordStringProvider$PasswordDialogResult;", "", "password", "", "remember", "", "DialogSshSudoPasswordStringProvider$PasswordDialogResult", "([CZ)V", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.ssh.ui"})
    private static final class PasswordDialogResult {
        @JvmField
        @NotNull
        public final char[] password;
        @JvmField
        public final boolean remember;

        public PasswordDialogResult(@NotNull char[] password, boolean remember) {
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            this.password = password;
            this.remember = remember;
        }

        @NotNull
        public final char[] component1() {
            return this.password;
        }

        public final boolean component2() {
            return this.remember;
        }

        @NotNull
        public final PasswordDialogResult copy(@NotNull char[] password, boolean remember) {
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            return new PasswordDialogResult(password, remember);
        }

        public static /* synthetic */ PasswordDialogResult copy$default(PasswordDialogResult passwordDialogResult, char[] cArray, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                cArray = passwordDialogResult.password;
            }
            if ((n & 2) != 0) {
                bl = passwordDialogResult.remember;
            }
            return passwordDialogResult.copy(cArray, bl);
        }

        @NotNull
        public String toString() {
            return "PasswordDialogResult(password=" + Arrays.toString(this.password) + ", remember=" + this.remember + ")";
        }

        public int hashCode() {
            int n = Arrays.hashCode(this.password);
            n = n * 31 + Boolean.hashCode(this.remember);
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PasswordDialogResult)) {
                return false;
            }
            PasswordDialogResult passwordDialogResult = (PasswordDialogResult)other;
            if (!Intrinsics.areEqual((Object)this.password, (Object)passwordDialogResult.password)) {
                return false;
            }
            return this.remember == passwordDialogResult.remember;
        }
    }
}

