/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ssh.AuthFailSshTransportException;
import com.intellij.ssh.ChannelSshTransportException;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshConnectionService;
import com.intellij.ssh.SshException;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshSessionChannelFactory;
import com.intellij.ssh.channels.SshChannel;
import com.intellij.ssh.impl.SshConnection;
import com.intellij.ssh.impl.sshj.SshjConnectionUtilKt;
import com.intellij.ssh.ui.SshConnectionStateListener;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000{\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006*\u0001\u0012\b\u0000\u0018\u0000 62\u00020\u0001:\u00045678B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ1\u0010\u0018\u001a\u0002H\u0019\"\b\b\u0000\u0010\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u0002H\u00190\u001e\u00a2\u0006\u0002\u0010 JC\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\b\b\u0000\u0010\u0019*\u00020\u001a2\u0006\u0010!\u001a\u00020\u001f2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u0002H\u00190\u001e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0014H\u0002\u00a2\u0006\u0002\u0010#JL\u0010$\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u0019\u0012\u0004\u0012\u00020\u00170%\"\b\b\u0000\u0010\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00142\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0006\u0012\u0004\u0018\u0001H\u00190\u001eH\u0002J\u000e\u0010'\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010)\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001a\u0010*\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010+\u001a\u00020\u0017H\u0007J\u0014\u0010,\u001a\u00020-*\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010/\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u00100\u001a\u000201J\f\u00102\u001a\b\u0012\u0004\u0012\u00020(03J\b\u00104\u001a\u000201H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u00100\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\u00120\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/ssh/impl/SshConnection;", "", "userName", "", "host", "port", "", "SshConnection", "(Ljava/lang/String;Ljava/lang/String;I)V", "getUserName", "()Ljava/lang/String;", "getHost", "getPort", "()I", "serveCriticalSection", "Lcom/intellij/ssh/impl/SshConnection$LockCriticalSection;", "Lcom/intellij/ssh/impl/SshConnection$ServeCriticalSection;", "disposeCriticalSection", "com/intellij/ssh/impl/SshConnection$disposeCriticalSection$1", "progressIndicatorOfInstantiatingConnections", "", "Lcom/intellij/openapi/progress/ProgressIndicator;", "disposed", "", "openChannel", "R", "Lcom/intellij/ssh/channels/SshChannel;", "sessionConfig", "Lcom/intellij/ssh/SessionConfig;", "channelCreator", "Lkotlin/Function1;", "Lcom/intellij/ssh/SshSessionChannelFactory;", "(Lcom/intellij/ssh/SessionConfig;Lkotlin/jvm/functions/Function1;)Lcom/intellij/ssh/channels/SshChannel;", "session", "faultySessions", "(Lcom/intellij/ssh/SshSessionChannelFactory;Lkotlin/jvm/functions/Function1;Ljava/util/Set;)Lcom/intellij/ssh/channels/SshChannel;", "b", "Lkotlin/Pair;", "invokeChannelFactory", "connect", "Lcom/intellij/ssh/SshSession;", "getSshSession", "checkCanAuthenticate", "addToPool", "b", "Lcom/intellij/ssh/impl/SshConnection$ChannelFactoryWithSemaphore;", "b", "o", "dispose", "", "getSessions", "", "b", "ServeCriticalSection", "Companion", "ChannelFactoryWithSemaphore", "LockCriticalSection", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nSshConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshConnection.kt\ncom/intellij/ssh/impl/SshConnection\n+ 2 SshConnection.kt\ncom/intellij/ssh/impl/SshConnection$LockCriticalSection\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,381:1\n372#2,5:382\n351#2,10:387\n363#2,15:405\n346#2,3:420\n346#2,3:423\n346#2,2:426\n348#2:432\n346#2,3:433\n372#2,5:436\n351#2,10:441\n346#2,3:451\n363#2,15:454\n346#2,3:469\n350#2,18:472\n777#3:397\n873#3,2:398\n1586#3:428\n1661#3,3:429\n60#4,5:400\n*S KotlinDebug\n*F\n+ 1 SshConnection.kt\ncom/intellij/ssh/impl/SshConnection\n*L\n123#1:382,5\n123#1:387,10\n123#1:405,15\n294#1:420,3\n306#1:423,3\n325#1:426,2\n325#1:432\n129#1:433,3\n178#1:436,5\n178#1:441,10\n188#1:451,3\n178#1:454,15\n232#1:469,3\n257#1:472,18\n136#1:397\n136#1:398,2\n325#1:428\n325#1:429,3\n141#1:400,5\n*E\n"})
public final class SshConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String userName;
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final LockCriticalSection<ServeCriticalSection> serveCriticalSection;
    @NotNull
    private final LockCriticalSection<disposeCriticalSection.1> disposeCriticalSection;
    @NotNull
    private final Set<ProgressIndicator> progressIndicatorOfInstantiatingConnections;
    private volatile boolean disposed;
    @NotNull
    private static final Logger LOG;

    public SshConnection(@NotNull String userName, @NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.userName = userName;
        this.host = host;
        this.port = port;
        this.serveCriticalSection = new LockCriticalSection<ServeCriticalSection>(new ServeCriticalSection(null, 1, null));
        this.disposeCriticalSection = new LockCriticalSection<disposeCriticalSection.1>(new Object(){
            private final List<SshSession> allSessions;
            {
                this.allSessions = new ArrayList<E>();
            }

            public final List<SshSession> getAllSessions() {
                return this.allSessions;
            }
        });
        Set set = Collections.newSetFromMap(ContainerUtil.createConcurrentWeakMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(...)");
        this.progressIndicatorOfInstantiatingConnections = set;
    }

    @NotNull
    public final String getUserName() {
        return this.userName;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final <R extends SshChannel> R openChannel(@NotNull SessionConfig sessionConfig, @NotNull Function1<? super SshSessionChannelFactory, ? extends R> channelCreator) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkNotNullParameter(channelCreator, (String)"channelCreator");
        return (R)((SshChannel)Ssh.wrapBlockingSshCall$default(null, false, () -> SshConnection.b(this, sessionConfig, channelCreator), 3, null));
    }

    private final <R extends SshChannel> R b(SshSessionChannelFactory sshSessionChannelFactory, Function1<? super SshSessionChannelFactory, ? extends R> function1, Set<SshSessionChannelFactory> set) {
        try {
            return sshSessionChannelFactory.openChannel(function1);
        }
        catch (SshException sshException) {
            if (sshException instanceof ChannelSshTransportException) {
                LOG.debug(sshSessionChannelFactory + " refused to create a new channel", (Throwable)((Object)sshException));
                v0 = set.add(sshSessionChannelFactory);
            } else if (ExceptionUtil.causedBy((Throwable)((Throwable)((Object)sshException)), SocketException.class)) {
                LOG.warn("Got error when tried to acquire a channel in session " + sshSessionChannelFactory + ". Probably connection was lost.", (Throwable)((Object)sshException));
                v0 = set.add(sshSessionChannelFactory);
            } else {
                throw sshException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R extends SshChannel> Pair<R, Boolean> b(SessionConfig sessionConfig, Set<SshSessionChannelFactory> set, Function1<? super SshSessionChannelFactory, ? extends R> function1) {
        Pair pair;
        Triple triple;
        Object object = this.serveCriticalSection;
        ProgressIndicator progressIndicator2 = sessionConfig.getProgressIndicator();
        boolean bl = false;
        do {
            Triple triple2;
            Triple triple3;
            ((LockCriticalSection)object).SshConnection.this.b();
            ProgressIndicator progressIndicator3 = progressIndicator2;
            if (progressIndicator3 != null) {
                progressIndicator3.checkCanceled();
            }
            pair = object;
            long l = DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS);
            boolean bl2 = false;
            boolean bl3 = ((LockCriticalSection)pair).lock.tryLock(Duration.getInWholeMilliseconds-impl((long)l), TimeUnit.MILLISECONDS);
            if (bl3) {
                Triple triple4;
                try {
                    Triple triple5;
                    Collection collection;
                    Iterable iterable;
                    Object object2;
                    ServeCriticalSection serveCriticalSection;
                    block15: {
                        serveCriticalSection = pair.get_hidden();
                        boolean bl4 = false;
                        CollectionsKt.removeAll(serveCriticalSection.getSessions(), arg_0 -> SshConnection.b(this, arg_0));
                        object2 = serveCriticalSection.getSessions();
                        boolean bl5 = false;
                        Object object3 = object2;
                        Collection collection22 = new ArrayList();
                        boolean bl6 = false;
                        Iterator iterator = object3.iterator();
                        while (iterator.hasNext()) {
                            Object t = iterator.next();
                            ChannelFactoryWithSemaphore channelFactoryWithSemaphore = (ChannelFactoryWithSemaphore)t;
                            boolean bl7 = false;
                            if (!(!set.contains(channelFactoryWithSemaphore.getChannelFactory()))) continue;
                            collection22.add(t);
                        }
                        iterable = (List)collection22;
                        for (Collection collection22 : iterable) {
                            ChannelFactoryWithSemaphore channelFactoryWithSemaphore = (ChannelFactoryWithSemaphore)((Object)collection22);
                            boolean bl8 = false;
                            if (!(channelFactoryWithSemaphore.getChannelFactory().isConnected() && channelFactoryWithSemaphore.getChannelOpenSemaphore().tryAcquire())) continue;
                            collection = collection22;
                            break block15;
                        }
                        collection = null;
                    }
                    ChannelFactoryWithSemaphore channelFactoryWithSemaphore = (ChannelFactoryWithSemaphore)((Object)collection);
                    if (channelFactoryWithSemaphore == null) {
                        object2 = LOG;
                        iterable = null;
                        boolean bl9 = false;
                        if (object2.isDebugEnabled()) {
                            Iterable iterable2 = object2;
                            boolean bl10 = false;
                            iterable2.debug("Not found a candidate for opening a channel. Faulty sessions number: " + set.size() + ", total active sessions number: " + serveCriticalSection.getSessions().size(), (Throwable)((Object)iterable));
                        }
                        object2 = this.b(serveCriticalSection, sessionConfig);
                        ((ChannelFactoryWithSemaphore)object2).getChannelOpenSemaphore().acquire();
                        triple5 = new Triple((Object)((ChannelFactoryWithSemaphore)object2).getChannelFactory(), (Object)true, (Object)((ChannelFactoryWithSemaphore)object2).getChannelOpenSemaphore());
                    } else {
                        triple5 = new Triple((Object)channelFactoryWithSemaphore.getChannelFactory(), (Object)false, (Object)channelFactoryWithSemaphore.getChannelOpenSemaphore());
                    }
                    triple4 = triple5;
                    ((LockCriticalSection)pair).lock.unlock();
                }
                catch (Throwable throwable) {
                    ((LockCriticalSection)pair).lock.unlock();
                    throw throwable;
                }
                triple3 = triple4;
            } else {
                triple3 = null;
            }
            triple = triple2 = triple3;
        } while (triple == null);
        Triple triple6 = triple;
        object = (SshSessionChannelFactory)triple6.component1();
        boolean bl11 = (Boolean)triple6.component2();
        Semaphore semaphore = (Semaphore)triple6.component3();
        try {
            pair = TuplesKt.to((Object)function1.invoke(object), (Object)bl11);
        }
        finally {
            semaphore.release();
            if (bl11) {
                ((SshConnectionStateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SshConnectionStateListener.Companion.getAUTH_TOPIC())).connectionCreated((SshSession)object);
            }
        }
        return pair;
    }

    @NotNull
    public final SshSession connect(@NotNull SessionConfig sessionConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        return this.getSshSession(sessionConfig);
    }

    @NotNull
    public final SshSession getSshSession(@NotNull SessionConfig sessionConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        return (SshSession)Ssh.wrapBlockingSshCall$default(null, false, () -> SshConnection.b(this, sessionConfig), 3, null);
    }

    @JvmOverloads
    public final boolean checkCanAuthenticate(@NotNull SessionConfig sessionConfig, boolean addToPool) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        return (Boolean)Ssh.wrapBlockingSshCall$default(null, false, () -> SshConnection.b(this, sessionConfig, addToPool), 3, null);
    }

    public static /* synthetic */ boolean checkCanAuthenticate$default(SshConnection sshConnection, SessionConfig sessionConfig, boolean bl, int n, Object object) throws SshException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return sshConnection.checkCanAuthenticate(sessionConfig, bl);
    }

    private final ChannelFactoryWithSemaphore b(ServeCriticalSection serveCriticalSection, SessionConfig sessionConfig) throws SshException {
        return (ChannelFactoryWithSemaphore)Ssh.wrapBlockingSshCall$default(null, false, () -> SshConnection.b(this, sessionConfig, serveCriticalSection), 3, null);
    }

    private final SshSessionChannelFactory b(SessionConfig sessionConfig) {
        Object[] objectArray = new Object[]{sessionConfig.getConnectionConfig().getUser(), sessionConfig.getConnectionConfig().getHost()};
        String string = SshBundle.message("ssh.connecting.to.background.task.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return (SshSessionChannelFactory)Ssh.wrapBlockingSshCall$default(string, false, () -> SshConnection.b(this, sessionConfig), 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SshSessionChannelFactory o(SessionConfig sessionConfig) {
        ProgressIndicator progressIndicator2 = sessionConfig.getProgressIndicator();
        if (progressIndicator2 == null) {
            progressIndicator2 = (ProgressIndicator)new EmptyProgressIndicator();
        }
        Object object = progressIndicator2;
        ProgressWrapper progressWrapper = new ProgressWrapper((ProgressIndicator)object){};
        ((Collection)this.progressIndicatorOfInstantiatingConnections).add(progressWrapper);
        object = SshjConnectionUtilKt.setUpSessionForSshJ(sessionConfig, (ProgressIndicator)progressWrapper);
        LockCriticalSection<disposeCriticalSection.1> lockCriticalSection = this.disposeCriticalSection;
        boolean bl = false;
        Lock lock = ((LockCriticalSection)lockCriticalSection).lock;
        lock.lock();
        try {
            boolean bl2 = false;
            var var8_8 = lockCriticalSection.get_hidden();
            boolean bl3 = false;
            this.b();
            bl2 = var8_8.getAllSessions().add((SshSession)object);
        }
        finally {
            lock.unlock();
        }
        return (SshSessionChannelFactory)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        LockCriticalSection<disposeCriticalSection.1> lockCriticalSection = this.disposeCriticalSection;
        boolean bl = false;
        Lock lock = ((LockCriticalSection)lockCriticalSection).lock;
        lock.lock();
        try {
            boolean bl2 = false;
            disposeCriticalSection.1 var5_6 = lockCriticalSection.get_hidden();
            boolean bl3 = false;
            if (!this.disposed) {
                this.disposed = true;
                LOG.debug("Disconnecting SSH sessions to " + this.userName + "@" + this.host + ":" + this.port);
                for (ProgressIndicator object : this.progressIndicatorOfInstantiatingConnections) {
                    object.cancel();
                }
                for (SshSession sshSession : var5_6.getAllSessions()) {
                    sshSession.disconnect();
                }
                var5_6.getAllSessions().clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<SshSession> getSessions() {
        List list;
        LockCriticalSection<ServeCriticalSection> lockCriticalSection = this.serveCriticalSection;
        boolean bl = false;
        Lock lock = ((LockCriticalSection)lockCriticalSection).lock;
        lock.lock();
        try {
            boolean bl2 = false;
            ServeCriticalSection serveCriticalSection = lockCriticalSection.get_hidden();
            boolean bl3 = false;
            Iterable iterable = serveCriticalSection.getSessions();
            boolean bl4 = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl5 = false;
            for (Object t : iterable2) {
                ChannelFactoryWithSemaphore channelFactoryWithSemaphore = (ChannelFactoryWithSemaphore)t;
                Collection collection2 = collection;
                boolean bl6 = false;
                collection2.add(channelFactoryWithSemaphore.getChannelFactory());
            }
            list = (List)collection;
        }
        finally {
            lock.unlock();
        }
        return list;
    }

    private final void b() {
        if (this.disposed) {
            throw new IllegalStateException("SSH connection to " + this.userName + "@" + this.host + ":" + this.port + " disposed");
        }
    }

    @JvmOverloads
    public final boolean checkCanAuthenticate(@NotNull SessionConfig sessionConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        return SshConnection.checkCanAuthenticate$default(this, sessionConfig, false, 2, null);
    }

    private static final SshChannel b(SshConnection sshConnection, Function1 function1, Set set, SshSessionChannelFactory sshSessionChannelFactory) {
        Intrinsics.checkNotNullParameter((Object)sshSessionChannelFactory, (String)"sessionFactory");
        return sshConnection.b(sshSessionChannelFactory, function1, set);
    }

    private static final SshChannel b(SshConnection sshConnection, SessionConfig sessionConfig, Function1 function1) {
        boolean bl;
        ((SshConnectionService.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SshConnectionService.Companion.getTOPIC())).sessionOrChannelRequested(sshConnection.userName, sshConnection.host, sshConnection.port);
        sshConnection.b();
        ProgressIndicator progressIndicator2 = sessionConfig.getProgressIndicator();
        if (progressIndicator2 != null) {
            progressIndicator2.checkCanceled();
        }
        Set set = new LinkedHashSet();
        do {
            Pair pair = sshConnection.b(sessionConfig, set, arg_0 -> SshConnection.b(sshConnection, function1, set, arg_0));
            SshChannel sshChannel = (SshChannel)pair.component1();
            bl = (Boolean)pair.component2();
            if (sshChannel == null) continue;
            return sshChannel;
        } while (!bl);
        throw new SshException("Failed to open SSH channel in a just created TCP session for " + sshConnection.userName + "@" + sshConnection.host + ":" + sshConnection.port, new Attachment[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean b(SshConnection sshConnection, ChannelFactoryWithSemaphore channelFactoryWithSemaphore) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)channelFactoryWithSemaphore, (String)"session");
        if (channelFactoryWithSemaphore.getChannelFactory().isConnected()) {
            bl = false;
        } else {
            LockCriticalSection<disposeCriticalSection.1> lockCriticalSection = sshConnection.disposeCriticalSection;
            boolean bl2 = false;
            Lock lock = ((LockCriticalSection)lockCriticalSection).lock;
            lock.lock();
            try {
                boolean bl3 = false;
                disposeCriticalSection.1 var6_6 = lockCriticalSection.get_hidden();
                boolean bl4 = false;
                bl3 = var6_6.getAllSessions().remove(channelFactoryWithSemaphore.getChannelFactory());
            }
            finally {
                lock.unlock();
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SshSession b(SshConnection sshConnection, SessionConfig sessionConfig) {
        Pair pair;
        ((SshConnectionService.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SshConnectionService.Companion.getTOPIC())).sessionOrChannelRequested(sshConnection.userName, sshConnection.host, sshConnection.port);
        Object object = sshConnection.serveCriticalSection;
        ProgressIndicator progressIndicator2 = sessionConfig.getProgressIndicator();
        boolean bl = false;
        do {
            Pair pair2;
            Pair pair3;
            ((LockCriticalSection)object).SshConnection.this.b();
            ProgressIndicator progressIndicator3 = progressIndicator2;
            if (progressIndicator3 != null) {
                progressIndicator3.checkCanceled();
            }
            LockCriticalSection<ServeCriticalSection> lockCriticalSection = object;
            long l = DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS);
            boolean bl2 = false;
            boolean bl3 = ((LockCriticalSection)lockCriticalSection).lock.tryLock(Duration.getInWholeMilliseconds-impl((long)l), TimeUnit.MILLISECONDS);
            if (bl3) {
                Pair pair4;
                try {
                    Pair pair5;
                    block13: {
                        ServeCriticalSection serveCriticalSection = lockCriticalSection.get_hidden();
                        boolean bl4 = false;
                        Iterator<ChannelFactoryWithSemaphore> iterator = serveCriticalSection.getSessions().iterator();
                        while (iterator.hasNext()) {
                            ChannelFactoryWithSemaphore channelFactoryWithSemaphore = iterator.next();
                            if (channelFactoryWithSemaphore.getChannelFactory().isConnected()) {
                                pair5 = TuplesKt.to((Object)channelFactoryWithSemaphore.getChannelFactory(), (Object)false);
                                break block13;
                            }
                            iterator.remove();
                            LockCriticalSection<disposeCriticalSection.1> lockCriticalSection2 = sshConnection.disposeCriticalSection;
                            boolean bl5 = false;
                            Lock lock = ((LockCriticalSection)lockCriticalSection2).lock;
                            lock.lock();
                            try {
                                boolean bl6 = false;
                                disposeCriticalSection.1 var19_19 = lockCriticalSection2.get_hidden();
                                boolean bl7 = false;
                                bl6 = var19_19.getAllSessions().remove(channelFactoryWithSemaphore.getChannelFactory());
                            }
                            finally {
                                lock.unlock();
                            }
                        }
                        LOG.debug("No opened sessions to " + sshConnection.userName + "@" + sshConnection.host + ":" + sshConnection.port + " found");
                        pair5 = TuplesKt.to((Object)sshConnection.b(serveCriticalSection, sessionConfig).getChannelFactory(), (Object)true);
                    }
                    pair4 = pair5;
                }
                finally {
                    ((LockCriticalSection)lockCriticalSection).lock.unlock();
                }
                pair3 = pair4;
            } else {
                pair3 = null;
            }
            pair = pair2 = pair3;
        } while (pair == null);
        Pair pair6 = pair;
        object = (SshSessionChannelFactory)pair6.component1();
        boolean bl8 = (Boolean)pair6.component2();
        if (bl8) {
            ((SshConnectionStateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SshConnectionStateListener.Companion.getAUTH_TOPIC())).connectionCreated((SshSession)object);
        }
        return (SshSession)object;
    }

    private static final void b(SshSessionChannelFactory sshSessionChannelFactory) {
        try {
            sshSessionChannelFactory.disconnect();
        }
        catch (Throwable throwable) {
            LOG.info("Error on disconnection while checked if can authenticate. Unlikely it's sufficient.", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void b(SshConnection sshConnection, SshSessionChannelFactory sshSessionChannelFactory) {
        boolean bl;
        LockCriticalSection<ServeCriticalSection> lockCriticalSection = sshConnection.serveCriticalSection;
        boolean bl2 = false;
        Lock lock = ((LockCriticalSection)lockCriticalSection).lock;
        lock.lock();
        try {
            boolean bl3;
            bl = false;
            ServeCriticalSection serveCriticalSection = lockCriticalSection.get_hidden();
            boolean bl4 = false;
            if (serveCriticalSection.getSessions().isEmpty()) {
                serveCriticalSection.getSessions().add(new ChannelFactoryWithSemaphore(sshSessionChannelFactory, null, 2, null));
                bl3 = false;
            } else {
                bl3 = true;
            }
            bl = bl3;
        }
        finally {
            lock.unlock();
        }
        boolean bl5 = bl;
        if (bl5) {
            ProcessIOExecutorService.INSTANCE.execute(() -> SshConnection.b(sshSessionChannelFactory));
        } else {
            ((SshConnectionStateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SshConnectionStateListener.Companion.getAUTH_TOPIC())).connectionCreated(sshSessionChannelFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean b(SshConnection sshConnection, SessionConfig sessionConfig, boolean bl) {
        boolean bl2;
        SshSessionChannelFactory sshSessionChannelFactory;
        LOG.debug("Checking that can authenticate " + sshConnection.userName + "@" + sshConnection.host + ":" + sshConnection.port);
        if (WhenMappings.$EnumSwitchMapping$0[sessionConfig.getSshBackendLibrary().ordinal()] == 1) {
            try {
                sshSessionChannelFactory = sshConnection.b(sessionConfig);
            }
            catch (AuthFailSshTransportException authFailSshTransportException) {
                sshSessionChannelFactory = null;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        SshSessionChannelFactory sshSessionChannelFactory2 = sshSessionChannelFactory;
        if (sshSessionChannelFactory2 != null) {
            if (bl) {
                Unit unit;
                LockCriticalSection<ServeCriticalSection> lockCriticalSection = sshConnection.serveCriticalSection;
                sshSessionChannelFactory = null;
                boolean bl3 = false;
                boolean bl4 = ((LockCriticalSection)lockCriticalSection).lock.tryLock();
                if (bl4) {
                    Unit unit2;
                    try {
                        ServeCriticalSection serveCriticalSection = lockCriticalSection.get_hidden();
                        boolean bl5 = false;
                        SshConnection.b(sshConnection, sshSessionChannelFactory2);
                        unit2 = Unit.INSTANCE;
                    }
                    finally {
                        ((LockCriticalSection)lockCriticalSection).lock.unlock();
                    }
                    unit = unit2;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    ProcessIOExecutorService.INSTANCE.execute(() -> SshConnection.b(sshConnection, sshSessionChannelFactory2));
                }
            }
            bl2 = true;
        } else {
            bl2 = false;
        }
        return bl2;
    }

    private static final ChannelFactoryWithSemaphore b(SshConnection sshConnection, SessionConfig sessionConfig, ServeCriticalSection serveCriticalSection) {
        LOG.debug("Establishing new SSH session to " + sshConnection.userName + "@" + sshConnection.host + ":" + sshConnection.port);
        if (WhenMappings.$EnumSwitchMapping$0[sessionConfig.getSshBackendLibrary().ordinal()] != 1) {
            throw new NoWhenBranchMatchedException();
        }
        ChannelFactoryWithSemaphore channelFactoryWithSemaphore = new ChannelFactoryWithSemaphore(sshConnection.b(sessionConfig), null, 2, null);
        LOG.debug("SSH session @" + Integer.toHexString(channelFactoryWithSemaphore.getChannelFactory().hashCode()) + " established to " + sshConnection.userName + "@" + sshConnection.host + ":" + sshConnection.port);
        sshConnection.b();
        serveCriticalSection.getSessions().add(channelFactoryWithSemaphore);
        return channelFactoryWithSemaphore;
    }

    private static final SshSessionChannelFactory b(SshConnection sshConnection, SessionConfig sessionConfig) {
        return sshConnection.o(sessionConfig);
    }

    static {
        Logger logger = Logger.getInstance(SshConnection.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ssh/impl/SshConnection$ChannelFactoryWithSemaphore;", "", "channelFactory", "Lcom/intellij/ssh/SshSessionChannelFactory;", "channelOpenSemaphore", "Ljava/util/concurrent/Semaphore;", "SshConnection$ChannelFactoryWithSemaphore", "(Lcom/intellij/ssh/SshSessionChannelFactory;Ljava/util/concurrent/Semaphore;)V", "getChannelFactory", "()Lcom/intellij/ssh/SshSessionChannelFactory;", "getChannelOpenSemaphore", "()Ljava/util/concurrent/Semaphore;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ssh"})
    private static final class ChannelFactoryWithSemaphore {
        @NotNull
        private final SshSessionChannelFactory channelFactory;
        @NotNull
        private final Semaphore channelOpenSemaphore;

        public ChannelFactoryWithSemaphore(@NotNull SshSessionChannelFactory channelFactory, @NotNull Semaphore channelOpenSemaphore) {
            Intrinsics.checkNotNullParameter((Object)channelFactory, (String)"channelFactory");
            Intrinsics.checkNotNullParameter((Object)channelOpenSemaphore, (String)"channelOpenSemaphore");
            this.channelFactory = channelFactory;
            this.channelOpenSemaphore = channelOpenSemaphore;
        }

        public /* synthetic */ ChannelFactoryWithSemaphore(SshSessionChannelFactory sshSessionChannelFactory, Semaphore semaphore, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                semaphore = new Semaphore(Companion.b());
            }
            this(sshSessionChannelFactory, semaphore);
        }

        @NotNull
        public final SshSessionChannelFactory getChannelFactory() {
            return this.channelFactory;
        }

        @NotNull
        public final Semaphore getChannelOpenSemaphore() {
            return this.channelOpenSemaphore;
        }

        @NotNull
        public final SshSessionChannelFactory component1() {
            return this.channelFactory;
        }

        @NotNull
        public final Semaphore component2() {
            return this.channelOpenSemaphore;
        }

        @NotNull
        public final ChannelFactoryWithSemaphore copy(@NotNull SshSessionChannelFactory channelFactory, @NotNull Semaphore channelOpenSemaphore) {
            Intrinsics.checkNotNullParameter((Object)channelFactory, (String)"channelFactory");
            Intrinsics.checkNotNullParameter((Object)channelOpenSemaphore, (String)"channelOpenSemaphore");
            return new ChannelFactoryWithSemaphore(channelFactory, channelOpenSemaphore);
        }

        public static /* synthetic */ ChannelFactoryWithSemaphore copy$default(ChannelFactoryWithSemaphore channelFactoryWithSemaphore, SshSessionChannelFactory sshSessionChannelFactory, Semaphore semaphore, int n, Object object) {
            if ((n & 1) != 0) {
                sshSessionChannelFactory = channelFactoryWithSemaphore.channelFactory;
            }
            if ((n & 2) != 0) {
                semaphore = channelFactoryWithSemaphore.channelOpenSemaphore;
            }
            return channelFactoryWithSemaphore.copy(sshSessionChannelFactory, semaphore);
        }

        @NotNull
        public String toString() {
            return "ChannelFactoryWithSemaphore(channelFactory=" + this.channelFactory + ", channelOpenSemaphore=" + this.channelOpenSemaphore + ")";
        }

        public int hashCode() {
            int n = this.channelFactory.hashCode();
            n = n * 31 + this.channelOpenSemaphore.hashCode();
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChannelFactoryWithSemaphore)) {
                return false;
            }
            ChannelFactoryWithSemaphore channelFactoryWithSemaphore = (ChannelFactoryWithSemaphore)other;
            if (!Intrinsics.areEqual((Object)this.channelFactory, (Object)channelFactoryWithSemaphore.channelFactory)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.channelOpenSemaphore, (Object)channelFactoryWithSemaphore.channelOpenSemaphore);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ssh/impl/SshConnection$Companion;", "", "SshConnection$Companion", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MAX_OPENING_CHANNELS_PER_SESSION", "", "b", "()I", "intellij.platform.ssh"})
    public static final class Companion {
        private Companion() {
        }

        private final int b() {
            return Registry.Companion.intValue("ssh.max.concurrent.channel.creations.per.session");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0001\u0010\f2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\f0\u000e\u00a2\u0006\u0002\b\u000fH\u0086\n\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010JD\u0010\u0011\u001a\u0004\u0018\u0001H\f\"\b\b\u0001\u0010\f*\u00020\u00022\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\f0\u000e\u00a2\u0006\u0002\b\u000fH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J>\u0010\u0017\u001a\u0002H\f\"\b\b\u0001\u0010\f*\u00020\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\f0\u000e\u00a2\u0006\u0002\b\u000fH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ssh/impl/SshConnection$LockCriticalSection;", "Hidden", "", "_hidden", "SshConnection$LockCriticalSection", "(Lcom/intellij/ssh/impl/SshConnection;Ljava/lang/Object;)V", "get_hidden", "()Ljava/lang/Object;", "Ljava/lang/Object;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "invoke", "T", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "tryUse", "timeout", "Lkotlin/time/Duration;", "body", "tryUse-dnQKTGw", "(Lkotlin/time/Duration;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "withLockInterruptible", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "handler", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.platform.ssh"})
    @SourceDebugExtension(value={"SMAP\nSshConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshConnection.kt\ncom/intellij/ssh/impl/SshConnection$LockCriticalSection\n*L\n1#1,381:1\n351#1,17:382\n*S KotlinDebug\n*F\n+ 1 SshConnection.kt\ncom/intellij/ssh/impl/SshConnection$LockCriticalSection\n*L\n376#1:382,17\n*E\n"})
    private final class LockCriticalSection<Hidden> {
        @NotNull
        private final Hidden _hidden;
        @NotNull
        private final ReentrantLock lock;

        public LockCriticalSection(Hidden _hidden) {
            Intrinsics.checkNotNullParameter(_hidden, (String)"_hidden");
            this._hidden = _hidden;
            this.lock = new ReentrantLock();
        }

        @NotNull
        public final Hidden get_hidden() {
            return this._hidden;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T invoke(@NotNull Function1<? super Hidden, ? extends T> block) {
            Object object;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean bl = false;
            Lock lock = this.lock;
            lock.lock();
            try {
                boolean bl2 = false;
                object = block.invoke(this.get_hidden());
            }
            finally {
                InlineMarker.finallyStart((int)1);
                lock.unlock();
                InlineMarker.finallyEnd((int)1);
            }
            return (T)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final <T> T tryUse-dnQKTGw(@Nullable Duration timeout, @NotNull Function1<? super Hidden, ? extends T> body) {
            Object object;
            boolean bl;
            Intrinsics.checkNotNullParameter(body, (String)"body");
            boolean bl2 = false;
            boolean bl3 = bl = timeout == null ? this.lock.tryLock() : this.lock.tryLock(Duration.getInWholeMilliseconds-impl((long)timeout.unbox-impl()), TimeUnit.MILLISECONDS);
            if (bl) {
                Object object2;
                try {
                    object2 = body.invoke(this.get_hidden());
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    this.lock.unlock();
                    InlineMarker.finallyEnd((int)1);
                }
                object = object2;
            } else {
                object = null;
            }
            return (T)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static /* synthetic */ Object tryUse-dnQKTGw$default(LockCriticalSection $this, Duration timeout, Function1 body, int n, Object object) {
            Object object2;
            boolean locked;
            if ((n & 1) != 0) {
                timeout = null;
            }
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            boolean bl = false;
            boolean bl2 = locked = timeout == null ? $this.lock.tryLock() : $this.lock.tryLock(Duration.getInWholeMilliseconds-impl((long)timeout.unbox-impl()), TimeUnit.MILLISECONDS);
            if (locked) {
                Object object3;
                try {
                    object3 = body.invoke($this.get_hidden());
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    $this.lock.unlock();
                    InlineMarker.finallyEnd((int)1);
                }
                object2 = object3;
            } else {
                object2 = null;
            }
            return object2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final <T> T withLockInterruptible(@Nullable ProgressIndicator progressIndicator2, @NotNull Function1<? super Hidden, ? extends T> handler) {
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            boolean bl = false;
            while (true) {
                Object object;
                Object object2;
                SshConnection.this.b();
                ProgressIndicator progressIndicator3 = progressIndicator2;
                if (progressIndicator3 != null) {
                    progressIndicator3.checkCanceled();
                }
                LockCriticalSection lockCriticalSection = this;
                long l = DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS);
                boolean bl2 = false;
                boolean bl3 = lockCriticalSection.lock.tryLock(Duration.getInWholeMilliseconds-impl((long)l), TimeUnit.MILLISECONDS);
                if (bl3) {
                    Object object3;
                    try {
                        object3 = handler.invoke(lockCriticalSection.get_hidden());
                    }
                    finally {
                        InlineMarker.finallyStart((int)1);
                        lockCriticalSection.lock.unlock();
                        InlineMarker.finallyEnd((int)1);
                    }
                    object2 = object3;
                } else {
                    object2 = null;
                }
                Object object4 = object = object2;
                if (object4 == null) continue;
                return (T)object4;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ssh/impl/SshConnection$ServeCriticalSection;", "", "sessions", "", "Lcom/intellij/ssh/impl/SshConnection$ChannelFactoryWithSemaphore;", "SshConnection$ServeCriticalSection", "(Ljava/util/List;)V", "getSessions", "()Ljava/util/List;", "intellij.platform.ssh"})
    private static final class ServeCriticalSection {
        @NotNull
        private final List<ChannelFactoryWithSemaphore> sessions;

        public ServeCriticalSection(@NotNull List<ChannelFactoryWithSemaphore> sessions) {
            Intrinsics.checkNotNullParameter(sessions, (String)"sessions");
            this.sessions = sessions;
        }

        public /* synthetic */ ServeCriticalSection(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = new ArrayList();
            }
            this(list);
        }

        @NotNull
        public final List<ChannelFactoryWithSemaphore> getSessions() {
            return this.sessions;
        }

        public ServeCriticalSection() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SshBackendLibrary.values().length];
            try {
                nArray[SshBackendLibrary.SSHJ.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

