/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj.channels;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ssh.RemoteFileObject;
import com.intellij.ssh.SftpChannelException;
import com.intellij.ssh.SftpProgressTracker;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.ssh.impl.sshj.SshjRemoteFileObject;
import com.intellij.ssh.impl.sshj.SshjSshConnection;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.ssh.impl.sshj.channels.PatchedFileSystemFile;
import com.intellij.ssh.impl.sshj.channels.ProgressTrackerListener;
import com.intellij.ssh.impl.sshj.channels.SshjSftpChannelKt;
import com.intellij.ssh.impl.sshj.channels.SshjSshChannel;
import com.intellij.util.PathUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.sftp.SFTPFileTransfer;
import net.schmizz.sshj.xfer.FilePermission;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import net.schmizz.sshj.xfer.TransferListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 @2\u00020\u00012\u00020\u0002:\u0001@B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJB\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\fH\u0002J:\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001aH\u0016J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\fH\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020\fH\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010%\u001a\u00020\fH\u0016J\u0018\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u001cH\u0016J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\fH\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010%\u001a\u00020\fH\u0016J\u0010\u0010.\u001a\u00020-2\u0006\u0010%\u001a\u00020\fH\u0016J\u0018\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\fH\u0016J\u0010\u00102\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\fH\u0016J\u0010\u00103\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\fH\u0016J\u0018\u00104\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\f2\u0006\u00105\u001a\u00020-H\u0016J\u0010\u00106\u001a\u00020\f2\u0006\u0010%\u001a\u00020\fH\u0016J\u0010\u00107\u001a\u00020\f2\u0006\u0010%\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u0002082\u0006\u0010%\u001a\u00020\fH\u0016J\u0010\u00109\u001a\u0002082\u0006\u0010%\u001a\u00020\fH\u0016J4\u0010:\u001a\u0002H;\"\u0004\b\u0000\u0010;2\u0006\u0010<\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H;0>H\u0082\b\u00a2\u0006\u0002\u0010?R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006A"}, d2={"Lcom/intellij/ssh/impl/sshj/channels/SshjSftpChannel;", "Lcom/intellij/ssh/channels/SftpChannel;", "Lcom/intellij/ssh/impl/sshj/channels/SshjSshChannel;", "sshConnection", "Lcom/intellij/ssh/impl/sshj/SshjSshConnection;", "channel", "Lnet/schmizz/sshj/connection/channel/Channel;", "sftp", "Lnet/schmizz/sshj/sftp/SFTPClient;", "SshjSftpChannel", "(Lcom/intellij/ssh/impl/sshj/SshjSshConnection;Lnet/schmizz/sshj/connection/channel/Channel;Lnet/schmizz/sshj/sftp/SFTPClient;)V", "home", "", "getHome", "()Ljava/lang/String;", "home$delegate", "Lkotlin/Lazy;", "uploadFileOrDir", "", "file", "Ljava/io/File;", "remoteDir", "relativePath", "progressTracker", "Lcom/intellij/ssh/SftpProgressTracker;", "filesFilter", "Ljava/util/function/Predicate;", "persistExecutableBit", "", "b", "destinationPath", "downloadFileOrDir", "remotePath", "localPath", "ls", "", "Lcom/intellij/ssh/channels/SftpChannel$FileInfo;", "path", "inputStream", "Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "append", "mkdir", "lstat", "Lcom/intellij/ssh/channels/SftpChannel$Attrs;", "stat", "rename", "oldPath", "newPath", "rm", "rmdir", "setAttr", "attrs", "readlink", "canonicalize", "Lcom/intellij/ssh/RemoteFileObject;", "nonExistentFile", "b", "T", "baseDirectory", "handler", "Lkotlin/Function0;", "(Ljava/io/File;Lcom/intellij/ssh/SftpProgressTracker;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nSshjSftpChannel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshjSftpChannel.kt\ncom/intellij/ssh/impl/sshj/channels/SshjSftpChannel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Util.kt\ncom/intellij/ssh/impl/sshj/UtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,268:1\n219#1,3:269\n222#1:273\n225#1:309\n1#2:272\n1#2:768\n41#3,35:274\n41#3,35:310\n41#3,6:345\n48#3,28:355\n41#3,35:383\n41#3,35:418\n41#3,35:453\n41#3,35:488\n41#3,35:523\n41#3,35:558\n41#3,35:593\n41#3,35:628\n41#3,35:663\n41#3,35:698\n41#3,35:733\n1586#4:351\n1661#4,3:352\n*S KotlinDebug\n*F\n+ 1 SshjSftpChannel.kt\ncom/intellij/ssh/impl/sshj/channels/SshjSftpChannel\n*L\n43#1:269,3\n43#1:273\n43#1:309\n43#1:272\n44#1:274,35\n95#1:310,35\n99#1:345,6\n99#1:355,28\n103#1:383,35\n121#1:418,35\n173#1:453,35\n177#1:488,35\n181#1:523,35\n185#1:558,35\n189#1:593,35\n193#1:628,35\n197#1:663,35\n206#1:698,35\n210#1:733,35\n100#1:351\n100#1:352,3\n*E\n"})
public final class SshjSftpChannel
extends SshjSshChannel
implements SftpChannel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SFTPClient sftp;
    @NotNull
    private final Lazy home$delegate;

    public SshjSftpChannel(@NotNull SshjSshConnection sshConnection, @NotNull Channel channel2, @NotNull SFTPClient sftp) {
        Intrinsics.checkNotNullParameter((Object)sshConnection, (String)"sshConnection");
        Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)sftp, (String)"sftp");
        super(sshConnection, channel2);
        this.sftp = sftp;
        this.home$delegate = LazyKt.lazy(() -> SshjSftpChannel.b(this));
    }

    @Override
    @NotNull
    public String getHome() {
        Lazy lazy = this.home$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (String)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadFileOrDir(@NotNull File file, @NotNull String remoteDir, @NotNull String relativePath, @Nullable SftpProgressTracker progressTracker, @Nullable Predicate<File> filesFilter, boolean persistExecutableBit) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)remoteDir, (String)"remoteDir");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        SshjSftpChannel sshjSftpChannel = this;
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = new File("/");
        }
        File file3 = file2;
        SftpProgressTracker sftpProgressTracker = progressTracker;
        boolean bl = false;
        TransferListener transferListener = sshjSftpChannel.sftp.getFileTransfer().getTransferListener();
        try {
            ProgressTrackerListener progressTrackerListener;
            SFTPFileTransfer sFTPFileTransfer = sshjSftpChannel.sftp.getFileTransfer();
            SftpProgressTracker sftpProgressTracker2 = sftpProgressTracker;
            if (sftpProgressTracker2 != null) {
                SftpProgressTracker sftpProgressTracker3 = sftpProgressTracker2;
                SFTPFileTransfer sFTPFileTransfer2 = sFTPFileTransfer;
                boolean bl2 = false;
                progressTrackerListener = new ProgressTrackerListener(file3, sftpProgressTracker3);
                sFTPFileTransfer = sFTPFileTransfer2;
            } else {
                progressTrackerListener = null;
            }
            sFTPFileTransfer.setTransferListener((TransferListener)progressTrackerListener);
            boolean bl3 = false;
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            String string2 = string;
            boolean bl4 = true;
            boolean bl5 = true;
            boolean bl6 = false;
            boolean bl7 = bl4;
            boolean bl8 = bl5;
            boolean bl9 = false;
            try {
                boolean bl10 = false;
                Object object = new char[]{'/'};
                String string3 = FileUtil.toCanonicalPath((String)(StringsKt.trimEnd((String)remoteDir, (char[])object) + "/" + relativePath), (char)'/');
                SftpChannel sftpChannel2 = this;
                object = file.isDirectory() ? string3 : PathUtil.getParentPath((String)string3);
                Intrinsics.checkNotNull((Object)object);
                UtilKt.createDirectories(sftpChannel2, (String)object);
                if (filesFilter != null) {
                    this.sftp.getFileTransfer().setUploadFilter(arg_0 -> SshjSftpChannel.b(filesFilter, progressTracker, arg_0));
                }
                object = new FileSystemFile(file);
                this.sftp.put((LocalSourceFile)object, string3);
                if (persistExecutableBit) {
                    Intrinsics.checkNotNull((Object)string3);
                    this.b(file, string3);
                }
                this.sftp.getFileTransfer().setUploadFilter(null);
                Unit unit = Unit.INSTANCE;
            }
            catch (SFTPException sFTPException) {
                Object object = (IOException)((Object)sFTPException);
                boolean bl11 = false;
                object = "File " + string2 + ": " + ((Throwable)object).getMessage();
                Response.StatusCode statusCode = sFTPException.getStatusCode();
                switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                    case 1: {
                        if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                            UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                        }
                        UtilKt.getSSHJ_LOG().info((String)object);
                        break;
                    }
                    case 2: {
                        if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                            UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                        }
                        UtilKt.getSSHJ_LOG().warn((String)object);
                        break;
                    }
                    default: {
                        UtilKt.getSSHJ_LOG().warn((String)object, (Throwable)sFTPException);
                    }
                }
                throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                boolean bl12 = false;
                String string4 = "File " + string2 + ": " + iOException2.getMessage();
                UtilKt.getSSHJ_LOG().warn(string4, (Throwable)iOException);
                throw SftpChannelException.Companion.create(-1, string4, iOException);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            sshjSftpChannel.sftp.getFileTransfer().setTransferListener(transferListener);
        }
    }

    private final void b(File file, String string) {
        if (Companion.shouldSetExecutableBit(file)) {
            return;
        }
        FileAttributes fileAttributes = this.sftp.stat(string);
        if (!fileAttributes.getPermissions().contains(FilePermission.USR_X)) {
            Set set = new LinkedHashSet();
            Set set2 = fileAttributes.getPermissions();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getPermissions(...)");
            set.addAll(set2);
            set.add(FilePermission.USR_X);
            FileAttributes fileAttributes2 = new FileAttributes.Builder().withAtimeMtime(fileAttributes.getAtime(), fileAttributes.getMtime()).withPermissions(set).withSize(fileAttributes.getSize()).withType(fileAttributes.getType()).withUIDGID(fileAttributes.getUID(), fileAttributes.getGID()).build();
            this.sftp.setattr(string, fileAttributes2);
        }
    }

    @Override
    public void uploadFileOrDir(@NotNull File file, @NotNull String remoteDir, @NotNull String relativePath, @Nullable SftpProgressTracker progressTracker, @Nullable Predicate<File> filesFilter) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)remoteDir, (String)"remoteDir");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        this.uploadFileOrDir(file, remoteDir, relativePath, progressTracker, filesFilter, false);
    }

    @Override
    public void downloadFileOrDir(@NotNull String remotePath, @NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        String string = remotePath;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = bl;
        boolean bl5 = bl2;
        boolean bl6 = false;
        try {
            boolean bl7 = false;
            this.sftp.getFileTransfer().download(remotePath, (LocalDestFile)new PatchedFileSystemFile(localPath));
            Unit unit = Unit.INSTANCE;
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl8 = false;
            object = "File " + string + ": " + ((Throwable)object).getMessage();
            Response.StatusCode statusCode = sFTPException.getStatusCode();
            switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                case 1: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                    }
                    UtilKt.getSSHJ_LOG().info((String)object);
                    break;
                }
                case 2: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                    }
                    UtilKt.getSSHJ_LOG().warn((String)object);
                    break;
                }
                default: {
                    UtilKt.getSSHJ_LOG().warn((String)object, (Throwable)sFTPException);
                }
            }
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl9 = false;
            String string2 = "File " + string + ": " + iOException2.getMessage();
            UtilKt.getSSHJ_LOG().warn(string2, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string2, iOException);
        }
    }

    @Override
    @NotNull
    public List<SftpChannel.FileInfo> ls(@NotNull String path2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String string = path2;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = bl2;
        boolean bl5 = bl;
        boolean bl6 = false;
        try {
            boolean bl7 = false;
            List list2 = this.sftp.ls(path2);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ls(...)");
            Iterable iterable = list2;
            boolean bl8 = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl9 = false;
            for (Object t : iterable2) {
                RemoteResourceInfo remoteResourceInfo = (RemoteResourceInfo)t;
                Collection collection2 = collection;
                boolean bl10 = false;
                String string2 = remoteResourceInfo.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                FileAttributes fileAttributes = remoteResourceInfo.getAttributes();
                Intrinsics.checkNotNull((Object)fileAttributes);
                collection2.add(new SftpChannel.FileInfo(string2, SshjSftpChannelKt.access$toAttrs(fileAttributes)));
            }
            list = (List)collection;
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl11 = false;
            object = "File " + string + ": " + ((Throwable)object).getMessage();
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl12 = false;
            String string3 = "File " + string + ": " + iOException2.getMessage();
            UtilKt.getSSHJ_LOG().warn(string3, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string3, iOException);
        }
        return list;
    }

    @Override
    @NotNull
    public InputStream inputStream(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String string = path2;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = bl2;
        boolean bl5 = bl;
        boolean bl6 = false;
        try {
            boolean bl7 = false;
            RemoteFile remoteFile = this.sftp.open(path2, (Set)EnumSet.of((Enum)OpenMode.READ));
            Intrinsics.checkNotNull((Object)remoteFile);
            RemoteFile.RemoteFileInputStream remoteFileInputStream = new RemoteFile.RemoteFileInputStream(remoteFile);
            return new InputStream(remoteFile, remoteFileInputStream){
                final /* synthetic */ RemoteFile $remoteFile;
                final /* synthetic */ RemoteFile.RemoteFileInputStream $delegateStream;
                {
                    this.$remoteFile = $remoteFile;
                    this.$delegateStream = $delegateStream;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() {
                    Closeable closeable = (Closeable)this.$remoteFile;
                    RemoteFile.RemoteFileInputStream remoteFileInputStream = this.$delegateStream;
                    Throwable throwable = null;
                    try {
                        RemoteFile remoteFile = (RemoteFile)closeable;
                        boolean bl = false;
                        remoteFileInputStream.close();
                        remoteFile = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }

                public int read() {
                    return this.$delegateStream.read();
                }

                public int read(byte[] b, int off, int len) {
                    Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                    return this.$delegateStream.read(b, off, len);
                }
            };
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl8 = false;
            object = "File " + string + ": " + ((Throwable)object).getMessage();
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl9 = false;
            String string2 = "File " + string + ": " + iOException2.getMessage();
            UtilKt.getSSHJ_LOG().warn(string2, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string2, iOException);
        }
    }

    @Override
    @NotNull
    public OutputStream outputStream(@NotNull String path2, boolean append) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String string = path2;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = bl2;
        boolean bl5 = bl;
        boolean bl6 = false;
        try {
            boolean bl7 = false;
            EnumSet<Enum> enumSet = EnumSet.of((Enum)OpenMode.CREAT, (Enum)OpenMode.WRITE, (Enum)(append ? OpenMode.APPEND : OpenMode.TRUNC));
            SshjSftpChannel sshjSftpChannel = this;
            boolean bl8 = false;
            String string2 = sshjSftpChannel.getSshConnection().getSshjBackend$intellij_platform_ssh().getTransport().getServerVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getServerVersion(...)");
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String string4 = string3;
            int n = StringsKt.contains$default((CharSequence)string4, (CharSequence)"openssh", (boolean)false, (int)2, null) ? 131072 : (StringsKt.contains$default((CharSequence)string4, (CharSequence)"dropbear", (boolean)false, (int)2, null) ? 4096 : 65536);
            RemoteFile remoteFile = this.sftp.open(path2, (Set)enumSet);
            Intrinsics.checkNotNull((Object)remoteFile);
            sshjSftpChannel = new RemoteFile.RemoteFileOutputStream(remoteFile, 0L, 50);
            return new OutputStream(remoteFile, (RemoteFile.RemoteFileOutputStream)sshjSftpChannel, n){
                final /* synthetic */ RemoteFile $remoteFile;
                final /* synthetic */ RemoteFile.RemoteFileOutputStream $delegate;
                final /* synthetic */ int $maxChunkSize;
                {
                    this.$remoteFile = $remoteFile;
                    this.$delegate = $delegate;
                    this.$maxChunkSize = $maxChunkSize;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() {
                    Closeable closeable = (Closeable)this.$remoteFile;
                    RemoteFile.RemoteFileOutputStream remoteFileOutputStream = this.$delegate;
                    Throwable throwable = null;
                    try {
                        RemoteFile remoteFile = (RemoteFile)closeable;
                        boolean bl = false;
                        remoteFileOutputStream.close();
                        remoteFile = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }

                public void flush() {
                    this.$delegate.flush();
                }

                public void write(int b) {
                    throw new IllegalStateException("Please don't write to streams byte by byte. This error is easier to debug than performance degradations.".toString());
                }

                public void write(byte[] b, int off, int len) {
                    int n;
                    Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                    int n2 = off + len;
                    int n3 = off;
                    do {
                        n = Math.min(n2 - n3, this.$maxChunkSize);
                        this.$delegate.write(b, n3, n);
                    } while ((n3 += n) < n2);
                }
            };
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl9 = false;
            object = "File " + string + ": " + ((Throwable)object).getMessage();
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl10 = false;
            String string5 = "File " + string + ": " + iOException2.getMessage();
            UtilKt.getSSHJ_LOG().warn(string5, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string5, iOException);
        }
    }

    @Override
    public void mkdir(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String string = path2;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = bl2;
        boolean bl5 = bl;
        boolean bl6 = false;
        try {
            boolean bl7 = false;
            this.sftp.mkdir(path2);
            Unit unit = Unit.INSTANCE;
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl8 = false;
            object = "File " + string + ": " + ((Throwable)object).getMessage();
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl9 = false;
            String string2 = "File " + string + ": " + iOException2.getMessage();
            UtilKt.getSSHJ_LOG().warn(string2, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string2, iOException);
        }
    }

    @Override
    @NotNull
    public SftpChannel.Attrs lstat(@NotNull String path2) {
        SftpChannel.Attrs attrs;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String string = path2;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = bl2;
        boolean bl5 = bl;
        boolean bl6 = false;
        try {
            boolean bl7 = false;
            FileAttributes fileAttributes = this.sftp.lstat(path2);
            Intrinsics.checkNotNullExpressionValue((Object)fileAttributes, (String)"lstat(...)");
            attrs = SshjSftpChannelKt.access$toAttrs(fileAttributes);
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl8 = false;
            object = "File " + string + ": " + ((Throwable)object).getMessage();
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl9 = false;
            String string2 = "File " + string + ": " + iOException2.getMessage();
            UtilKt.getSSHJ_LOG().warn(string2, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string2, iOException);
        }
        return attrs;
    }

    @Override
    @NotNull
    public SftpChannel.Attrs stat(@NotNull String path2) {
        SftpChannel.Attrs attrs;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String string = path2;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = bl2;
        boolean bl5 = bl;
        boolean bl6 = false;
        try {
            boolean bl7 = false;
            FileAttributes fileAttributes = this.sftp.stat(path2);
            Intrinsics.checkNotNullExpressionValue((Object)fileAttributes, (String)"stat(...)");
            attrs = SshjSftpChannelKt.access$toAttrs(fileAttributes);
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl8 = false;
            object = "File " + string + ": " + ((Throwable)object).getMessage();
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl9 = false;
            String string2 = "File " + string + ": " + iOException2.getMessage();
            UtilKt.getSSHJ_LOG().warn(string2, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string2, iOException);
        }
        return attrs;
    }

    @Override
    public void rename(@NotNull String oldPath, @NotNull String newPath) {
        Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
        Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
        String string = oldPath;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = bl2;
        boolean bl5 = bl;
        boolean bl6 = false;
        try {
            boolean bl7 = false;
            this.sftp.rename(oldPath, newPath);
            Unit unit = Unit.INSTANCE;
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl8 = false;
            object = "File " + string + ": " + ((Throwable)object).getMessage();
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl9 = false;
            String string2 = "File " + string + ": " + iOException2.getMessage();
            UtilKt.getSSHJ_LOG().warn(string2, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string2, iOException);
        }
    }

    @Override
    public void rm(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String string = path2;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = bl2;
        boolean bl5 = bl;
        boolean bl6 = false;
        try {
            boolean bl7 = false;
            this.sftp.rm(path2);
            Unit unit = Unit.INSTANCE;
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl8 = false;
            object = "File " + string + ": " + ((Throwable)object).getMessage();
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl9 = false;
            String string2 = "File " + string + ": " + iOException2.getMessage();
            UtilKt.getSSHJ_LOG().warn(string2, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string2, iOException);
        }
    }

    @Override
    public void rmdir(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String string = path2;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = bl2;
        boolean bl5 = bl;
        boolean bl6 = false;
        try {
            boolean bl7 = false;
            this.sftp.rmdir(path2);
            Unit unit = Unit.INSTANCE;
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl8 = false;
            object = "File " + string + ": " + ((Throwable)object).getMessage();
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl9 = false;
            String string2 = "File " + string + ": " + iOException2.getMessage();
            UtilKt.getSSHJ_LOG().warn(string2, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string2, iOException);
        }
    }

    @Override
    public void setAttr(@NotNull String path2, @NotNull SftpChannel.Attrs attrs) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        String string = path2;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = bl2;
        boolean bl5 = bl;
        boolean bl6 = false;
        try {
            boolean bl7 = false;
            this.sftp.setattr(path2, new FileAttributes.Builder().withPermissions(attrs.getPermissions()).withSize(attrs.getSize()).withUIDGID(attrs.getUid(), attrs.getGid()).withAtimeMtime(attrs.getAtime(), attrs.getMtime()).build());
            Unit unit = Unit.INSTANCE;
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl8 = false;
            object = "File " + string + ": " + ((Throwable)object).getMessage();
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl9 = false;
            String string2 = "File " + string + ": " + iOException2.getMessage();
            UtilKt.getSSHJ_LOG().warn(string2, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string2, iOException);
        }
    }

    @Override
    @NotNull
    public String readlink(@NotNull String path2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String string2 = path2;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = bl2;
        boolean bl5 = bl;
        boolean bl6 = false;
        try {
            boolean bl7 = false;
            string = this.sftp.readlink(path2);
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl8 = false;
            object = "File " + string2 + ": " + ((Throwable)object).getMessage();
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl9 = false;
            String string3 = "File " + string2 + ": " + iOException2.getMessage();
            UtilKt.getSSHJ_LOG().warn(string3, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string3, iOException);
        }
        String string4 = string;
        Intrinsics.checkNotNull((Object)string4);
        return string4;
    }

    @Override
    @NotNull
    public String canonicalize(@NotNull String path2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String string2 = path2;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = bl2;
        boolean bl5 = bl;
        boolean bl6 = false;
        try {
            boolean bl7 = false;
            string = this.sftp.canonicalize(path2);
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl8 = false;
            object = "File " + string2 + ": " + ((Throwable)object).getMessage();
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl9 = false;
            String string3 = "File " + string2 + ": " + iOException2.getMessage();
            UtilKt.getSSHJ_LOG().warn(string3, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string3, iOException);
        }
        String string4 = string;
        Intrinsics.checkNotNull((Object)string4);
        return string4;
    }

    @Override
    @NotNull
    public RemoteFileObject file(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return new SshjRemoteFileObject(this.sftp, path2, this.toString(), false, 8, null);
    }

    @Override
    @NotNull
    public RemoteFileObject nonExistentFile(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return new SshjRemoteFileObject(this.sftp, path2, this.toString(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T b(File file, SftpProgressTracker sftpProgressTracker, Function0<? extends T> function0) {
        boolean bl = false;
        TransferListener transferListener = this.sftp.getFileTransfer().getTransferListener();
        try {
            ProgressTrackerListener progressTrackerListener;
            SFTPFileTransfer sFTPFileTransfer = this.sftp.getFileTransfer();
            SftpProgressTracker sftpProgressTracker2 = sftpProgressTracker;
            if (sftpProgressTracker2 != null) {
                SftpProgressTracker sftpProgressTracker3 = sftpProgressTracker2;
                SFTPFileTransfer sFTPFileTransfer2 = sFTPFileTransfer;
                boolean bl2 = false;
                progressTrackerListener = new ProgressTrackerListener(file, sftpProgressTracker3);
                sFTPFileTransfer = sFTPFileTransfer2;
            } else {
                progressTrackerListener = null;
            }
            sFTPFileTransfer.setTransferListener((TransferListener)progressTrackerListener);
            Object object = function0.invoke();
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.sftp.getFileTransfer().setTransferListener(transferListener);
            InlineMarker.finallyEnd((int)1);
        }
    }

    private static final String b(SshjSftpChannel sshjSftpChannel) {
        return sshjSftpChannel.sftp.canonicalize("");
    }

    private static final boolean b(Predicate predicate, SftpProgressTracker sftpProgressTracker, LocalSourceFile localSourceFile) {
        if (localSourceFile instanceof FileSystemFile) {
            File file = ((FileSystemFile)localSourceFile).getFile();
            boolean bl = predicate.test(file);
            if (!bl) {
                SftpProgressTracker sftpProgressTracker2 = sftpProgressTracker;
                if (sftpProgressTracker2 != null) {
                    Intrinsics.checkNotNull((Object)file);
                    sftpProgressTracker2.onFileIgnored(file);
                }
            }
            return bl;
        }
        return true;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ssh/impl/sshj/channels/SshjSftpChannel$Companion;", "", "SshjSftpChannel$Companion", "()V", "shouldSetExecutableBit", "", "file", "Ljava/io/File;", "intellij.platform.ssh"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean shouldSetExecutableBit(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return !file.isFile() || !file.canExecute();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

