/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.configurations.yaml.highlighting;

import com.intellij.ktor.configurations.meta.key.reference.value.env.KtorEnvVariableReference;
import com.intellij.ktor.configurations.yaml.YamlConfigUtilsKt;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.microservices.jvm.config.hints.HintReferenceBase;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLHighlighter;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\u0011\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ktor/configurations/yaml/highlighting/KtorYamlAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotateSequence", "yamlSequence", "Lorg/jetbrains/yaml/psi/YAMLSequence;", "annotateValue", "yamlScalar", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "doAnnotate", "range", "Lcom/intellij/openapi/util/TextRange;", "key", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "intellij.ktor"})
public final class KtorYamlAnnotator
implements Annotator,
DumbAware {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(element instanceof YAMLKeyValue) || !YamlConfigUtilsKt.isInsideKtorYamlFile(element)) {
            return;
        }
        YAMLValue yamlValue = ((YAMLKeyValue)element).getValue();
        YAMLValue yAMLValue = yamlValue;
        if (yAMLValue instanceof YAMLScalar) {
            this.annotateValue((YAMLScalar)yamlValue, holder);
        } else if (yAMLValue instanceof YAMLSequence) {
            this.annotateSequence((YAMLSequence)yamlValue, holder);
        }
    }

    private final void annotateSequence(YAMLSequence yamlSequence, AnnotationHolder holder) {
        for (YAMLSequenceItem item : yamlSequence.getItems()) {
            YAMLScalar value;
            YAMLValue yAMLValue = item.getValue();
            if ((yAMLValue instanceof YAMLScalar ? (YAMLScalar)yAMLValue : null) == null) continue;
            value = value;
            this.annotateValue(value, holder);
        }
    }

    private final void annotateValue(YAMLScalar yamlScalar, AnnotationHolder holder) {
        int elementOffset = yamlScalar.getNode().getStartOffset();
        PsiReference[] psiReferenceArray = yamlScalar.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        PsiReference[] references = psiReferenceArray;
        Set annotatedOffsets = new LinkedHashSet();
        for (PsiReference reference : references) {
            TextRange highlightTextRange;
            Pair pair;
            PsiReference psiReference = reference;
            if (psiReference instanceof KtorEnvVariableReference) {
                pair = TuplesKt.to((Object)YAMLHighlighter.SCALAR_TEXT, (Object)((KtorEnvVariableReference)reference).getEnvVariable().getFullTextRange());
            } else {
                if (!(psiReference instanceof HintReferenceBase)) continue;
                pair = TuplesKt.to((Object)((HintReferenceBase)reference).getTextAttributesKey(), (Object)((HintReferenceBase)reference).getRangeInElement());
            }
            Pair pair2 = pair;
            TextAttributesKey key = (TextAttributesKey)pair2.component1();
            TextRange range = (TextRange)pair2.component2();
            Intrinsics.checkNotNullExpressionValue((Object)range.shiftRight(elementOffset), (String)"shiftRight(...)");
            if (!annotatedOffsets.add(highlightTextRange.getStartOffset())) continue;
            this.doAnnotate(holder, highlightTextRange, key);
        }
    }

    private final void doAnnotate(AnnotationHolder holder, TextRange range, TextAttributesKey key) {
        if (range.isEmpty() || key == null) {
            return;
        }
        AnnotationBuilder annotationBuilder = holder.newSilentAnnotation(HighlightSeverity.INFORMATION);
        Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"newSilentAnnotation(...)");
        AnnotationBuilder annotationBuilder2 = annotationBuilder;
        annotationBuilder2.range(range).textAttributes(key).create();
    }
}

