/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class JpsMavenSettings {
    private static final Logger LOG = Logger.getInstance(JpsMavenSettings.class);
    private static final String REPOSITORY_PATH = "repository";
    private static final String M2_DIR = ".m2";
    private static final String CONF_DIR = "conf";
    private static final String SETTINGS_XML = "settings.xml";
    private static final String MAVEN_OPTS = "MAVEN_OPTS";
    private static final String MAVEN_REPO_LOCAL = "maven.repo.local";

    @NotNull
    public static File getUserMavenSettingsXml() {
        String defaultMavenFolder = SystemProperties.getUserHome() + File.separator + M2_DIR;
        return new File(defaultMavenFolder, SETTINGS_XML);
    }

    @Nullable
    public static File getGlobalMavenSettingsXml() {
        String defaultGlobalPath;
        String pathFromBrew = JpsMavenSettings.fromBrew();
        if (pathFromBrew != null && JpsMavenSettings.getMavenSettingsFromHome(pathFromBrew).exists()) {
            LOG.debug("Maven home is read from brew: " + pathFromBrew);
            return JpsMavenSettings.getMavenSettingsFromHome(pathFromBrew);
        }
        if ((SystemInfoRt.isLinux || SystemInfoRt.isMac) && JpsMavenSettings.isValidMavenHome(defaultGlobalPath = "/usr/share/maven") && JpsMavenSettings.getMavenSettingsFromHome(defaultGlobalPath).exists()) {
            LOG.debug("Maven home is read from default global directory: " + defaultGlobalPath);
            return JpsMavenSettings.getMavenSettingsFromHome(defaultGlobalPath);
        }
        return null;
    }

    @NotNull
    private static File getMavenSettingsFromHome(String homePath) {
        return new File(homePath + File.separator + CONF_DIR, SETTINGS_XML);
    }

    @NotNull
    public static String getMavenRepositoryPath() {
        block6: {
            String string;
            String property = JpsMavenSettings.findMavenRepositoryProperty(EnvironmentUtil.getValue((String)MAVEN_OPTS));
            if (StringUtil.isNotEmpty((String)property)) {
                LOG.debug("Maven repository path is read from MAVEN_OPTS environment variable: " + property);
                String string2 = property;
                if (string2 == null) {
                    JpsMavenSettings.$$$reportNull$$$0(0);
                }
                return string2;
            }
            try {
                String fromSettings;
                File settingsFile;
                File userSettingsFile = JpsMavenSettings.getUserMavenSettingsXml();
                File file = settingsFile = userSettingsFile.exists() ? userSettingsFile : JpsMavenSettings.getGlobalMavenSettingsXml();
                if (settingsFile == null || !settingsFile.exists() || !StringUtil.isNotEmpty((String)(fromSettings = JpsMavenSettings.getRepositoryFromSettings(settingsFile)))) break block6;
                LOG.debug("Maven repository path is read from " + String.valueOf(settingsFile) + " - " + fromSettings);
                string = fromSettings;
            }
            catch (Exception e) {
                LOG.warn("Cannot read Maven settings.xml", (Throwable)e);
            }
            if (string == null) {
                JpsMavenSettings.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = SystemProperties.getUserHome() + File.separator + M2_DIR + File.separator + REPOSITORY_PATH;
        if (string == null) {
            JpsMavenSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static String findMavenRepositoryProperty(String mavenOpts) {
        if (mavenOpts == null) {
            return null;
        }
        Pattern propertyPattern = Pattern.compile("-D([^=\\s]+)(?:=(?:\"([^\"]+)\"|(\\S+)))?");
        Matcher matcher = propertyPattern.matcher(mavenOpts);
        HashMap<String, String> properties = new HashMap<String, String>();
        while (matcher.find()) {
            String key = matcher.group(1);
            String quotedValue = matcher.group(2);
            String unquotedValue = matcher.group(3);
            String value = quotedValue != null && !quotedValue.isEmpty() ? quotedValue : unquotedValue;
            properties.put(key, value);
        }
        return (String)properties.get(MAVEN_REPO_LOCAL);
    }

    @ApiStatus.Internal
    @NotNull
    public static Map<String, RemoteRepositoryAuthentication> loadAuthenticationSettings(@Nullable File globalMavenSettingsXml, @NotNull File userMavenSettingsXml) {
        if (userMavenSettingsXml == null) {
            JpsMavenSettings.$$$reportNull$$$0(3);
        }
        if (!(globalMavenSettingsXml != null && globalMavenSettingsXml.exists() || userMavenSettingsXml.exists())) {
            Map<String, RemoteRepositoryAuthentication> map = Collections.emptyMap();
            if (map == null) {
                JpsMavenSettings.$$$reportNull$$$0(4);
            }
            return map;
        }
        HashMap<String, RemoteRepositoryAuthentication> result = new HashMap<String, RemoteRepositoryAuthentication>();
        if (globalMavenSettingsXml != null && globalMavenSettingsXml.exists()) {
            JpsMavenSettings.loadAuthenticationFromSettings(globalMavenSettingsXml, result);
        }
        if (userMavenSettingsXml.exists()) {
            JpsMavenSettings.loadAuthenticationFromSettings(userMavenSettingsXml, result);
        }
        HashMap<String, RemoteRepositoryAuthentication> hashMap = result;
        if (hashMap == null) {
            JpsMavenSettings.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    @Nullable
    private static String fromBrew() {
        if (!SystemInfoRt.isMac) {
            return null;
        }
        String defaultBrewPath = "/opt/homebrew/Cellar/maven/Current/libexec";
        return JpsMavenSettings.isValidMavenHome(defaultBrewPath) ? defaultBrewPath : null;
    }

    @ApiStatus.Internal
    @Nullable
    public static String getRepositoryFromSettings(File file) {
        Element settingsXmlRoot;
        try {
            settingsXmlRoot = JDOMUtil.load((File)file);
        }
        catch (IOException | JDOMException e) {
            return null;
        }
        Element child = settingsXmlRoot.getChild("localRepository", null);
        if (child == null || JpsMavenSettings.isUnknownNamespace(child.getNamespace())) {
            return null;
        }
        return StringUtil.nullize((String)child.getText());
    }

    private static boolean isValidMavenHome(@Nullable String path) {
        return Strings.isNotEmpty((String)path) && Files.exists(Path.of(path, new String[0]), new LinkOption[0]);
    }

    private static void loadAuthenticationFromSettings(@NotNull File settingsXml, @NotNull Map<String, RemoteRepositoryAuthentication> output) {
        Element settingsXmlRoot;
        if (settingsXml == null) {
            JpsMavenSettings.$$$reportNull$$$0(6);
        }
        if (output == null) {
            JpsMavenSettings.$$$reportNull$$$0(7);
        }
        try {
            settingsXmlRoot = JDOMUtil.load((File)settingsXml);
        }
        catch (IOException | JDOMException e) {
            return;
        }
        Element serversElement = settingsXmlRoot.getChild("servers", null);
        if (serversElement == null || JpsMavenSettings.isUnknownNamespace(serversElement.getNamespace())) {
            return;
        }
        for (Element serverElement : serversElement.getChildren("server", null)) {
            String id = serverElement.getChildText("id", null);
            String username = serverElement.getChildText("username", null);
            String password = serverElement.getChildText("password", null);
            if (id == null || username == null || password == null) continue;
            output.put(id, new RemoteRepositoryAuthentication(username, password));
        }
    }

    private static boolean isUnknownNamespace(@Nullable Namespace namespace) {
        return namespace != null && StringUtil.isNotEmpty((String)namespace.getURI()) && !namespace.getURI().startsWith("http://maven.apache.org/SETTINGS/");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/JpsMavenSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userMavenSettingsXml";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsXml";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenRepositoryPath";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/JpsMavenSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAuthenticationSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadAuthenticationSettings";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadAuthenticationFromSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class RemoteRepositoryAuthentication {
        private final String username;
        private final String password;

        public RemoteRepositoryAuthentication(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

