/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\u0005J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0002R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/util/TipRetriever;", "", "loader", "Ljava/lang/ClassLoader;", "path", "", "subPath", "suffix", "<init>", "(Ljava/lang/ClassLoader;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getSuffix", "()Ljava/lang/String;", "getTipContent", "Lorg/jetbrains/annotations/Nls;", "tipName", "getTipUrl", "Ljava/net/URL;", "addSuffixToFileName", "filename", "intellij.platform.tips"})
final class TipRetriever {
    @JvmField
    @Nullable
    public final ClassLoader loader;
    @JvmField
    @NotNull
    public final String path;
    @JvmField
    @NotNull
    public final String subPath;
    @NotNull
    private final String suffix;

    public TipRetriever(@Nullable ClassLoader loader, @NotNull String path, @NotNull String subPath, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)subPath, (String)"subPath");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        this.loader = loader;
        this.path = path;
        this.subPath = subPath;
        this.suffix = suffix;
    }

    public /* synthetic */ TipRetriever(ClassLoader classLoader, String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string3 = "";
        }
        this(classLoader, string, string2, string3);
    }

    @NotNull
    public final String getSuffix() {
        return this.suffix;
    }

    @Nullable
    public final String getTipContent(@Nullable String tipName) {
        if (tipName == null) {
            return null;
        }
        URL uRL = this.getTipUrl(tipName);
        if (uRL == null) {
            return null;
        }
        URL tipUrl = uRL;
        try {
            return ResourceUtil.loadText((InputStream)tipUrl.openStream());
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @Nullable
    public final URL getTipUrl(@NotNull String tipName) {
        Intrinsics.checkNotNullParameter((Object)tipName, (String)"tipName");
        String tipLocation = "/" + this.path + "/" + (String)(((CharSequence)this.subPath).length() > 0 ? this.subPath + "/" : "");
        String fileName = this.addSuffixToFileName(tipName, this.suffix);
        ClassLoader classLoader = this.loader;
        Intrinsics.checkNotNull((Object)classLoader);
        URL tipUrl = ResourceUtil.getResource((ClassLoader)classLoader, (String)tipLocation, (String)fileName);
        if (tipUrl == null && StringsKt.startsWith$default((String)tipName, (String)"neue-", (boolean)false, (int)2, null)) {
            String string = fileName.substring(5);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return ResourceUtil.getResource((ClassLoader)this.loader, (String)tipLocation, (String)string);
        }
        return tipUrl;
    }

    private final String addSuffixToFileName(String filename, String suffix) {
        if (((CharSequence)suffix).length() == 0) {
            return filename;
        }
        String string = FileUtilRt.getNameWithoutExtension((String)filename);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        String nameWithoutExtension = string;
        String string2 = FileUtilRt.getExtension((String)filename);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExtension(...)");
        String extension = string2;
        return nameWithoutExtension + suffix + "." + extension;
    }
}

