/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssIdSelector;
import com.intellij.psi.css.CssPseudoClass;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.reference.TemplateCssClassOrIdReference;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.css.util.CssCompletionUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiPolyVariantCachingReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlCssClassOrIdReference
extends PsiPolyVariantCachingReference
implements TemplateCssClassOrIdReference,
ResolvingHint,
EmptyResolveMessageProvider {
    private final PsiElement myElement;
    private final int start;
    private final int end;
    private final boolean myCaseSensitive;
    private final boolean mySoft;

    public HtmlCssClassOrIdReference(PsiElement element, int _start, int _end, boolean caseSensitive, boolean soft) {
        this.myElement = element;
        this.start = _start;
        this.end = _end;
        this.myCaseSensitive = caseSensitive;
        this.mySoft = soft;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(this.start, this.end);
    }

    @NotNull
    public String getCanonicalText() {
        String text = this.myElement.getText();
        int _end = Math.min(this.end, text.length());
        String s = text.substring(this.start, _end);
        String string = this.myCaseSensitive ? s : StringUtil.toLowerCase((String)s);
        if (string == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(2);
        }
        return ElementManipulators.handleContentChange((PsiElement)this.myElement, (TextRange)this.getRangeInElement(), (String)newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(3);
        }
        return null;
    }

    public boolean isId() {
        XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlAttribute.class);
        return xmlAttribute != null && HtmlCssClassOrIdReference.isIdAttribute(xmlAttribute);
    }

    public static boolean isIdAttribute(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(4);
        }
        return StringUtil.toLowerCase((String)attribute.getName()).endsWith("id");
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(5);
        }
        if (element instanceof CssSelectorSuffix) {
            CssSelectorSuffixType type = ((CssSelectorSuffix)element).getType();
            CssSelectorSuffixType expectedType = this.isId() ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS;
            return type == expectedType && this.isEqualName(((CssSelectorSuffix)element).getName()) && this.refersToTheSameObject(element);
        }
        return false;
    }

    private boolean isEqualName(@Nullable String name) {
        return name != null && Comparing.strEqual((String)this.getCanonicalText(), (String)name, (boolean)this.myCaseSensitive);
    }

    private boolean refersToTheSameObject(PsiElement element) {
        ResolveResult[] resolveResults = this.multiResolve(false);
        PsiFile file = element.getContainingFile();
        if (resolveResults.length == 0) {
            CssSelector selector = (CssSelector)PsiTreeUtil.getParentOfType((PsiElement)element, CssSelector.class);
            XmlTag referringTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlTag.class);
            if (referringTag != null && selector != null) {
                for (XmlTag subTag : referringTag.getSubTags()) {
                    if (!this.tryToResolveTagOrChildrenToFile(referringTag, subTag, selector)) continue;
                    return true;
                }
            }
        }
        for (ResolveResult result : resolveResults) {
            PsiElement referenceElement = result.getElement();
            if (referenceElement == null || referenceElement.getContainingFile() != file) continue;
            return true;
        }
        return false;
    }

    private boolean tryToResolveTagOrChildrenToFile(XmlTag referringTag, XmlTag tag, CssSelector selector) {
        CssSimpleSelector simpleSelector;
        ProgressManager.checkCanceled();
        CssResolver resolver = this.getCssResolver();
        resolver.setCollectingCompletionVariants(false);
        HashMap mapping = new HashMap();
        if (selector.isMatch(tag, resolver, mapping) && (simpleSelector = (CssSimpleSelector)mapping.get(referringTag)) != null && this.containsRelatedClassOrId(simpleSelector)) {
            return true;
        }
        for (XmlTag subTag : tag.getSubTags()) {
            if (!this.tryToResolveTagOrChildrenToFile(referringTag, subTag, selector)) continue;
            return true;
        }
        return false;
    }

    private boolean containsRelatedClassOrId(@NotNull CssSimpleSelector selector) {
        if (selector == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(6);
        }
        CssSelectorSuffixType expectedType = this.isId() ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS;
        for (CssSelectorSuffix suffix : selector.getSelectorSuffixes()) {
            String name = suffix.getName();
            if (expectedType != suffix.getType() || !this.isEqualName(name)) continue;
            return true;
        }
        return false;
    }

    public void addCompletions(@NotNull CompletionParameters parameters, @NotNull PrefixMatcher prefixMatcher, @NotNull Consumer<? super LookupElement> lookupElementConsumer) {
        if (parameters == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(7);
        }
        if (prefixMatcher == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(8);
        }
        if (lookupElementConsumer == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(9);
        }
        MyClassCandidatesProcessor processor = new MyClassCandidatesProcessor(prefixMatcher, lookupElementConsumer);
        processor.process(parameters.getInvocationCount() > 1);
        if (!processor.isMatchDetected() && !processor.hasProcessedAllCssFiles()) {
            processor.process(true);
        }
    }

    public boolean isSoft() {
        return this.mySoft;
    }

    protected ResolveResult @NotNull [] resolveInner(boolean incomplete, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(10);
        }
        MyClassResolveProcessor processor = new MyClassResolveProcessor();
        processor.process(false);
        if (!processor.hasProcessedAllCssFiles() && processor.result == null && (processor.results == null || processor.results.isEmpty())) {
            processor.process(true);
        }
        if (processor.results != null) {
            ResolveResult[] resolveResultArray = processor.results.values().toArray(ResolveResult.EMPTY_ARRAY);
            if (resolveResultArray == null) {
                HtmlCssClassOrIdReference.$$$reportNull$$$0(11);
            }
            return resolveResultArray;
        }
        if (processor.result != null) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{processor.result};
            if (resolveResultArray == null) {
                HtmlCssClassOrIdReference.$$$reportNull$$$0(12);
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(13);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public boolean canResolveTo(@NotNull Class<? extends PsiElement> elementClass) {
        if (elementClass == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(14);
        }
        return HtmlCssClassOrIdReference.acceptsTargetClass(elementClass);
    }

    public static boolean acceptsTargetClass(@NotNull Class<? extends PsiElement> elementClass) {
        if (elementClass == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(15);
        }
        return ReflectionUtil.isAssignable(CssClass.class, elementClass) || ReflectionUtil.isAssignable(CssIdSelector.class, elementClass);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = CssBundle.message((String)"invalid.css.selector", (Object[])new Object[0]);
        if (string == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(16);
        }
        return string;
    }

    protected CssResolver getCssResolver() {
        return CssResolveManager.getInstance().getNewResolver();
    }

    protected XmlAttribute getContextAttribute() {
        return this.myElement instanceof XmlAttribute ? (XmlAttribute)this.myElement : (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlAttribute.class);
    }

    protected XmlTag getContextTag() {
        return (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlTag.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 14, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixMatcher";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElementConsumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIdAttribute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsRelatedClassOrId";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveInner";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canResolveTo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "acceptsTargetClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 14, 15 -> new IllegalArgumentException(string);
        };
    }

    private final class MyClassCandidatesProcessor
    extends MyPsiElementProcessor {
        @NotNull
        private final Set<String> myProcessedNames;
        private final PrefixMatcher myPrefixMatcher;
        private final Consumer<? super LookupElement> myLookupElementConsumer;
        private boolean myMatchDetected;

        MyClassCandidatesProcessor(@NotNull PrefixMatcher prefixMatcher, Consumer<? super LookupElement> lookupElementConsumer) {
            if (prefixMatcher == null) {
                MyClassCandidatesProcessor.$$$reportNull$$$0(0);
            }
            if (lookupElementConsumer == null) {
                MyClassCandidatesProcessor.$$$reportNull$$$0(1);
            }
            this.myProcessedNames = new HashSet<String>();
            this.myPrefixMatcher = prefixMatcher;
            this.myLookupElementConsumer = lookupElementConsumer;
        }

        @Override
        protected boolean isCollectingCompletionVariants() {
            return true;
        }

        @Override
        boolean handleSelector(@NotNull String name, @NotNull CssSelectorSuffix selectorSuffix, @NotNull PsiElement navigationElement) {
            if (name == null) {
                MyClassCandidatesProcessor.$$$reportNull$$$0(2);
            }
            if (selectorSuffix == null) {
                MyClassCandidatesProcessor.$$$reportNull$$$0(3);
            }
            if (navigationElement == null) {
                MyClassCandidatesProcessor.$$$reportNull$$$0(4);
            }
            if (!this.myProcessedNames.contains(name)) {
                String elementName;
                CssSimpleSelector selector = (CssSimpleSelector)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)selectorSuffix, CssSimpleSelector.class);
                if (selector != null && !(elementName = selector.getElementName()).isEmpty() && Comparing.strEqual((String)this.myTag.getName(), (String)elementName, (boolean)HtmlCssClassOrIdReference.this.myCaseSensitive)) {
                    this.myProcessedNames.add(name);
                    this.myMatchDetected |= this.myPrefixMatcher.prefixMatches(name);
                    this.myLookupElementConsumer.consume((Object)CssCompletionUtil.lookupForSelectorSuffix((String)name, (CssSelectorSuffix)selectorSuffix, (PsiElement)navigationElement, (PsiFile)this.myTag.getContainingFile()));
                    return true;
                }
                this.myProcessedNames.add(name);
                this.myMatchDetected |= this.myPrefixMatcher.prefixMatches(name);
                this.myLookupElementConsumer.consume((Object)CssCompletionUtil.lookupForSelectorSuffix((String)name, (CssSelectorSuffix)selectorSuffix, (PsiElement)navigationElement, null));
            }
            return true;
        }

        public boolean isMatchDetected() {
            return this.myMatchDetected;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefixMatcher";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lookupElementConsumer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectorSuffix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigationElement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference$MyClassCandidatesProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyClassResolveProcessor
    extends MyPsiElementProcessor {
        final String myReferenceText;
        ResolveResult result;
        HashMap<PsiElement, ResolveResult> results;

        MyClassResolveProcessor() {
            this.myReferenceText = HtmlCssClassOrIdReference.this.getCanonicalText();
        }

        @Override
        protected boolean isCollectingCompletionVariants() {
            return false;
        }

        @Override
        boolean handleSelector(@NotNull String cssSelectorName, @NotNull CssSelectorSuffix selectorSuffix, @NotNull PsiElement navigationElement) {
            PsiElement element;
            if (cssSelectorName == null) {
                MyClassResolveProcessor.$$$reportNull$$$0(0);
            }
            if (selectorSuffix == null) {
                MyClassResolveProcessor.$$$reportNull$$$0(1);
            }
            if (navigationElement == null) {
                MyClassResolveProcessor.$$$reportNull$$$0(2);
            }
            if (this.results != null && this.results.containsKey(navigationElement)) {
                return true;
            }
            if (this.result != null && (element = this.result.getElement()) != null && element.isEquivalentTo(navigationElement)) {
                return true;
            }
            if (Comparing.strEqual((String)this.myReferenceText, (String)cssSelectorName, (boolean)HtmlCssClassOrIdReference.this.myCaseSensitive)) {
                if (this.result != null) {
                    this.results = new HashMap(3);
                    this.results.put(this.result.getElement(), this.result);
                    this.result = null;
                }
                if (this.results == null) {
                    this.result = new PsiElementResolveResult(navigationElement);
                } else {
                    this.results.put(navigationElement, (ResolveResult)new PsiElementResolveResult(navigationElement));
                }
                return true;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cssSelectorName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selectorSuffix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "navigationElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference$MyClassResolveProcessor";
            objectArray[2] = "handleSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class MyPsiElementProcessor {
        protected final XmlTag myTag;
        private boolean myProcessedAllCssFiles;

        private MyPsiElementProcessor() {
            this.myTag = HtmlCssClassOrIdReference.this.getContextTag();
            this.myProcessedAllCssFiles = false;
        }

        protected abstract boolean isCollectingCompletionVariants();

        public boolean hasProcessedAllCssFiles() {
            return this.myProcessedAllCssFiles;
        }

        void process(boolean forceProcessAllFilesInProject) {
            if (this.myTag == null) {
                return;
            }
            XmlAttribute attribute = HtmlCssClassOrIdReference.this.getContextAttribute();
            CssResolver resolver = HtmlCssClassOrIdReference.this.getCssResolver();
            resolver.setResolvedAttrName(attribute != null ? attribute.getName() : null);
            resolver.setCollectingCompletionVariants(this.isCollectingCompletionVariants());
            resolver.setProcessAllCssFilesMode(forceProcessAllFilesInProject);
            String lowerAttrName = attribute != null ? StringUtil.toLowerCase((String)attribute.getName()) : null;
            CssSelectorSuffixType targetType = lowerAttrName == null || lowerAttrName.contains("class") || lowerAttrName.contains("stylename") ? CssSelectorSuffixType.CLASS : CssSelectorSuffixType.ID;
            resolver.processAllRulesetsForTag(this.myTag, cssRuleset -> {
                for (CssSelector selector : cssRuleset.getSelectors()) {
                    if (!(selector.isAmpersandSelector() ? !selector.processAmpersandEvaluatedSelectors(s -> this.handleMatchedSelectors(targetType, (CssSelector)s, (PsiElement)selector)) : !this.handleMatchedSelectors(targetType, selector, null))) continue;
                    return false;
                }
                return true;
            });
            this.myProcessedAllCssFiles = resolver.hasProcessedAllCssFilesInProject();
        }

        private boolean handleMatchedSelectors(@NotNull CssSelectorSuffixType targetType, @NotNull CssSelector selector, @Nullable PsiElement navigationElement) {
            if (targetType == null) {
                MyPsiElementProcessor.$$$reportNull$$$0(0);
            }
            if (selector == null) {
                MyPsiElementProcessor.$$$reportNull$$$0(1);
            }
            for (CssSimpleSelector simpleSelector : selector.getSimpleSelectors()) {
                for (CssSelectorSuffix selectorSuffix : simpleSelector.getSelectorSuffixes()) {
                    String name;
                    if (selectorSuffix instanceof CssPseudoClass) {
                        CssSelector[] expressionSelectors;
                        CssPseudoClass pseudoClass = (CssPseudoClass)selectorSuffix;
                        for (CssSelector expressionSelector : expressionSelectors = pseudoClass.getExpressionSelectors()) {
                            if (this.handleMatchedSelectors(targetType, expressionSelector, navigationElement)) continue;
                            return false;
                        }
                        continue;
                    }
                    if (targetType != selectorSuffix.getType() || (name = selectorSuffix.getName()) == null || this.handleSelector(name, selectorSuffix, (PsiElement)ObjectUtils.notNull((Object)navigationElement, (Object)selectorSuffix))) continue;
                    return false;
                }
            }
            return true;
        }

        abstract boolean handleSelector(@NotNull String var1, @NotNull CssSelectorSuffix var2, @NotNull PsiElement var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selector";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference$MyPsiElementProcessor";
            objectArray[2] = "handleMatchedSelectors";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

