/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.AnnotatedApiUsageUtil;
import com.intellij.codeInspection.AnnotatedContainingDeclaration;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.PropertyUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.UastVisibility;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/codeInspection/UnstableTypeUsedInSignatureVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "unstableApiAnnotations", "", "", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Ljava/util/List;)V", "visitDeclaration", "", "node", "Lorg/jetbrains/uast/UDeclaration;", "isAccessibleDeclaration", "isInsideUnstableDeclaration", "intellij.jvm.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nUnstableTypeUsedInSignatureInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnstableTypeUsedInSignatureInspection.kt\ncom/intellij/codeInspection/UnstableTypeUsedInSignatureVisitor\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n18#2:119\n1807#3,3:120\n1807#3,3:123\n*S KotlinDebug\n*F\n+ 1 UnstableTypeUsedInSignatureInspection.kt\ncom/intellij/codeInspection/UnstableTypeUsedInSignatureVisitor\n*L\n92#1:119\n100#1:120,3\n112#1:123,3\n*E\n"})
final class UnstableTypeUsedInSignatureVisitor
extends AbstractUastNonRecursiveVisitor {
    @NotNull
    private final ProblemsHolder problemsHolder;
    @NotNull
    private final List<String> unstableApiAnnotations;

    public UnstableTypeUsedInSignatureVisitor(@NotNull ProblemsHolder problemsHolder, @NotNull List<String> unstableApiAnnotations) {
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        Intrinsics.checkNotNullParameter(unstableApiAnnotations, (String)"unstableApiAnnotations");
        this.problemsHolder = problemsHolder;
        this.unstableApiAnnotations = unstableApiAnnotations;
    }

    public boolean visitDeclaration(@NotNull UDeclaration node) {
        String string;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!(node instanceof UClass || node instanceof UMethod || node instanceof UField)) {
            return false;
        }
        if (!this.isAccessibleDeclaration(node) || this.isInsideUnstableDeclaration(node)) {
            return true;
        }
        AnnotatedContainingDeclaration annotatedContainingDeclaration = AnnotatedApiUsageUtil.INSTANCE.findAnnotatedTypeUsedInDeclarationSignature(node, (Collection<String>)this.unstableApiAnnotations);
        if (annotatedContainingDeclaration == null) {
            return true;
        }
        AnnotatedContainingDeclaration annotatedTypeUsedInSignature = annotatedContainingDeclaration;
        PsiModifierListOwner psiModifierListOwner = annotatedTypeUsedInSignature.getTarget();
        Object object = psiModifierListOwner instanceof PsiClass ? (PsiClass)psiModifierListOwner : null;
        if (object == null || (object = object.getQualifiedName()) == null) {
            return true;
        }
        Object typeName = object;
        String string2 = annotatedTypeUsedInSignature.getPsiAnnotation().getQualifiedName();
        if (string2 == null) {
            return true;
        }
        String annotationName = string2;
        UDeclaration uDeclaration = node;
        if (uDeclaration instanceof UMethod) {
            var7_7 = new Object[]{annotationName, typeName};
            string = JvmAnalysisBundle.message("jvm.inspections.unstable.type.used.in.method.signature.description", var7_7);
        } else if (uDeclaration instanceof UField) {
            var7_7 = new Object[]{annotationName, typeName};
            string = JvmAnalysisBundle.message("jvm.inspections.unstable.type.used.in.field.signature.description", var7_7);
        } else {
            var7_7 = new Object[]{annotationName, typeName};
            string = JvmAnalysisBundle.message("jvm.inspections.unstable.type.used.in.class.signature.description", var7_7);
        }
        String message = string;
        Intrinsics.checkNotNull((Object)message);
        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.problemsHolder, (UDeclaration)node, (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
        return true;
    }

    private final boolean isAccessibleDeclaration(UDeclaration node) {
        if (node.getVisibility() == UastVisibility.PRIVATE || node.getVisibility() == UastVisibility.PACKAGE_LOCAL) {
            PsiElement psiField;
            if (node instanceof UField && (psiField = node.getJavaPsi()) instanceof PsiField) {
                PsiMethod psiMethod = PropertyUtil.findGetterForField((PsiField)((PsiField)psiField));
                UMethod getter = psiMethod != null ? (UMethod)UastContextKt.toUElement((PsiElement)((PsiElement)psiMethod), UMethod.class) : null;
                PsiMethod psiMethod2 = PropertyUtil.findSetterForField((PsiField)((PsiField)psiField));
                UMethod setter = psiMethod2 != null ? (UMethod)UastContextKt.toUElement((PsiElement)((PsiElement)psiMethod2), UMethod.class) : null;
                return getter != null && this.isAccessibleDeclaration((UDeclaration)getter) || setter != null && this.isAccessibleDeclaration((UDeclaration)setter);
            }
            return false;
        }
        UElement $this$getParentOfType_u24default$iv = (UElement)node;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        UDeclaration containingDeclaration = (UDeclaration)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UDeclaration.class, (boolean)strict$iv);
        if (containingDeclaration != null) {
            return this.isAccessibleDeclaration(containingDeclaration);
        }
        return true;
    }

    private final boolean isInsideUnstableDeclaration(UDeclaration node) {
        boolean bl;
        block10: {
            Iterable $this$any$iv = node.getUAnnotations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    UAnnotation it = (UAnnotation)element$iv;
                    boolean bl2 = false;
                    if (!CollectionsKt.contains((Iterable)this.unstableApiAnnotations, (Object)it.getQualifiedName())) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        UClass containingClass = UastUtils.getContainingUClass((UElement)((UElement)node));
        if (containingClass != null) {
            return this.isInsideUnstableDeclaration((UDeclaration)containingClass);
        }
        UFile containingUFile = UastUtils.getContainingUFile((UElement)((UElement)node));
        if (containingUFile != null) {
            String packageName = containingUFile.getPackageName();
            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this.problemsHolder.getProject()).findPackage(packageName);
            if (psiPackage != null) {
                boolean bl3;
                block11: {
                    Iterable $this$any$iv = this.unstableApiAnnotations;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl4 = false;
                            if (!psiPackage.hasAnnotation(it)) continue;
                            bl3 = true;
                            break block11;
                        }
                        bl3 = false;
                    }
                }
                return bl3;
            }
        }
        return false;
    }
}

