/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.logging;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.logging.LoggingPlaceholderUtilKt;
import com.intellij.codeInspection.logging.PlaceholderContext;
import com.intellij.codeInspection.logging.PlaceholderCountResult;
import com.intellij.codeInspection.logging.PlaceholderEscapeSymbolStrategy;
import com.intellij.codeInspection.logging.PlaceholderLoggerType;
import com.intellij.codeInspection.logging.PlaceholdersStatus;
import com.intellij.codeInspection.logging.ResultType;
import com.intellij.codeInspection.options.OptDropdown;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0010\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInspection/logging/LoggingPlaceholderCountMatchesArgumentCountInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "<init>", "()V", "slf4jToLog4J2Type", "Lcom/intellij/codeInspection/logging/LoggingPlaceholderCountMatchesArgumentCountInspection$Slf4jToLog4J2Type;", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "PlaceholderCountMatchesArgumentCountVisitor", "Slf4jToLog4J2Type", "Result", "intellij.jvm.analysis.impl"})
public final class LoggingPlaceholderCountMatchesArgumentCountInspection
extends AbstractBaseUastLocalInspectionTool {
    @JvmField
    @NotNull
    public Slf4jToLog4J2Type slf4jToLog4J2Type = Slf4jToLog4J2Type.AUTO;

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[1];
        OptDropdown.Option[] optionArray = new OptDropdown.Option[]{OptPane.option((Enum)Slf4jToLog4J2Type.AUTO, (String)JvmAnalysisBundle.message("jvm.inspection.logging.placeholder.count.matches.argument.count.slf4j.throwable.option.auto", new Object[0])), OptPane.option((Enum)Slf4jToLog4J2Type.NO, (String)JvmAnalysisBundle.message("jvm.inspection.logging.placeholder.count.matches.argument.count.slf4j.throwable.option.no", new Object[0])), OptPane.option((Enum)Slf4jToLog4J2Type.YES, (String)JvmAnalysisBundle.message("jvm.inspection.logging.placeholder.count.matches.argument.count.slf4j.throwable.option.yes", new Object[0]))};
        optRegularComponentArray[0] = OptPane.dropdown((String)"slf4jToLog4J2Type", (String)JvmAnalysisBundle.message("jvm.inspection.logging.placeholder.count.matches.argument.count.slf4j.throwable.option", new Object[0]), (OptDropdown.Option[])optionArray);
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Class[] classArray = new Class[]{UCallExpression.class};
        return UastHintedVisitorAdapter.Companion.create(language, (AbstractUastNonRecursiveVisitor)new PlaceholderCountMatchesArgumentCountVisitor(holder), classArray, true);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/codeInspection/logging/LoggingPlaceholderCountMatchesArgumentCountInspection$PlaceholderCountMatchesArgumentCountVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/logging/LoggingPlaceholderCountMatchesArgumentCountInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitCallExpression", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "calculateSlf4jStructureLogging", "Lcom/intellij/codeInspection/logging/ResultType;", "placeholderCountHolder", "Lcom/intellij/codeInspection/logging/PlaceholderCountResult;", "context", "Lcom/intellij/codeInspection/logging/PlaceholderContext;", "finalArgumentCount", "", "registerProblem", "", "logStringArgument", "Lorg/jetbrains/uast/UExpression;", "result", "Lcom/intellij/codeInspection/logging/LoggingPlaceholderCountMatchesArgumentCountInspection$Result;", "buildErrorString", "", "intellij.jvm.analysis.impl"})
    public final class PlaceholderCountMatchesArgumentCountVisitor
    extends AbstractUastNonRecursiveVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public PlaceholderCountMatchesArgumentCountVisitor(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Boolean log4jAsImplementationForSlf4j = switch (WhenMappings.$EnumSwitchMapping$0[LoggingPlaceholderCountMatchesArgumentCountInspection.this.slf4jToLog4J2Type.ordinal()]) {
                case 1 -> null;
                case 2 -> true;
                case 3 -> false;
                default -> throw new NoWhenBranchMatchedException();
            };
            PlaceholderContext placeholderContext = LoggingPlaceholderUtilKt.getPlaceholderContext(node, LoggingPlaceholderUtilKt.getLOGGER_TYPE_SEARCHERS(), log4jAsImplementationForSlf4j);
            if (placeholderContext == null) {
                return true;
            }
            PlaceholderContext context = placeholderContext;
            int finalArgumentCount = context.getPlaceholderParameters().size();
            PlaceholderCountResult placeholderCountHolder = LoggingPlaceholderUtilKt.solvePlaceholderCount(context.getLoggerType(), finalArgumentCount, context.getPartHolderList(), PlaceholderEscapeSymbolStrategy.UAST_STRING);
            if (placeholderCountHolder.getStatus() == PlaceholdersStatus.EMPTY) {
                return true;
            }
            if (placeholderCountHolder.getStatus() == PlaceholdersStatus.ERROR_TO_PARSE_STRING) {
                this.registerProblem(this.holder, context.getLogStringArgument(), new Result(finalArgumentCount, 0, ResultType.INCORRECT_STRING));
                return true;
            }
            ResultType resultType = switch (WhenMappings.$EnumSwitchMapping$1[context.getLoggerType().ordinal()]) {
                case 1 -> {
                    int v2 = finalArgumentCount = context.getLastArgumentIsException() ? finalArgumentCount - 1 : finalArgumentCount;
                    if (placeholderCountHolder.getStatus() == PlaceholdersStatus.PARTIAL) {
                        if (placeholderCountHolder.getCount() <= finalArgumentCount) {
                            yield ResultType.SUCCESS;
                        }
                        yield ResultType.PARTIAL_PLACE_HOLDER_MISMATCH;
                    }
                    if (placeholderCountHolder.getCount() == finalArgumentCount) {
                        yield ResultType.SUCCESS;
                    }
                    yield this.calculateSlf4jStructureLogging(placeholderCountHolder, context, finalArgumentCount);
                }
                case 2, 3, 4 -> {
                    if (placeholderCountHolder.getStatus() == PlaceholdersStatus.PARTIAL) {
                        if (placeholderCountHolder.getCount() <= finalArgumentCount) {
                            yield ResultType.SUCCESS;
                        }
                        if (context.getLoggerType() == PlaceholderLoggerType.SLF4J_EQUAL_PLACEHOLDERS) {
                            yield this.calculateSlf4jStructureLogging(placeholderCountHolder, context, finalArgumentCount);
                        }
                        yield ResultType.PARTIAL_PLACE_HOLDER_MISMATCH;
                    }
                    if (placeholderCountHolder.getCount() == finalArgumentCount) {
                        yield ResultType.SUCCESS;
                    }
                    yield ResultType.PLACE_HOLDER_MISMATCH;
                }
                case 5, 6 -> {
                    ResultType type = null;
                    type = placeholderCountHolder.getStatus() == PlaceholdersStatus.PARTIAL ? (placeholderCountHolder.getCount() <= finalArgumentCount && (!context.getLastArgumentIsException() || finalArgumentCount > 1) || context.getLastArgumentIsException() && placeholderCountHolder.getCount() <= finalArgumentCount - 1 || context.getLastArgumentIsSupplier() && placeholderCountHolder.getCount() <= finalArgumentCount ? ResultType.SUCCESS : ResultType.PARTIAL_PLACE_HOLDER_MISMATCH) : (placeholderCountHolder.getCount() == finalArgumentCount && (!context.getLastArgumentIsException() || finalArgumentCount > 1) || context.getLastArgumentIsException() && placeholderCountHolder.getCount() == finalArgumentCount - 1 || context.getLastArgumentIsSupplier() && (placeholderCountHolder.getCount() == finalArgumentCount || placeholderCountHolder.getCount() == finalArgumentCount - 1) ? ResultType.SUCCESS : ResultType.PLACE_HOLDER_MISMATCH);
                    finalArgumentCount = context.getLastArgumentIsException() ? finalArgumentCount - 1 : finalArgumentCount;
                    yield type;
                }
                default -> throw new NoWhenBranchMatchedException();
            };
            if (resultType == ResultType.SUCCESS) {
                return true;
            }
            this.registerProblem(this.holder, context.getLogStringArgument(), new Result(finalArgumentCount, placeholderCountHolder.getCount(), resultType));
            return true;
        }

        private final ResultType calculateSlf4jStructureLogging(PlaceholderCountResult placeholderCountHolder, PlaceholderContext context, int finalArgumentCount) {
            if (placeholderCountHolder.getCount() >= finalArgumentCount) {
                return ResultType.PLACE_HOLDER_MISMATCH;
            }
            if (placeholderCountHolder.getCount() < 0 || context.getPlaceholderParameters().size() < finalArgumentCount) {
                return ResultType.PLACE_HOLDER_MISMATCH;
            }
            for (int argumentIndex = placeholderCountHolder.getCount(); argumentIndex < finalArgumentCount; ++argumentIndex) {
                PsiType argumentType;
                UExpression argument;
                if ((UExpression)CollectionsKt.getOrNull(context.getPlaceholderParameters(), (int)argumentIndex) == null || argument.getExpressionType() == null || argumentType.equalsToText("net.logstash.logback.argument.StructuredArgument") || InheritanceUtil.isInheritor((PsiType)argumentType, (String)"net.logstash.logback.argument.StructuredArgument")) continue;
                return ResultType.PLACE_HOLDER_MISMATCH;
            }
            return ResultType.SUCCESS;
        }

        private final void registerProblem(ProblemsHolder holder, UExpression logStringArgument, Result result) {
            String errorString = this.buildErrorString(result);
            PsiElement psiElement = logStringArgument.getSourcePsi();
            if (psiElement == null) {
                return;
            }
            PsiElement anchor = psiElement;
            holder.registerProblem(anchor, errorString, new LocalQuickFix[0]);
        }

        @InspectionMessage
        private final String buildErrorString(Result result) {
            String string;
            if (result.getResult() == ResultType.INCORRECT_STRING) {
                String string2 = JvmAnalysisBundle.message("jvm.inspection.logging.placeholder.count.matches.argument.count.incorrect.problem.descriptor", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                return string2;
            }
            if (result.getResult() == ResultType.PARTIAL_PLACE_HOLDER_MISMATCH) {
                Object[] objectArray = new Object[]{result.getArgumentCount(), result.getPlaceholderCount()};
                String string3 = JvmAnalysisBundle.message("jvm.inspection.logging.placeholder.count.matches.argument.count.fewer.problem.partial.descriptor", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                return string3;
            }
            if (result.getArgumentCount() > result.getPlaceholderCount()) {
                Object[] objectArray = new Object[]{result.getArgumentCount(), result.getPlaceholderCount()};
                String string4 = JvmAnalysisBundle.message("jvm.inspection.logging.placeholder.count.matches.argument.count.more.problem.descriptor", objectArray);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            } else {
                Object[] objectArray = new Object[]{result.getArgumentCount(), result.getPlaceholderCount()};
                String string5 = JvmAnalysisBundle.message("jvm.inspection.logging.placeholder.count.matches.argument.count.fewer.problem.descriptor", objectArray);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
            }
            return string;
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[Slf4jToLog4J2Type.values().length];
                try {
                    nArray[Slf4jToLog4J2Type.AUTO.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Slf4jToLog4J2Type.YES.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Slf4jToLog4J2Type.NO.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[PlaceholderLoggerType.values().length];
                try {
                    nArray[PlaceholderLoggerType.SLF4J.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PlaceholderLoggerType.SLF4J_EQUAL_PLACEHOLDERS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PlaceholderLoggerType.LOG4J_EQUAL_PLACEHOLDERS.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PlaceholderLoggerType.AKKA_PLACEHOLDERS.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PlaceholderLoggerType.LOG4J_OLD_STYLE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PlaceholderLoggerType.LOG4J_FORMATTED_STYLE.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0015\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/codeInspection/logging/LoggingPlaceholderCountMatchesArgumentCountInspection$Result;", "", "argumentCount", "", "placeholderCount", "result", "Lcom/intellij/codeInspection/logging/ResultType;", "<init>", "(IILcom/intellij/codeInspection/logging/ResultType;)V", "getArgumentCount", "()I", "getPlaceholderCount", "getResult", "()Lcom/intellij/codeInspection/logging/ResultType;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.jvm.analysis.impl"})
    private static final class Result {
        private final int argumentCount;
        private final int placeholderCount;
        @NotNull
        private final ResultType result;

        public Result(int argumentCount, int placeholderCount, @NotNull ResultType result) {
            Intrinsics.checkNotNullParameter((Object)((Object)result), (String)"result");
            this.argumentCount = argumentCount;
            this.placeholderCount = placeholderCount;
            this.result = result;
        }

        public final int getArgumentCount() {
            return this.argumentCount;
        }

        public final int getPlaceholderCount() {
            return this.placeholderCount;
        }

        @NotNull
        public final ResultType getResult() {
            return this.result;
        }

        public final int component1() {
            return this.argumentCount;
        }

        public final int component2() {
            return this.placeholderCount;
        }

        @NotNull
        public final ResultType component3() {
            return this.result;
        }

        @NotNull
        public final Result copy(int argumentCount, int placeholderCount, @NotNull ResultType result) {
            Intrinsics.checkNotNullParameter((Object)((Object)result), (String)"result");
            return new Result(argumentCount, placeholderCount, result);
        }

        public static /* synthetic */ Result copy$default(Result result, int n, int n2, ResultType resultType, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = result.argumentCount;
            }
            if ((n3 & 2) != 0) {
                n2 = result.placeholderCount;
            }
            if ((n3 & 4) != 0) {
                resultType = result.result;
            }
            return result.copy(n, n2, resultType);
        }

        @NotNull
        public String toString() {
            return "Result(argumentCount=" + this.argumentCount + ", placeholderCount=" + this.placeholderCount + ", result=" + this.result + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.argumentCount);
            result = result * 31 + Integer.hashCode(this.placeholderCount);
            result = result * 31 + this.result.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            if (this.argumentCount != result.argumentCount) {
                return false;
            }
            if (this.placeholderCount != result.placeholderCount) {
                return false;
            }
            return this.result == result.result;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInspection/logging/LoggingPlaceholderCountMatchesArgumentCountInspection$Slf4jToLog4J2Type;", "", "<init>", "(Ljava/lang/String;I)V", "AUTO", "YES", "NO", "intellij.jvm.analysis.impl"})
    public static final class Slf4jToLog4J2Type
    extends Enum<Slf4jToLog4J2Type> {
        public static final /* enum */ Slf4jToLog4J2Type AUTO = new Slf4jToLog4J2Type();
        public static final /* enum */ Slf4jToLog4J2Type YES = new Slf4jToLog4J2Type();
        public static final /* enum */ Slf4jToLog4J2Type NO = new Slf4jToLog4J2Type();
        private static final /* synthetic */ Slf4jToLog4J2Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Slf4jToLog4J2Type[] values() {
            return (Slf4jToLog4J2Type[])$VALUES.clone();
        }

        public static Slf4jToLog4J2Type valueOf(String value) {
            return Enum.valueOf(Slf4jToLog4J2Type.class, value);
        }

        @NotNull
        public static EnumEntries<Slf4jToLog4J2Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = slf4jToLog4J2TypeArray = new Slf4jToLog4J2Type[]{Slf4jToLog4J2Type.AUTO, Slf4jToLog4J2Type.YES, Slf4jToLog4J2Type.NO};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

