/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.plugins.frontend.split;

import com.intellij.ide.plugins.PluginModuleId;
import com.intellij.ide.plugins.marketplace.DependencyType;
import com.intellij.ide.plugins.marketplace.LoadingRule;
import com.intellij.ide.plugins.marketplace.ModuleDependency;
import com.intellij.ide.plugins.marketplace.PluginContentModule;
import com.intellij.ide.plugins.marketplace.PluginModule;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.platform.plugins.frontend.split.ContentModuleHeader;
import com.intellij.platform.plugins.frontend.split.PluginHeader;
import com.intellij.platform.plugins.frontend.split.ProductModeCompatibility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility;", "", "client", "Lcom/intellij/platform/plugins/frontend/split/ProductModeCompatibility;", "backend", "monolith", "<init>", "(Lcom/intellij/platform/plugins/frontend/split/ProductModeCompatibility;Lcom/intellij/platform/plugins/frontend/split/ProductModeCompatibility;Lcom/intellij/platform/plugins/frontend/split/ProductModeCompatibility;)V", "getClient", "()Lcom/intellij/platform/plugins/frontend/split/ProductModeCompatibility;", "getBackend", "getMonolith", "Companion", "intellij.platform.plugins.frontend.split"})
public final class PluginProductModeCompatibility {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProductModeCompatibility client;
    @NotNull
    private final ProductModeCompatibility backend;
    @NotNull
    private final ProductModeCompatibility monolith;
    @NotNull
    private static final String FRONTEND_MODULE_ID = "intellij.platform.frontend";
    @NotNull
    private static final String FRONTEND_SPLIT_MODULE_ID = "intellij.platform.frontend.split";
    @NotNull
    private static final String BACKEND_MODULE_ID = "intellij.platform.backend";

    public PluginProductModeCompatibility(@NotNull ProductModeCompatibility client, @NotNull ProductModeCompatibility backend, @NotNull ProductModeCompatibility monolith) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
        Intrinsics.checkNotNullParameter((Object)((Object)monolith), (String)"monolith");
        this.client = client;
        this.backend = backend;
        this.monolith = monolith;
    }

    @NotNull
    public final ProductModeCompatibility getClient() {
        return this.client;
    }

    @NotNull
    public final ProductModeCompatibility getBackend() {
        return this.backend;
    }

    @NotNull
    public final ProductModeCompatibility getMonolith() {
        return this.monolith;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\bJ0\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0018\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000e0\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002R\u000e\u0010\u0017\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion;", "", "<init>", "()V", "determineProductModeCompatibility", "Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility;", "plugin", "Lcom/intellij/platform/plugins/frontend/split/PluginHeader;", "Lcom/intellij/ide/plugins/newui/PluginUiModel;", "determineCompatibilityFromDependencies", "mainModules", "", "", "contentModules", "Lkotlin/Pair;", "Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion$Requirement;", "processModuleDependency", "Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion$ModuleRequirement;", "moduleName", "requirement", "backendReq", "frontendReq", "frontendSplitReq", "FRONTEND_MODULE_ID", "FRONTEND_SPLIT_MODULE_ID", "BACKEND_MODULE_ID", "Requirement", "ModuleRequirement", "intellij.platform.plugins.frontend.split"})
    @SourceDebugExtension(value={"SMAP\nPluginProductModeCompatibility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginProductModeCompatibility.kt\ncom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1586#2:130\n1661#2,3:131\n1391#2:134\n1480#2,2:135\n1586#2:137\n1661#2,3:138\n1482#2,3:141\n777#2:144\n873#2,2:145\n1586#2:147\n1661#2,3:148\n1220#2,2:151\n1249#2,4:153\n1391#2:157\n1480#2,2:158\n1586#2:160\n1661#2,3:161\n1482#2,3:164\n*S KotlinDebug\n*F\n+ 1 PluginProductModeCompatibility.kt\ncom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion\n*L\n20#1:130\n20#1:131,3\n21#1:134\n21#1:135,2\n23#1:137\n23#1:138,3\n21#1:141,3\n30#1:144\n30#1:145,2\n31#1:147\n31#1:148,3\n33#1:151,2\n33#1:153,4\n34#1:157\n34#1:158,2\n37#1:160\n37#1:161,3\n34#1:164,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PluginProductModeCompatibility determineProductModeCompatibility(@NotNull PluginHeader plugin) {
            void $this$flatMapTo$iv$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            Iterable $this$map$iv = plugin.getModuleDependencies().getModules();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PluginModuleId pluginModuleId = (PluginModuleId)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            List mainModules = (List)destination$iv$iv;
            Iterable $this$flatMap$iv = plugin.getContentModules();
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                ContentModuleHeader contentModule = (ContentModuleHeader)element$iv$iv;
                boolean bl = false;
                Requirement requirement = contentModule.getLoadingRule().getRequired() ? Requirement.REQUIRED : Requirement.OPTIONAL;
                Iterable $this$map$iv2 = contentModule.getModuleDependencies().getModules();
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    PluginModuleId pluginModuleId = (PluginModuleId)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl2 = false;
                    collection.add(TuplesKt.to((Object)it.getName(), (Object)((Object)requirement)));
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List contentModules2 = (List)destination$iv$iv2;
            return this.determineCompatibilityFromDependencies(mainModules, contentModules2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PluginProductModeCompatibility determineProductModeCompatibility(@NotNull PluginUiModel plugin) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$associateByTo$iv$iv;
            Object object;
            void $this$mapTo$iv$iv;
            ModuleDependency it;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            Iterable $this$filter$iv = plugin.getMainModuleDependencies();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ModuleDependency)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() == DependencyType.MODULE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ModuleDependency)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(it.getModuleName());
            }
            List mainModules = (List)destination$iv$iv;
            Iterable $this$associateBy$iv = plugin.getModules();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable $i$f$mapTo22 = $this$associateBy$iv;
            Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it2;
                PluginModule pluginModule = (PluginModule)element$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                object.put(it2.getModuleName(), element$iv$iv);
            }
            Map modules = destination$iv$iv2;
            Iterable $this$flatMap$iv = plugin.getContentModules();
            boolean $i$f$flatMap = false;
            $this$associateByTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                PluginContentModule contentModule = (PluginContentModule)element$iv$iv;
                boolean bl = false;
                Requirement requirement = contentModule.getLoadingRule() == LoadingRule.REQUIRED ? Requirement.REQUIRED : Requirement.OPTIONAL;
                Object object2 = (PluginModule)modules.get(contentModule.getModuleName());
                if (object2 == null || (object2 = object2.getModuleDependencies()) == null) {
                    object2 = CollectionsKt.emptyList();
                }
                Object moduleDependencies = object2;
                Iterable $this$map$iv2 = (Iterable)moduleDependencies;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it3;
                    ModuleDependency moduleDependency = (ModuleDependency)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl2 = false;
                    collection.add(TuplesKt.to((Object)it3.getModuleName(), (Object)((Object)requirement)));
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List contentModules2 = (List)destination$iv$iv2;
            return this.determineCompatibilityFromDependencies(mainModules, contentModules2);
        }

        private final PluginProductModeCompatibility determineCompatibilityFromDependencies(List<String> mainModules, List<? extends Pair<String, ? extends Requirement>> contentModules2) {
            Requirement backendReq = Requirement.UNKNOWN;
            Requirement frontendReq = Requirement.UNKNOWN;
            Requirement frontendSplitReq = Requirement.UNKNOWN;
            for (String pair : mainModules) {
                ModuleRequirement moduleReq = this.processModuleDependency(pair, Requirement.REQUIRED);
                backendReq = (Requirement)((Object)RangesKt.coerceAtLeast((Comparable)((Comparable)((Object)backendReq)), (Comparable)((Comparable)((Object)moduleReq.getBackend()))));
                frontendReq = (Requirement)((Object)RangesKt.coerceAtLeast((Comparable)((Comparable)((Object)frontendReq)), (Comparable)((Comparable)((Object)moduleReq.getFrontend()))));
                frontendSplitReq = (Requirement)((Object)RangesKt.coerceAtLeast((Comparable)((Comparable)((Object)frontendSplitReq)), (Comparable)((Comparable)((Object)moduleReq.getFrontendSplit()))));
            }
            for (Pair pair : contentModules2) {
                String moduleName = (String)pair.component1();
                Requirement requirement = (Requirement)((Object)pair.component2());
                ModuleRequirement moduleReq = this.processModuleDependency(moduleName, requirement);
                backendReq = (Requirement)((Object)RangesKt.coerceAtLeast((Comparable)((Comparable)((Object)backendReq)), (Comparable)((Comparable)((Object)moduleReq.getBackend()))));
                frontendReq = (Requirement)((Object)RangesKt.coerceAtLeast((Comparable)((Comparable)((Object)frontendReq)), (Comparable)((Comparable)((Object)moduleReq.getFrontend()))));
                frontendSplitReq = (Requirement)((Object)RangesKt.coerceAtLeast((Comparable)((Comparable)((Object)frontendSplitReq)), (Comparable)((Comparable)((Object)moduleReq.getFrontendSplit()))));
            }
            return this.determineProductModeCompatibility(backendReq, frontendReq, frontendSplitReq);
        }

        private final ModuleRequirement processModuleDependency(String moduleName, Requirement requirement) {
            return switch (moduleName) {
                case PluginProductModeCompatibility.FRONTEND_MODULE_ID -> new ModuleRequirement(Requirement.UNKNOWN, requirement, Requirement.UNKNOWN);
                case PluginProductModeCompatibility.FRONTEND_SPLIT_MODULE_ID -> new ModuleRequirement(Requirement.UNKNOWN, requirement, requirement);
                case PluginProductModeCompatibility.BACKEND_MODULE_ID -> new ModuleRequirement(requirement, Requirement.UNKNOWN, Requirement.UNKNOWN);
                default -> new ModuleRequirement(Requirement.UNKNOWN, Requirement.UNKNOWN, Requirement.UNKNOWN);
            };
        }

        private final PluginProductModeCompatibility determineProductModeCompatibility(Requirement backendReq, Requirement frontendReq, Requirement frontendSplitReq) {
            return new PluginProductModeCompatibility(backendReq == Requirement.REQUIRED ? ProductModeCompatibility.INCOMPATIBLE : (frontendReq.compareTo((Enum)Requirement.OPTIONAL) >= 0 ? ProductModeCompatibility.COMPATIBLE : ProductModeCompatibility.UNKNOWN), frontendReq == Requirement.REQUIRED ? ProductModeCompatibility.INCOMPATIBLE : (backendReq.compareTo((Enum)Requirement.OPTIONAL) >= 0 ? ProductModeCompatibility.COMPATIBLE : ProductModeCompatibility.UNKNOWN), frontendSplitReq == Requirement.REQUIRED ? ProductModeCompatibility.INCOMPATIBLE : (frontendReq.compareTo((Enum)Requirement.OPTIONAL) >= 0 && backendReq.compareTo((Enum)Requirement.OPTIONAL) >= 0 ? ProductModeCompatibility.COMPATIBLE : ProductModeCompatibility.UNKNOWN));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion$ModuleRequirement;", "", "backend", "Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion$Requirement;", "frontend", "frontendSplit", "<init>", "(Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion$Requirement;Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion$Requirement;Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion$Requirement;)V", "getBackend", "()Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion$Requirement;", "getFrontend", "getFrontendSplit", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.plugins.frontend.split"})
        private static final class ModuleRequirement {
            @NotNull
            private final Requirement backend;
            @NotNull
            private final Requirement frontend;
            @NotNull
            private final Requirement frontendSplit;

            public ModuleRequirement(@NotNull Requirement backend, @NotNull Requirement frontend, @NotNull Requirement frontendSplit) {
                Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
                Intrinsics.checkNotNullParameter((Object)((Object)frontend), (String)"frontend");
                Intrinsics.checkNotNullParameter((Object)((Object)frontendSplit), (String)"frontendSplit");
                this.backend = backend;
                this.frontend = frontend;
                this.frontendSplit = frontendSplit;
            }

            @NotNull
            public final Requirement getBackend() {
                return this.backend;
            }

            @NotNull
            public final Requirement getFrontend() {
                return this.frontend;
            }

            @NotNull
            public final Requirement getFrontendSplit() {
                return this.frontendSplit;
            }

            @NotNull
            public final Requirement component1() {
                return this.backend;
            }

            @NotNull
            public final Requirement component2() {
                return this.frontend;
            }

            @NotNull
            public final Requirement component3() {
                return this.frontendSplit;
            }

            @NotNull
            public final ModuleRequirement copy(@NotNull Requirement backend, @NotNull Requirement frontend, @NotNull Requirement frontendSplit) {
                Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
                Intrinsics.checkNotNullParameter((Object)((Object)frontend), (String)"frontend");
                Intrinsics.checkNotNullParameter((Object)((Object)frontendSplit), (String)"frontendSplit");
                return new ModuleRequirement(backend, frontend, frontendSplit);
            }

            public static /* synthetic */ ModuleRequirement copy$default(ModuleRequirement moduleRequirement, Requirement requirement, Requirement requirement2, Requirement requirement3, int n, Object object) {
                if ((n & 1) != 0) {
                    requirement = moduleRequirement.backend;
                }
                if ((n & 2) != 0) {
                    requirement2 = moduleRequirement.frontend;
                }
                if ((n & 4) != 0) {
                    requirement3 = moduleRequirement.frontendSplit;
                }
                return moduleRequirement.copy(requirement, requirement2, requirement3);
            }

            @NotNull
            public String toString() {
                return "ModuleRequirement(backend=" + this.backend + ", frontend=" + this.frontend + ", frontendSplit=" + this.frontendSplit + ")";
            }

            public int hashCode() {
                int result2 = this.backend.hashCode();
                result2 = result2 * 31 + this.frontend.hashCode();
                result2 = result2 * 31 + this.frontendSplit.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ModuleRequirement)) {
                    return false;
                }
                ModuleRequirement moduleRequirement = (ModuleRequirement)other;
                if (this.backend != moduleRequirement.backend) {
                    return false;
                }
                if (this.frontend != moduleRequirement.frontend) {
                    return false;
                }
                return this.frontendSplit == moduleRequirement.frontendSplit;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/plugins/frontend/split/PluginProductModeCompatibility$Companion$Requirement;", "", "<init>", "(Ljava/lang/String;I)V", "UNKNOWN", "OPTIONAL", "REQUIRED", "intellij.platform.plugins.frontend.split"})
        private static final class Requirement
        extends Enum<Requirement> {
            public static final /* enum */ Requirement UNKNOWN = new Requirement();
            public static final /* enum */ Requirement OPTIONAL = new Requirement();
            public static final /* enum */ Requirement REQUIRED = new Requirement();
            private static final /* synthetic */ Requirement[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Requirement[] values() {
                return (Requirement[])$VALUES.clone();
            }

            public static Requirement valueOf(String value) {
                return Enum.valueOf(Requirement.class, value);
            }

            @NotNull
            public static EnumEntries<Requirement> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = requirementArray = new Requirement[]{Requirement.UNKNOWN, Requirement.OPTIONAL, Requirement.REQUIRED};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

