/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.codeInsight;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestRecognitionUtilsKt;
import com.intellij.httpClient.http.request.highlighting.AddRequestSeparatorFix;
import com.intellij.httpClient.http.request.highlighting.ReplacementInfo;
import com.intellij.httpClient.http.request.psi.HttpMessageBody;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/httpClient/http/request/codeInsight/HttpRequestRequestSeparatorBodyInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "registerProblem", "", "matchResult", "Lkotlin/text/MatchResult;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.restClient"})
public abstract class HttpRequestRequestSeparatorBodyInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(holder.getFile().getContext() instanceof HttpMessageBody)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return new PsiElementVisitor(this, holder){
            final /* synthetic */ HttpRequestRequestSeparatorBodyInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            /*
             * WARNING - void declaration
             */
            public void visitFile(PsiFile psiFile) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                String text2 = psiFile.getText();
                Intrinsics.checkNotNull((Object)text2);
                Project project = psiFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Sequence<MatchResult> sequence = HttpRequestRecognitionUtilsKt.findAllPossibleHttpRequests(text2, project, true);
                HttpRequestRequestSeparatorBodyInspection httpRequestRequestSeparatorBodyInspection = this.this$0;
                ProblemsHolder problemsHolder = this.$holder;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    MatchResult it = (MatchResult)element$iv;
                    boolean bl = false;
                    HttpRequestRequestSeparatorBodyInspection.access$registerProblem(httpRequestRequestSeparatorBodyInspection, it, problemsHolder, (PsiElement)psiFile);
                }
            }
        };
    }

    private final void registerProblem(MatchResult matchResult, ProblemsHolder holder, PsiElement element) {
        int startIndexInDocument = matchResult.getRange().getFirst();
        int endIndexInDocument = matchResult.getRange().getLast() + 1;
        ReplacementInfo replacementInfo = new ReplacementInfo(((Object)StringsKt.trim((CharSequence)matchResult.getValue())).toString(), startIndexInDocument, endIndexInDocument);
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new AddRequestSeparatorFix(element, replacementInfo)};
        holder.registerProblem(element, RestClientBundle.message("http.client.code.style.inspection.add.request.separator.message", new Object[0]), ProblemHighlightType.WEAK_WARNING, new TextRange(startIndexInDocument + HttpRequestRecognitionUtilsKt.emptySpacesCount(matchResult), endIndexInDocument), localQuickFixArray);
    }

    public static final /* synthetic */ void access$registerProblem(HttpRequestRequestSeparatorBodyInspection $this, MatchResult matchResult, ProblemsHolder holder, PsiElement element) {
        $this.registerProblem(matchResult, holder, element);
    }
}

