/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.codeInsight.encoding;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.codeInsight.encoding.HttpRequestAmbiguityEncodingKt;
import com.intellij.httpClient.http.request.codeInsight.encoding.HttpRequestNoAutoEncodeTagQuickFix;
import com.intellij.httpClient.http.request.codeInsight.encoding.HttpRequestReplacePlusQuickFix;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocComment;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocNoAutoEncodingTag;
import com.intellij.httpClient.http.request.psi.HttpQuery;
import com.intellij.httpClient.http.request.psi.HttpQueryParameterKey;
import com.intellij.httpClient.http.request.psi.HttpQueryParameterValue;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.httpClient.http.request.psi.HttpRequestCompositeElement;
import com.intellij.httpClient.http.request.psi.HttpVariable;
import com.intellij.httpClient.http.request.psi.HttpVisitor;
import com.intellij.httpClient.http.request.substitutor.HttpRequestVariableSubstitutorFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\"\u0010\u0014\u001a\u00020\u00152\u0018\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00190\u00180\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/httpClient/http/request/codeInsight/encoding/HttpQueryParameterVisitor;", "Lcom/intellij/httpClient/http/request/psi/HttpVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitRequestBlock", "", "o", "Lcom/intellij/httpClient/http/request/psi/HttpRequestBlock;", "checkQueryParameterEncoding", "Lcom/intellij/httpClient/http/request/psi/HttpQuery;", "registerPlusSignProblem", "httpQueryCompositeElement", "Lcom/intellij/httpClient/http/request/psi/HttpRequestCompositeElement;", "registerProblem", "element", "Lcom/intellij/psi/PsiElement;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "hasEncoding", "", "queryElements", "", "Lkotlin/Pair;", "", "hasNoAutoEncodingTag", "request", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpRequestAmbiguityEncoding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestAmbiguityEncoding.kt\ncom/intellij/httpClient/http/request/codeInsight/encoding/HttpQueryParameterVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,105:1\n1#2:106\n777#3:107\n873#3,2:108\n1915#3,2:110\n1207#4,3:112\n*S KotlinDebug\n*F\n+ 1 HttpRequestAmbiguityEncoding.kt\ncom/intellij/httpClient/http/request/codeInsight/encoding/HttpQueryParameterVisitor\n*L\n45#1:107\n45#1:108,2\n46#1:110,2\n58#1:112,3\n*E\n"})
final class HttpQueryParameterVisitor
extends HttpVisitor {
    @NotNull
    private final ProblemsHolder holder;

    public HttpQueryParameterVisitor(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    @Override
    public void visitRequestBlock(@NotNull HttpRequestBlock o) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            HttpRequest httpRequest = o.getRequest();
            Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"getRequest(...)");
            HttpRequest request = httpRequest;
            if (this.hasNoAutoEncodingTag(request)) {
                return;
            }
            HttpRequestCompositeElement httpRequestCompositeElement = request.getRequestTarget();
            if (httpRequestCompositeElement == null || (httpRequestCompositeElement = httpRequestCompositeElement.getQuery()) == null) break block1;
            HttpRequestCompositeElement p0 = httpRequestCompositeElement;
            boolean bl = false;
            this.checkQueryParameterEncoding((HttpQuery)p0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkQueryParameterEncoding(HttpQuery o) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = HttpRequestVariableSubstitutorFactory.getInstance().getDefault(this.holder.getProject(), this.holder.getFile());
        Intrinsics.checkNotNullExpressionValue((Object)httpRequestVariableSubstitutor, (String)"getDefault(...)");
        HttpRequestVariableSubstitutor substitutor2 = httpRequestVariableSubstitutor;
        List<Pair<HttpRequestCompositeElement, String>> queryElements = HttpRequestAmbiguityEncodingKt.getQueryElements(o, substitutor2);
        if (!this.hasEncoding(queryElements)) {
            return;
        }
        Iterable iterable = queryElements;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            String s = (String)pair.component2();
            if (!StringsKt.contains$default((CharSequence)s, (char)'+', (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            HttpRequestCompositeElement variable = (HttpRequestCompositeElement)pair.component1();
            this.registerPlusSignProblem(variable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void registerPlusSignProblem(HttpRequestCompositeElement httpQueryCompositeElement) {
        boolean bl;
        HttpRequestCompositeElement httpRequestCompositeElement = httpQueryCompositeElement;
        if (httpRequestCompositeElement instanceof HttpQueryParameterKey) {
            List<HttpVariable> list2 = ((HttpQueryParameterKey)httpQueryCompositeElement).getVariableList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getVariableList(...)");
            bl = !((Collection)list2).isEmpty();
        } else if (httpRequestCompositeElement instanceof HttpQueryParameterValue) {
            List<HttpVariable> list3 = ((HttpQueryParameterValue)httpQueryCompositeElement).getVariableList();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getVariableList(...)");
            bl = !((Collection)list3).isEmpty();
        } else {
            return;
        }
        boolean hasVariable = bl;
        if (hasVariable) {
            HttpQueryParameterVisitor.registerProblem$default(this, this.holder, (PsiElement)httpQueryCompositeElement, null, 2, null);
        } else {
            String string = httpQueryCompositeElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            CharSequence $this$forEachIndexed$iv = string;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
                void c;
                char item$iv = $this$forEachIndexed$iv.charAt(i);
                int n = index$iv++;
                char c2 = item$iv;
                int index = n;
                boolean bl2 = false;
                if (c != 43) continue;
                this.registerProblem(this.holder, (PsiElement)httpQueryCompositeElement, TextRange.from((int)index, (int)1));
            }
        }
    }

    private final void registerProblem(ProblemsHolder $this$registerProblem, PsiElement element, TextRange textRange) {
        if (textRange == null) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new HttpRequestNoAutoEncodeTagQuickFix()};
            $this$registerProblem.registerProblem(element, RestClientBundle.message("http.client.ambiguity.encoding.plus.sign.warning", new Object[0]), ProblemHighlightType.WEAK_WARNING, localQuickFixArray);
        } else {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new HttpRequestReplacePlusQuickFix(), new HttpRequestNoAutoEncodeTagQuickFix()};
            $this$registerProblem.registerProblem(element, RestClientBundle.message("http.client.ambiguity.encoding.plus.sign.warning", new Object[0]), ProblemHighlightType.WEAK_WARNING, textRange, localQuickFixArray);
        }
    }

    static /* synthetic */ void registerProblem$default(HttpQueryParameterVisitor httpQueryParameterVisitor, ProblemsHolder problemsHolder, PsiElement psiElement, TextRange textRange, int n, Object object) {
        if ((n & 2) != 0) {
            textRange = null;
        }
        httpQueryParameterVisitor.registerProblem(problemsHolder, psiElement, textRange);
    }

    private final boolean hasEncoding(List<? extends Pair<? extends HttpRequestCompositeElement, String>> queryElements) {
        Object v0;
        block1: {
            Iterable iterable = queryElements;
            for (Object t : iterable) {
                Pair pair = (Pair)t;
                boolean bl = false;
                String s = (String)pair.component2();
                CharSequence charSequence = s;
                if (!HttpRequestAmbiguityEncodingKt.access$getEncodedSymbolRegex$p().containsMatchIn(charSequence)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    private final boolean hasNoAutoEncodingTag(HttpRequest request) {
        HttpDocComment docComment = HttpRequestPsiUtils.findDocComment(request);
        return HttpRequestPsiUtils.findDocCommentOfType(docComment, HttpDocNoAutoEncodingTag.class) != null;
    }
}

