/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.fullLine.experiments.filter.model;

import com.intellij.fullLine.experiments.filter.model.DecisionFunctionWithLanguages;
import com.intellij.fullLine.experiments.filter.model.FullLineRelevanceModelsUtilKt;
import com.intellij.fullLine.experiments.filter.model.LocalCatBoostModelProvider;
import com.intellij.internal.ml.DecisionFunction;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\r\u0010\u0014\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0015J\f\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0013H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/intellij/fullLine/experiments/filter/model/FullLineRelevanceModelsUtil;", "", "<init>", "()V", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "localModel", "Lcom/intellij/fullLine/experiments/filter/model/FullLineRelevanceModelsUtil$LocalModalInfo;", "threshold", "", "Ljava/lang/Double;", "registry", "Lcom/intellij/openapi/util/registry/RegistryValue;", "getRegistry", "()Lcom/intellij/openapi/util/registry/RegistryValue;", "getModel", "Lcom/intellij/internal/ml/DecisionFunction;", "languageId", "", "getThreshold", "()Ljava/lang/Double;", "scheduleInitModel", "Ljava/util/concurrent/Future;", "isPathToTheModelSetAndValid", "", "isPathToTheModelChanged", "initModelFromPathToZipSynchronously", "", "loadModelAndThreshold", "pathToZip", "LocalModalInfo", "intellij.fullLine.experiments"})
@SourceDebugExtension(value={"SMAP\nFullLineRelevanceModelsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineRelevanceModelsUtil.kt\ncom/intellij/fullLine/experiments/filter/model/FullLineRelevanceModelsUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public abstract class FullLineRelevanceModelsUtil {
    @NotNull
    private final ExecutorService executor;
    @Nullable
    private volatile LocalModalInfo localModel;
    @Nullable
    private volatile Double threshold;

    public FullLineRelevanceModelsUtil() {
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"FLCC pool executor");
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createSequentialApplicationPoolExecutor(...)");
        this.executor = executorService;
    }

    @NotNull
    public abstract RegistryValue getRegistry();

    @Nullable
    public final DecisionFunction getModel(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        if (!this.isPathToTheModelSetAndValid()) {
            this.localModel = null;
            return null;
        }
        if (this.isPathToTheModelChanged()) {
            this.scheduleInitModel();
            return null;
        }
        LocalModalInfo localModalInfo = this.localModel;
        if (localModalInfo == null) {
            return null;
        }
        LocalModalInfo resLocalModel = localModalInfo;
        Set<String> set = resLocalModel.getLanguages();
        String string = languageId;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return set.contains(string2) ? resLocalModel.getDecisionFunction() : null;
    }

    @Nullable
    public final Double getThreshold() {
        return this.threshold;
    }

    private final Future<?> scheduleInitModel() {
        Future<?> future = this.executor.submit(() -> FullLineRelevanceModelsUtil.scheduleInitModel$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
        return future;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPathToTheModelSetAndValid() {
        if (!this.getRegistry().isChangedFromDefault()) return false;
        Path path = Paths.get(this.getRegistry().asString(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        return true;
    }

    private final boolean isPathToTheModelChanged() {
        LocalModalInfo localModalInfo = this.localModel;
        return !Intrinsics.areEqual((Object)this.getRegistry().asString(), (Object)(localModalInfo != null ? localModalInfo.getPath() : null));
    }

    private final void initModelFromPathToZipSynchronously() {
        this.localModel = null;
        this.threshold = null;
        long startTime = System.currentTimeMillis();
        String pathToZip = this.getRegistry().asString();
        this.loadModelAndThreshold(pathToZip);
        long endTime = System.currentTimeMillis();
        FullLineRelevanceModelsUtilKt.access$getLOG$p().info("Full Line relevance model initialization took: " + (endTime - startTime) + " ms.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadModelAndThreshold(String pathToZip) {
        try {
            Closeable closeable = new ZipFile(pathToZip);
            Throwable throwable = null;
            try {
                LocalCatBoostModelProvider localCatBoostModelProvider;
                LocalCatBoostModelProvider localCatBoostModelProvider2;
                ZipFile file = (ZipFile)closeable;
                boolean bl = false;
                LocalCatBoostModelProvider it = localCatBoostModelProvider2 = new LocalCatBoostModelProvider();
                boolean bl2 = false;
                if ((it.isSupportedFormat(file) ? localCatBoostModelProvider2 : null) == null) {
                    return;
                }
                LocalCatBoostModelProvider loader = localCatBoostModelProvider;
                DecisionFunctionWithLanguages decisionFunctionWithLanguages = loader.loadModel(file);
                DecisionFunction decisionFunction = decisionFunctionWithLanguages.component1();
                List<String> languages = decisionFunctionWithLanguages.component2();
                this.localModel = new LocalModalInfo(decisionFunction, pathToZip, CollectionsKt.toSet((Iterable)languages));
                InputStream inputStream = file.getInputStream(file.getEntry("threshold.txt"));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                Closeable closeable2 = inputStream;
                Charset charset = Charsets.UTF_8;
                closeable2 = new InputStreamReader((InputStream)closeable2, charset);
                int n = 8192;
                String string = (closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n)).readLine();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readLine(...)");
                this.threshold = Double.parseDouble(string);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable t) {
            FullLineRelevanceModelsUtilKt.access$getLOG$p().error(t);
        }
    }

    private static final void scheduleInitModel$lambda$0(FullLineRelevanceModelsUtil this$0) {
        this$0.initModelFromPathToZipSynchronously();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0001J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u0005H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/fullLine/experiments/filter/model/FullLineRelevanceModelsUtil$LocalModalInfo;", "", "decisionFunction", "Lcom/intellij/internal/ml/DecisionFunction;", "path", "", "languages", "", "<init>", "(Lcom/intellij/internal/ml/DecisionFunction;Ljava/lang/String;Ljava/util/Set;)V", "getDecisionFunction", "()Lcom/intellij/internal/ml/DecisionFunction;", "getPath", "()Ljava/lang/String;", "getLanguages", "()Ljava/util/Set;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.fullLine.experiments"})
    private static final class LocalModalInfo {
        @NotNull
        private final DecisionFunction decisionFunction;
        @NotNull
        private final String path;
        @NotNull
        private final Set<String> languages;

        public LocalModalInfo(@NotNull DecisionFunction decisionFunction, @NotNull String path, @NotNull Set<String> languages) {
            Intrinsics.checkNotNullParameter((Object)decisionFunction, (String)"decisionFunction");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(languages, (String)"languages");
            this.decisionFunction = decisionFunction;
            this.path = path;
            this.languages = languages;
        }

        @NotNull
        public final DecisionFunction getDecisionFunction() {
            return this.decisionFunction;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final Set<String> getLanguages() {
            return this.languages;
        }

        @NotNull
        public final DecisionFunction component1() {
            return this.decisionFunction;
        }

        @NotNull
        public final String component2() {
            return this.path;
        }

        @NotNull
        public final Set<String> component3() {
            return this.languages;
        }

        @NotNull
        public final LocalModalInfo copy(@NotNull DecisionFunction decisionFunction, @NotNull String path, @NotNull Set<String> languages) {
            Intrinsics.checkNotNullParameter((Object)decisionFunction, (String)"decisionFunction");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(languages, (String)"languages");
            return new LocalModalInfo(decisionFunction, path, languages);
        }

        public static /* synthetic */ LocalModalInfo copy$default(LocalModalInfo localModalInfo, DecisionFunction decisionFunction, String string, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                decisionFunction = localModalInfo.decisionFunction;
            }
            if ((n & 2) != 0) {
                string = localModalInfo.path;
            }
            if ((n & 4) != 0) {
                set = localModalInfo.languages;
            }
            return localModalInfo.copy(decisionFunction, string, set);
        }

        @NotNull
        public String toString() {
            return "LocalModalInfo(decisionFunction=" + this.decisionFunction + ", path=" + this.path + ", languages=" + this.languages + ")";
        }

        public int hashCode() {
            int result2 = this.decisionFunction.hashCode();
            result2 = result2 * 31 + this.path.hashCode();
            result2 = result2 * 31 + ((Object)this.languages).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LocalModalInfo)) {
                return false;
            }
            LocalModalInfo localModalInfo = (LocalModalInfo)other;
            if (!Intrinsics.areEqual((Object)this.decisionFunction, (Object)localModalInfo.decisionFunction)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path, (Object)localModalInfo.path)) {
                return false;
            }
            return Intrinsics.areEqual(this.languages, localModalInfo.languages);
        }
    }
}

