/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.layout;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBundle;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.layout.GraphLayout;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.partial.PartialLayouter;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.services.GraphUndoService;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyCurrentLayoutAction
extends AbstractGraphAction {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e2, @NotNull Graph2D graph) {
        GraphBuilder<?, ?> graphBuilder;
        if (e2 == null) {
            ApplyCurrentLayoutAction.o(0);
        }
        if (graph == null) {
            ApplyCurrentLayoutAction.o(1);
        }
        if ((graphBuilder = this.getBuilder(e2)) == null) {
            return;
        }
        Layouter layouter = this.getLayouter(graphBuilder);
        if (layouter == null) {
            return;
        }
        GraphLayoutService.GraphLayoutQueryParams graphLayoutQueryParams = GraphLayoutService.getInstance().queryLayout(graphBuilder).animated().withLayouter(layouter);
        GraphLayoutService.GraphLayoutQueryParams graphLayoutQueryParams2 = ApplyCurrentLayoutAction.b(graphBuilder, graphLayoutQueryParams);
        GraphLayoutService.getInstance().calcLayoutAsync(graphBuilder, Objects.requireNonNull(graphLayoutQueryParams2.getLayouter())).thenAcceptAsync(graphLayout -> GraphUndoService.getInstance().performPositionsOnlyChangingAction(graphBuilder, this.getActionName(), () -> graphLayoutQueryParams2.withCustomLayout((GraphLayout)graphLayout).run()), Futures.inEdt());
    }

    @Override
    public void update(@NotNull AnActionEvent e2, @NotNull Graph2D graph) {
        if (e2 == null) {
            ApplyCurrentLayoutAction.o(2);
        }
        if (graph == null) {
            ApplyCurrentLayoutAction.o(3);
        }
        Project project = ApplyCurrentLayoutAction.getProject(e2);
        Presentation presentation = e2.getPresentation();
        presentation.setEnabled(project != null && graph.nodeCount() > 0 && this.canLayout(this.getBuilder(e2)));
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ApplyCurrentLayoutAction.o(4);
        }
        return actionUpdateThread;
    }

    @Nls
    protected String getActionName() {
        return GraphBundle.message("action.Graph.ApplyCurrentLayout.text", new Object[0]);
    }

    @Nullable
    protected Layouter getLayouter(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            ApplyCurrentLayoutAction.o(5);
        }
        return builder.getGraphPresentationModel().getSettings().getCurrentLayouter();
    }

    protected boolean canLayout(@Nullable GraphBuilder<?, ?> builder) {
        if (builder == null) {
            return false;
        }
        try {
            Layouter layouter = this.getLayouter(builder);
            return layouter != null && GraphLayoutService.getInstance().canLayout(builder, layouter);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @NotNull
    private static GraphLayoutService.GraphLayoutQueryParams b(@NotNull GraphBuilder<?, ?> graphBuilder, @NotNull GraphLayoutService.GraphLayoutQueryParams graphLayoutQueryParams) {
        if (graphBuilder == null) {
            ApplyCurrentLayoutAction.o(6);
        }
        if (graphLayoutQueryParams == null) {
            ApplyCurrentLayoutAction.o(7);
        }
        Layouter layouter = Objects.requireNonNull(graphLayoutQueryParams.getLayouter());
        if (GraphSelectionService.getInstance().anyNodeOrEdgeSelected(graphBuilder.getGraph()) && !(layouter instanceof PartialLayouter)) {
            if (GraphLayoutService.getInstance().isEdgeRouter(layouter)) {
                GraphLayoutService.getInstance().setupDataProvidersForEdgeRouterBasedOnCurrentSelection(layouter, graphBuilder);
                GraphLayoutService.GraphLayoutQueryParams graphLayoutQueryParams2 = graphLayoutQueryParams.withFitContent(GraphLayoutService.GraphLayoutQueryParams.FitContentOption.NEVER);
                if (graphLayoutQueryParams2 == null) {
                    ApplyCurrentLayoutAction.o(8);
                }
                return graphLayoutQueryParams2;
            }
            List<Node> list = GraphSelectionService.getInstance().getSelectedNodes(graphBuilder.getGraph());
            List<Edge> list2 = GraphSelectionService.getInstance().getSelectedEdges(graphBuilder.getGraph());
            Layouter layouter2 = GraphLayoutService.getInstance().getPartialLayouter(layouter, true);
            GraphLayoutService.getInstance().markElementsForPartialLayout(graphBuilder.getGraph(), list, list2);
            GraphLayoutService.GraphLayoutQueryParams graphLayoutQueryParams3 = graphLayoutQueryParams.withLayouter(layouter2).withFitContent(GraphLayoutService.GraphLayoutQueryParams.FitContentOption.NEVER);
            if (graphLayoutQueryParams3 == null) {
                ApplyCurrentLayoutAction.o(9);
            }
            return graphLayoutQueryParams3;
        }
        GraphLayoutService.GraphLayoutQueryParams graphLayoutQueryParams4 = graphLayoutQueryParams;
        if (graphLayoutQueryParams4 == null) {
            ApplyCurrentLayoutAction.o(10);
        }
        return graphLayoutQueryParams4;
    }

    private static /* synthetic */ void o(int n10) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n10) {
            default -> 3;
            case 4, 8, 9, 10 -> 2;
        }];
        switch (n10) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/actions/layout/ApplyCurrentLayoutAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutParams";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/actions/layout/ApplyCurrentLayoutAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setupLayoutOfSelectionOnlyIfNeeded";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLayouter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setupLayoutOfSelectionOnlyIfNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n10) {
            default -> new IllegalArgumentException(string);
            case 4, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

