/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.components;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SelectionDependenciesPresentationModel<N, E>
extends BasicGraphPresentationModel<N, E> {
    private boolean myFilterDependenciesMode;

    public SelectionDependenciesPresentationModel(@NotNull Graph graph) {
        if (graph == null) {
            SelectionDependenciesPresentationModel.J(0);
        }
        super(graph);
        this.myFilterDependenciesMode = true;
    }

    public SelectionDependenciesPresentationModel(@NotNull Graph graph, boolean filterDependencies) {
        if (graph == null) {
            SelectionDependenciesPresentationModel.J(1);
        }
        super(graph);
        this.myFilterDependenciesMode = true;
        this.myFilterDependenciesMode = filterDependencies;
    }

    @Override
    public void setGraphBuilder(@NotNull GraphBuilder<N, E> builder) {
        if (builder == null) {
            SelectionDependenciesPresentationModel.J(2);
        }
        super.setGraphBuilder(builder);
        this.addGraph2DSelectionListener(builder);
    }

    protected void addGraph2DSelectionListener(@NotNull GraphBuilder<N, E> builder) {
        if (builder == null) {
            SelectionDependenciesPresentationModel.J(3);
        }
        builder.getGraph().addGraph2DSelectionListener(new MyGraph2DSelectionListener(builder));
    }

    public boolean isFilterDependenciesMode() {
        return this.myFilterDependenciesMode;
    }

    public void setFilterDependenciesMode(boolean filterDependenciesMode) {
        this.myFilterDependenciesMode = filterDependenciesMode;
        this.getGraphBuilder().queryGraphUpdate().withDataReload().withRelayout().run();
    }

    public static <N, E> void filterSelectedNodesDependencies(GraphBuilder<N, E> builder, boolean updateGraph) {
        List list = GraphSelectionService.getInstance().getSelectedModelNodes(builder);
        if (list.isEmpty()) {
            return;
        }
        if (updateGraph) {
            builder.queryGraphUpdate().withDataReload().withRelayout().run();
        }
        HashSet hashSet = new HashSet();
        GraphDataModel graphDataModel = builder.getGraphDataModel();
        for (N n10 : list) {
            for (E e2 : builder.getEdgeObjects()) {
                if (!n10.equals(graphDataModel.getSourceNode(e2)) && !n10.equals(graphDataModel.getTargetNode(e2))) continue;
                hashSet.add(e2);
            }
        }
        builder.getActionExecutor().runGraphActionAsync(() -> {
            Collection collection = builder.getEdgeObjects();
            for (Object object : ArrayUtil.toObjectArray(collection)) {
                if (hashSet.contains(object)) continue;
                builder.removeEdge(object);
            }
            Collection collection2 = builder.getNodeObjects();
            for (Object object : ArrayUtil.toObjectArray(collection2)) {
                if (list.contains(object)) continue;
                boolean bl2 = true;
                for (Object e2 : hashSet) {
                    if (!object.equals(graphDataModel.getSourceNode(e2)) && !object.equals(graphDataModel.getTargetNode(e2))) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                builder.removeNode(object);
            }
        });
        GraphLayoutService.getInstance().queryLayout(builder).run();
        builder.getView().fitContent();
    }

    private static /* synthetic */ void J(int n10) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n10) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/graph/builder/components/SelectionDependenciesPresentationModel";
        switch (n10) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setGraphBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addGraph2DSelectionListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyGraph2DSelectionListener
    implements Graph2DSelectionListener {
        @NotNull
        private final GraphBuilder<N, E> myBuilder;

        MyGraph2DSelectionListener(GraphBuilder<N, E> builder) {
            if (builder == null) {
                MyGraph2DSelectionListener.b(0);
            }
            this.myBuilder = builder;
            builder.addCustomUpdater(new CustomGraphUpdater(){

                @Override
                public void update(@NotNull Graph2D graph, @NotNull Graph2DView view, @NotNull Collection<?> nodesForSizeUpdate) {
                    if (graph == null) {
                        1.o(0);
                    }
                    if (view == null) {
                        1.o(1);
                    }
                    if (nodesForSizeUpdate == null) {
                        1.o(2);
                    }
                    if (SelectionDependenciesPresentationModel.this.isFilterDependenciesMode()) {
                        MyGraph2DSelectionListener.this.updateDependencies(false);
                    }
                }

                private static /* synthetic */ void o(int n10) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n10) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "graph";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "view";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "nodesForSizeUpdate";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/graph/builder/components/SelectionDependenciesPresentationModel$MyGraph2DSelectionListener$1";
                    objectArray[2] = "update";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        protected void updateDependencies(boolean updateGraph) {
            ApplicationManager.getApplication().invokeLater(() -> SelectionDependenciesPresentationModel.filterSelectedNodesDependencies(this.myBuilder, updateGraph));
        }

        @Override
        public void onGraph2DSelectionEvent(@NotNull Graph2DSelectionEvent e2) {
            if (e2 == null) {
                MyGraph2DSelectionListener.b(1);
            }
            if (SelectionDependenciesPresentationModel.this.isFilterDependenciesMode() && e2.isNodeSelection()) {
                this.updateDependencies(true);
            }
        }

        private static /* synthetic */ void b(int n10) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n10) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/graph/builder/components/SelectionDependenciesPresentationModel$MyGraph2DSelectionListener";
            switch (n10) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onGraph2DSelectionEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

