/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.renderer;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.renderer.AbstractColoredNodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class BasicGraphNodeRenderer<N, E>
extends AbstractColoredNodeCellRenderer {
    private final GraphBuilder<N, E> myBuilder;

    public BasicGraphNodeRenderer(GraphBuilder<N, E> builder, ModificationTracker modificationTracker) {
        super(modificationTracker);
        this.myBuilder = builder;
    }

    @Override
    public void tuneNode(NodeRealizer nodeRealizer, JPanel wrapper) {
        Node node = nodeRealizer.getNode();
        N n10 = this.myBuilder.getNodeObject(node);
        if (n10 == null) {
            return;
        }
        wrapper.add((Component)this.getIconLabel(n10), "West");
        wrapper.add((Component)this.getLabelPanel(nodeRealizer), "Center");
    }

    protected JComponent getLabelPanel(NodeRealizer nodeRealizer) {
        Node node = nodeRealizer.getNode();
        N n10 = this.myBuilder.getNodeObject(node);
        CellRendererPanel cellRendererPanel = new CellRendererPanel((LayoutManager)new BorderLayout());
        cellRendererPanel.setBorder(BorderFactory.createLineBorder((Color)JBColor.white, 2));
        cellRendererPanel.setForcedBackground(this.getBackground(n10));
        String string = this.getNodeName(n10);
        JComponent jComponent = this.getPresenationComponent(string);
        jComponent.setForeground(this.getForeground(n10));
        jComponent.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        cellRendererPanel.add((Component)jComponent, (Object)"West");
        return cellRendererPanel;
    }

    protected JComponent getPresenationComponent(@NlsContexts.Label String text) {
        return new JLabel(text);
    }

    protected Color getForeground(N node) {
        return JBColor.foreground();
    }

    protected Color getBackground(N node) {
        return JBColor.background();
    }

    protected Icon getIcon(N node) {
        return AllIcons.FileTypes.Unknown;
    }

    protected JComponent getIconLabel(N node) {
        JLabel jLabel = new JLabel(this.getIcon(node));
        jLabel.setBorder(JBUI.Borders.empty((int)5));
        return jLabel;
    }

    @NlsContexts.Label
    protected String getNodeName(N node) {
        return "";
    }

    public GraphBuilder<N, E> getBuilder() {
        return this.myBuilder;
    }
}

