/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.layout.DiscreteNodeLabelModel;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.YLabel;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0004\u001a\u00020\u00052\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/graph/impl/GraphGroupingUtil;", "", "GraphGroupingUtil", "()V", "createDefaultGroupNodeRealizer", "Lcom/intellij/openapi/graph/view/hierarchy/GroupNodeRealizer;", "groupName", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "borderColor", "Ljava/awt/Color;", "labelIcon", "Ljavax/swing/Icon;", "isClosed", "", "intellij.platform.graph.impl"})
public final class GraphGroupingUtil {
    @NotNull
    public static final GraphGroupingUtil INSTANCE = new GraphGroupingUtil();

    private GraphGroupingUtil() {
    }

    @JvmStatic
    @NotNull
    public static final GroupNodeRealizer createDefaultGroupNodeRealizer(@NotNull String groupName, @NotNull Color borderColor, @Nullable Icon labelIcon, boolean isClosed) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        Intrinsics.checkNotNullParameter((Object)borderColor, (String)"borderColor");
        GroupNodeRealizer groupNodeRealizer = GraphManager.getGraphManager().createGroupNodeRealizer();
        groupNodeRealizer.setGroupClosed(isClosed);
        groupNodeRealizer.setAutoBoundsEnabled(true);
        groupNodeRealizer.setInnerGraphDisplayEnabled(false);
        groupNodeRealizer.setConsiderNodeLabelSize(true);
        groupNodeRealizer.setMinimalInsets(GraphManager.getGraphManager().createYInsets(10.0, 7.0, 10.0, 10.0));
        groupNodeRealizer.setOpenGroupIcon(null);
        groupNodeRealizer.setClosedGroupIcon(null);
        groupNodeRealizer.setFillColor(null);
        groupNodeRealizer.setLineColor(borderColor);
        groupNodeRealizer.setLineType(LineType.LINE_1);
        groupNodeRealizer.setLabelText(groupName);
        NodeLabel nodeLabel = groupNodeRealizer.getLabel();
        nodeLabel.setLabelModel(GraphManager.getGraphManager().createDiscreteNodeLabelModel(DiscreteNodeLabelModel.TOP));
        nodeLabel.setAutoSizePolicy(YLabel.AUTOSIZE_CONTENT);
        nodeLabel.setInsets((Insets)JBUI.insets((int)5, (int)7, (int)0, (int)10));
        nodeLabel.setBackgroundColor(null);
        nodeLabel.setTextColor(borderColor);
        nodeLabel.setFont(StartupUiUtil.getLabelFont());
        nodeLabel.setHorizontalTextPosition(YLabel.RIGHT_TEXT_POSITION);
        nodeLabel.setVerticalTextPosition(YLabel.CENTER_TEXT_POSITION);
        nodeLabel.setIcon(labelIcon);
        nodeLabel.setIconTextGap((byte)5);
        nodeLabel.setFontStyle(1);
        Intrinsics.checkNotNull((Object)groupNodeRealizer);
        return groupNodeRealizer;
    }
}

