/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.services;

import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.geom.YPoint;
import com.intellij.openapi.graph.layout.GraphLayout;
import com.intellij.openapi.graph.layout.NodeLayout;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class GraphCanvasLocationService {
    @NotNull
    private static final GraphCanvasLocationService INSTANCE = new GraphCanvasLocationService();

    @NotNull
    public static GraphCanvasLocationService getInstance() {
        GraphCanvasLocationService graphCanvasLocationService = INSTANCE;
        if (graphCanvasLocationService == null) {
            GraphCanvasLocationService.b(0);
        }
        return graphCanvasLocationService;
    }

    private GraphCanvasLocationService() {
    }

    @NotNull
    public Point getNodeCoordinatesOnScreen(@NotNull Node node, @NotNull GraphBuilder<?, ?> builder) {
        if (node == null) {
            GraphCanvasLocationService.b(1);
        }
        if (builder == null) {
            GraphCanvasLocationService.b(2);
        }
        Graph2D graph2D = builder.getGraph();
        Graph2DView graph2DView = builder.getView();
        Point point = graph2DView.getViewPoint();
        NodeRealizer nodeRealizer = graph2D.getRealizer(node);
        double d2 = nodeRealizer.getX();
        double d3 = nodeRealizer.getY();
        JComponent jComponent = graph2DView.getCanvasComponent();
        double d4 = jComponent.getLocationOnScreen().getX();
        double d5 = jComponent.getLocationOnScreen().getY();
        double d6 = Math.max((d2 - (double)point.x) * graph2DView.getZoom() + d4, d4);
        double d7 = (d3 - (double)point.y) * graph2DView.getZoom() + d5;
        return new Point((int)d6, (int)d7);
    }

    @NotNull
    public Point getNodeCoordinatesOnCanvas(@NotNull Node node, @NotNull GraphBuilder<?, ?> builder) {
        if (node == null) {
            GraphCanvasLocationService.b(3);
        }
        if (builder == null) {
            GraphCanvasLocationService.b(4);
        }
        Graph2DView graph2DView = builder.getView();
        NodeRealizer nodeRealizer = builder.getGraph().getRealizer(node);
        return new Point(graph2DView.toViewCoordX(nodeRealizer.getX()), graph2DView.toViewCoordY(nodeRealizer.getY()));
    }

    @NotNull
    public Rectangle getNodeBoundsOnCanvas(@NotNull Node node, @NotNull GraphBuilder<?, ?> builder) {
        if (node == null) {
            GraphCanvasLocationService.b(5);
        }
        if (builder == null) {
            GraphCanvasLocationService.b(6);
        }
        Graph2DView graph2DView = builder.getView();
        double d2 = graph2DView.getZoom();
        NodeRealizer nodeRealizer = builder.getGraph().getRealizer(node);
        return new Rectangle(graph2DView.toViewCoordX(nodeRealizer.getX()), graph2DView.toViewCoordY(nodeRealizer.getY()), (int)(nodeRealizer.getWidth() * d2), (int)(nodeRealizer.getHeight() * d2));
    }

    @NotNull
    public Point getGraphCenterOnScreen(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphCanvasLocationService.b(7);
        }
        Graph2DView graph2DView = builder.getView();
        Dimension dimension = graph2DView.getViewSize();
        Point point = graph2DView.getCanvasComponent().getLocationOnScreen();
        return new Point(point.x + dimension.width / 2, point.y + dimension.height / 2);
    }

    @NotNull
    public Point getGraphCenterOnCanvas(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphCanvasLocationService.b(8);
        }
        Dimension dimension = builder.getView().getViewSize();
        return new Point(dimension.width / 2, dimension.height / 2);
    }

    @NotNull
    public Point getBestPositionForNode(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphCanvasLocationService.b(9);
        }
        double d2 = -1.7976931348623157E308;
        double d3 = -1.7976931348623157E308;
        double d4 = -1.7976931348623157E308;
        double d5 = -1.7976931348623157E308;
        double d6 = -1.7976931348623157E308;
        double d7 = Double.MAX_VALUE;
        for (Node node : builder.getGraph().getNodeArray()) {
            NodeLayout nodeLayout = builder.getGraph().getNodeLayout(node);
            if (nodeLayout == null) continue;
            double d8 = nodeLayout.getWidth();
            double d9 = nodeLayout.getX();
            double d10 = d9 + d8;
            double d11 = nodeLayout.getHeight();
            double d12 = nodeLayout.getY();
            double d13 = d12 + d11;
            if (d10 > d4) {
                d4 = d10;
            }
            if (d10 < d7) {
                d7 = d10 - d8;
            }
            if (!(d13 >= d6)) continue;
            d3 = d13 == d6 ? Math.max(d3, d9) : d9;
            d2 = Math.max(d2, d12);
            d5 = d13 == d6 ? Math.max(d10, d5) : d10;
            d6 = d13;
        }
        if (d6 == -1.7976931348623157E308 || d5 == -1.7976931348623157E308) {
            return new Point(200, 200);
        }
        Point point = new Point();
        if (d4 - d5 < 100.0) {
            point.setLocation(d7, d6 + 20.0);
        } else {
            point.setLocation(d5 + 20.0, d2);
        }
        Object object = point;
        if (object == null) {
            GraphCanvasLocationService.b(10);
        }
        return object;
    }

    public void showPopupBeneathNode(@NotNull JBPopup popup, @NotNull GraphBuilder<?, ?> builder, @NotNull Node node) {
        if (popup == null) {
            GraphCanvasLocationService.b(11);
        }
        if (builder == null) {
            GraphCanvasLocationService.b(12);
        }
        if (node == null) {
            GraphCanvasLocationService.b(13);
        }
        Graph2DView graph2DView = builder.getView();
        Point point = this.getNodeCoordinatesOnScreen(node, builder);
        popup.showInScreenCoordinates((Component)graph2DView.getCanvasComponent(), new Point(point.x, point.y + (int)(24.0 * graph2DView.getZoom())));
    }

    public void showPopupInTopCenterOfViewport(@NotNull JBPopup popup, @NotNull GraphBuilder<?, ?> builder) {
        if (popup == null) {
            GraphCanvasLocationService.b(14);
        }
        if (builder == null) {
            GraphCanvasLocationService.b(15);
        }
        JComponent jComponent = builder.getView().getCanvasComponent();
        JComponent jComponent2 = (JComponent)jComponent.getParent();
        Rectangle rectangle = jComponent2.getBounds();
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(point, jComponent2);
        Dimension dimension = popup.getSize();
        int n10 = dimension != null ? dimension.width : JBUI.scale((int)(Toolkit.getDefaultToolkit().getScreenSize().width / 3));
        popup.showInScreenCoordinates((Component)jComponent, new Point(point.x + rectangle.width / 2 - n10 / 2, point.y + 10));
    }

    public void showInGraphCenter(@NotNull JBPopup popup, @NotNull GraphBuilder<?, ?> builder) {
        if (popup == null) {
            GraphCanvasLocationService.b(16);
        }
        if (builder == null) {
            GraphCanvasLocationService.b(17);
        }
        Point point = this.getGraphCenterOnScreen(builder);
        popup.showInScreenCoordinates((Component)builder.getView().getCanvasComponent(), new Point(point.x - 100, point.y - 100));
    }

    public boolean setBestPopupSizeForGraph(@NotNull JBPopup popup, @NotNull GraphBuilder<?, ?> builder) {
        if (popup == null) {
            GraphCanvasLocationService.b(18);
        }
        if (builder == null) {
            GraphCanvasLocationService.b(19);
        }
        if (popup.isDisposed()) {
            return false;
        }
        Dimension dimension = this.calcGraphSize(builder);
        Dimension dimension2 = new Dimension(dimension.width + 40, dimension.height + 60);
        Dimension dimension3 = popup.getContent().getToolkit().getScreenSize();
        boolean bl2 = true;
        if (dimension2.width > dimension3.width - 200) {
            bl2 = false;
            dimension2.width = dimension3.width - 200;
        }
        if (dimension2.height > dimension3.height - 200) {
            bl2 = false;
            dimension2.height = dimension3.height - 200;
        }
        popup.setSize(dimension2);
        return bl2;
    }

    @NotNull
    public <N, E> Dimension calcGraphSize(@NotNull GraphBuilder<N, E> builder) {
        Object object;
        Object object2;
        if (builder == null) {
            GraphCanvasLocationService.b(20);
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (Object object3 : builder.getNodeObjects()) {
            object2 = builder.getNode(object3);
            if (object2 == null || (object = builder.getGraph().getNodeLayout(object2)) == null) continue;
            d2 = Math.min(d2, object.getX());
            d3 = Math.min(d3, object.getY());
            d4 = Math.max(d4, object.getX() + object.getWidth());
            d5 = Math.max(d5, object.getY() + object.getHeight());
        }
        for (Object object3 : builder.getEdgeObjects()) {
            object2 = builder.getEdge(object3);
            if (object2 == null || (object = builder.getGraph().getEdgeLayout(object2)) == null) continue;
            for (int i10 = 0; i10 < object.pointCount(); ++i10) {
                YPoint yPoint = object.getPoint(i10);
                d2 = Math.min(d2, yPoint.getX());
                d3 = Math.min(d3, yPoint.getY());
                d4 = Math.max(d4, yPoint.getX());
                d5 = Math.max(d5, yPoint.getY());
            }
        }
        int n10 = (int)(d4 - d2);
        int n11 = (int)(d5 - d3);
        if (n10 == 0) {
            n10 = JBUIScale.scale((int)400);
        }
        if (n11 == 0) {
            n11 = JBUIScale.scale((int)400);
        }
        return d2 == 0.0 && d3 == 0.0 && d4 == 0.0 && d5 == 0.0 ? JBUI.size((int)400) : new Dimension(n10, n11);
    }

    @NotNull
    public Rectangle getBoundingBoxOfNodes(@NotNull Graph2D graph) {
        if (graph == null) {
            GraphCanvasLocationService.b(21);
        }
        Rectangle rectangle = new Rectangle(0, 0, -1, -1);
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            graph.getRealizer(nodeCursor.node()).calcUnionRect(rectangle);
            nodeCursor.next();
        }
        Rectangle rectangle2 = rectangle;
        if (rectangle2 == null) {
            GraphCanvasLocationService.b(22);
        }
        return rectangle2;
    }

    @NotNull
    public Rectangle getBoundingBoxOfNodes(@NotNull Graph2D graph, @NotNull GraphLayout layout) {
        if (graph == null) {
            GraphCanvasLocationService.b(23);
        }
        if (layout == null) {
            GraphCanvasLocationService.b(24);
        }
        Rectangle rectangle = new Rectangle(0, 0, -1, -1);
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            GraphCanvasLocationService.b(rectangle, layout.getNodeLayout(nodeCursor.node()));
            nodeCursor.next();
        }
        Rectangle rectangle2 = rectangle;
        if (rectangle2 == null) {
            GraphCanvasLocationService.b(25);
        }
        return rectangle2;
    }

    private static void b(@NotNull Rectangle2D rectangle2D, @NotNull NodeLayout nodeLayout) {
        if (rectangle2D == null) {
            GraphCanvasLocationService.b(26);
        }
        if (nodeLayout == null) {
            GraphCanvasLocationService.b(27);
        }
        if (rectangle2D.getWidth() <= 0.0) {
            rectangle2D.setFrame(nodeLayout.getX(), nodeLayout.getY(), nodeLayout.getWidth(), nodeLayout.getHeight());
        } else {
            double d2 = Math.min(nodeLayout.getX(), rectangle2D.getX());
            double d3 = Math.max(nodeLayout.getX() + nodeLayout.getWidth(), rectangle2D.getX() + rectangle2D.getWidth());
            double d4 = Math.min(nodeLayout.getY(), rectangle2D.getY());
            double d5 = Math.max(nodeLayout.getY() + nodeLayout.getHeight(), rectangle2D.getY() + rectangle2D.getHeight());
            rectangle2D.setFrame(d2, d4, d3 - d2, d5 - d4);
        }
    }

    private static /* synthetic */ void b(int n10) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n10) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 24, 26, 27 -> 3;
        }];
        switch (n10) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/services/GraphCanvasLocationService";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/services/GraphCanvasLocationService";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestPositionForNode";
                break;
            }
            case 22: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoundingBoxOfNodes";
                break;
            }
        }
        switch (n10) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNodeCoordinatesOnScreen";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNodeCoordinatesOnCanvas";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNodeBoundsOnCanvas";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getGraphCenterOnScreen";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getGraphCenterOnCanvas";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBestPositionForNode";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showPopupBeneathNode";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showPopupInTopCenterOfViewport";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showInGraphCenter";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setBestPopupSizeForGraph";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "calcGraphSize";
                break;
            }
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getBoundingBoxOfNodes";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "calcUnionRect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n10) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 24, 26, 27 -> new IllegalArgumentException(string);
        };
    }
}

