/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.view;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.EdgeCreationPolicy;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.view.CreateEdgeMode;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseGraphEdgeCreationMode<N, E>
extends CreateEdgeMode {
    @NotNull
    private static final Logger LOG = Logger.getInstance(BaseGraphEdgeCreationMode.class);
    @Nullable
    private final EdgeCreationPolicy<? super N> myPolicy;
    @NotNull
    private final GraphBuilder<N, E> myBuilder;

    public BaseGraphEdgeCreationMode(@Nullable EdgeCreationPolicy<? super N> policy, @NotNull GraphBuilder<N, E> builder) {
        if (builder == null) {
            BaseGraphEdgeCreationMode.b(0);
        }
        this.myPolicy = policy;
        this.myBuilder = builder;
    }

    @Override
    @Nullable
    public Edge createEdge(Graph2D graph2D, Node from, Node to, EdgeRealizer edgeRealizer) {
        N n10 = this.myBuilder.getNodeObject(from);
        N n11 = this.myBuilder.getNodeObject(to);
        if (n10 != null && n11 != null) {
            try {
                this.myBuilder.getGraphDataModel().createEdge(n10, n11);
            }
            catch (Exception exception) {
                LOG.error((Throwable)exception);
            }
        }
        return null;
    }

    @Override
    public boolean acceptSourceNode(Node source, double x2, double y10) {
        if (this.myPolicy == null) {
            return true;
        }
        N n10 = this.myBuilder.getNodeObject(source);
        return n10 != null && this.myPolicy.acceptSource(n10);
    }

    @Override
    public void targetNodeDeclined(Node target, double x2, double y10) {
    }

    @Override
    public boolean acceptTargetNode(Node target, double x2, double y10) {
        if (this.myPolicy == null) {
            return true;
        }
        N n10 = this.myBuilder.getNodeObject(target);
        return n10 != null && this.myPolicy.acceptTarget(n10);
    }

    @Override
    public void sourceNodeDeclined(Node target, double x2, double y10) {
        this.cancelEdgeCreation();
    }

    private static /* synthetic */ void b(int n10) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/graph/view/BaseGraphEdgeCreationMode", "<init>"));
    }
}

