/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.view;

import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.view.MoveSelectionMode;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.util.EventDispatcher;
import org.jetbrains.annotations.NotNull;

public class BaseGraphMoveSelectionMode
extends MoveSelectionMode {
    private boolean myNodesMovedFlag;
    @NotNull
    private final GraphBuilder<?, ?> myBuilder;
    @NotNull
    private final EventDispatcher<GraphBuilderListener> myDispatcher;

    BaseGraphMoveSelectionMode(@NotNull GraphBuilder<?, ?> builder, @NotNull EventDispatcher<GraphBuilderListener> dispatcher) {
        if (builder == null) {
            BaseGraphMoveSelectionMode.b(0);
        }
        if (dispatcher == null) {
            BaseGraphMoveSelectionMode.b(1);
        }
        this.myBuilder = builder;
        this.myDispatcher = dispatcher;
    }

    @Override
    public void mousePressedLeft(double x2, double y10) {
        HierarchyManager hierarchyManager = HierarchyManager.Statics.getInstance(this.getGraph2D());
        NodeCursor nodeCursor = this.getNodesToBeMoved().nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            hierarchyManager.moveToLast(node);
            nodeCursor.next();
        }
        super.mousePressedLeft(x2, y10);
    }

    @Override
    public void mouseDraggedLeft(double x2, double y10) {
        super.mouseDraggedLeft(x2, y10);
        if (this.isActive() && !this.myNodesMovedFlag) {
            this.myNodesMovedFlag = true;
            ((GraphBuilderListener)this.myDispatcher.getMulticaster()).beforeActionPerformed(this.myBuilder, GraphBuilderEvent.NODES_MOVED);
        }
    }

    @Override
    public void mouseReleasedLeft(double x2, double y10) {
        super.mouseReleasedLeft(x2, y10);
        if (this.myNodesMovedFlag) {
            this.myNodesMovedFlag = false;
            ((GraphBuilderListener)this.myDispatcher.getMulticaster()).actionPerformed(this.myBuilder, GraphBuilderEvent.NODES_MOVED);
        }
    }

    private static /* synthetic */ void b(int n10) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n10) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dispatcher";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/graph/view/BaseGraphMoveSelectionMode";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

