/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.view.focusview;

import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphIdentifiable;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.ModelViewManager;
import com.intellij.openapi.graph.view.focusview.BaseGraphFocusView;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class GraphFocusOnNodesView<N, E>
extends BaseGraphFocusView<N, E> {
    @NotNull
    private final Set<GraphIdentifiable.Node.Identity> myFocusNodes;
    @NotNull
    private final Consumer<? super GraphSettings> myViewSettingsCustomizer;

    public GraphFocusOnNodesView(@NotNull Set<GraphIdentifiable.Node.Identity> nodes, @NotNull Consumer<? super GraphSettings> customizer) {
        if (nodes == null) {
            GraphFocusOnNodesView.J(0);
        }
        if (customizer == null) {
            GraphFocusOnNodesView.J(1);
        }
        this.myFocusNodes = nodes;
        this.myViewSettingsCustomizer = customizer;
    }

    @Override
    @NotNull
    protected Graph2D createFocusGraph(@NotNull GraphBuilder<N, E> modelBuilder) {
        if (modelBuilder == null) {
            GraphFocusOnNodesView.J(2);
        }
        Graph2D graph2D = modelBuilder.getGraph();
        FocusOnNodesFilter focusOnNodesFilter = new FocusOnNodesFilter(modelBuilder);
        Graph2D graph2D2 = (Graph2D)this.getFocusViewManager().createViewGraph(graph2D.getGraphCopyFactory(), focusOnNodesFilter, false, false);
        if (graph2D2 == null) {
            GraphFocusOnNodesView.J(3);
        }
        return graph2D2;
    }

    @Override
    protected void customizeViewSettings(@NotNull Graph2DView view, @NotNull EditMode editMode, @NotNull GraphSettings viewSettings, @NotNull GraphBuilder<N, E> modelBuilder) {
        if (view == null) {
            GraphFocusOnNodesView.J(4);
        }
        if (editMode == null) {
            GraphFocusOnNodesView.J(5);
        }
        if (viewSettings == null) {
            GraphFocusOnNodesView.J(6);
        }
        if (modelBuilder == null) {
            GraphFocusOnNodesView.J(7);
        }
        this.myViewSettingsCustomizer.accept(viewSettings);
    }

    private static /* synthetic */ void J(int n10) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n10) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n10) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customizer";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/view/focusview/GraphFocusOnNodesView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editMode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/view/focusview/GraphFocusOnNodesView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFocusGraph";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFocusGraph";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "customizeViewSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n10) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private final class FocusOnNodesFilter
    implements ModelViewManager.Filter {
        @NotNull
        private final GraphBuilder<N, E> myModelBuilder;

        private FocusOnNodesFilter(GraphBuilder<N, E> builder) {
            if (builder == null) {
                FocusOnNodesFilter.b(0);
            }
            this.myModelBuilder = builder;
        }

        @Override
        public boolean acceptInsertion(@NotNull Node node) {
            if (node == null) {
                FocusOnNodesFilter.b(1);
            }
            return this.acceptRetention(node);
        }

        @Override
        public boolean acceptInsertion(@NotNull Edge edge) {
            if (edge == null) {
                FocusOnNodesFilter.b(2);
            }
            return this.acceptRetention(edge);
        }

        @Override
        public boolean acceptRemoval(@NotNull Node node) {
            if (node == null) {
                FocusOnNodesFilter.b(3);
            }
            return !this.acceptRetention(node);
        }

        @Override
        public boolean acceptRemoval(@NotNull Edge edge) {
            if (edge == null) {
                FocusOnNodesFilter.b(4);
            }
            return !this.acceptRetention(edge);
        }

        @Override
        public boolean acceptRetention(@NotNull Node node) {
            if (node == null) {
                FocusOnNodesFilter.b(5);
            }
            return GraphFocusOnNodesView.this.myFocusNodes.contains(this.myModelBuilder.getNodeIdentity(node));
        }

        @Override
        public boolean acceptRetention(@NotNull Edge edge) {
            if (edge == null) {
                FocusOnNodesFilter.b(6);
            }
            return this.acceptRetention(edge.source()) && this.acceptRetention(edge.target());
        }

        private static /* synthetic */ void b(int n10) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n10) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "edge";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/graph/view/focusview/GraphFocusOnNodesView$FocusOnNodesFilter";
            switch (n10) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptInsertion";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptRemoval";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptRetention";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

