/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.api.customization;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.platform.lsp.api.customization.LspSemanticTokensCustomizer;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/lsp/api/customization/LspSemanticTokensSupport;", "Lcom/intellij/platform/lsp/api/customization/LspSemanticTokensCustomizer;", "LspSemanticTokensSupport", "()V", "shouldAskServerForSemanticTokens", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "tokenTypes", "", "", "getTokenTypes", "()Ljava/util/List;", "tokenModifiers", "getTokenModifiers", "getTextAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "tokenType", "modifiers", "intellij.platform.lsp"})
@SourceDebugExtension(value={"SMAP\nLspSemanticTokensCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspSemanticTokensCustomizer.kt\ncom/intellij/platform/lsp/api/customization/LspSemanticTokensSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1#2:127\n*E\n"})
public non-sealed class LspSemanticTokensSupport
extends LspSemanticTokensCustomizer {
    @NotNull
    private final List<String> tokenTypes;
    @NotNull
    private final List<String> tokenModifiers;

    public LspSemanticTokensSupport() {
        super(null);
        Object[] objectArray = new String[]{"namespace", "type", "class", "enum", "interface", "struct", "typeParameter", "parameter", "variable", "property", "enumMember", "event", "function", "method", "macro", "keyword", "modifier", "comment", "string", "number", "regexp", "operator", "decorator"};
        this.tokenTypes = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"declaration", "definition", "readonly", "static", "deprecated", "abstract", "async", "modification", "documentation", "defaultLibrary"};
        this.tokenModifiers = CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean shouldAskServerForSemanticTokens(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        String string = psiFile.getLanguage().getID();
        boolean bl2 = false;
        return Intrinsics.areEqual((Object)string, (Object)"TEXT") || Intrinsics.areEqual((Object)string, (Object)"textmate");
    }

    @NotNull
    public List<String> getTokenTypes() {
        return this.tokenTypes;
    }

    @NotNull
    public List<String> getTokenModifiers() {
        return this.tokenModifiers;
    }

    @Nullable
    public TextAttributesKey getTextAttributesKey(@NotNull String tokenType, @NotNull List<String> modifiers) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
        return switch (tokenType) {
            case "namespace" -> DefaultLanguageHighlighterColors.IDENTIFIER;
            case "type" -> DefaultLanguageHighlighterColors.IDENTIFIER;
            case "class" -> DefaultLanguageHighlighterColors.CLASS_NAME;
            case "enum" -> DefaultLanguageHighlighterColors.CLASS_NAME;
            case "interface" -> DefaultLanguageHighlighterColors.INTERFACE_NAME;
            case "struct" -> DefaultLanguageHighlighterColors.IDENTIFIER;
            case "typeParameter" -> DefaultLanguageHighlighterColors.IDENTIFIER;
            case "parameter" -> DefaultLanguageHighlighterColors.PARAMETER;
            case "variable" -> DefaultLanguageHighlighterColors.LOCAL_VARIABLE;
            case "property" -> {
                if (modifiers.contains("static")) {
                    yield DefaultLanguageHighlighterColors.STATIC_FIELD;
                }
                yield DefaultLanguageHighlighterColors.INSTANCE_FIELD;
            }
            case "enumMember" -> {
                if (modifiers.contains("static")) {
                    yield DefaultLanguageHighlighterColors.STATIC_FIELD;
                }
                yield DefaultLanguageHighlighterColors.INSTANCE_FIELD;
            }
            case "event" -> DefaultLanguageHighlighterColors.IDENTIFIER;
            case "function" -> DefaultLanguageHighlighterColors.FUNCTION_DECLARATION;
            case "method" -> {
                if (modifiers.contains("static")) {
                    yield DefaultLanguageHighlighterColors.STATIC_METHOD;
                }
                yield DefaultLanguageHighlighterColors.INSTANCE_METHOD;
            }
            case "macro" -> DefaultLanguageHighlighterColors.IDENTIFIER;
            case "keyword" -> DefaultLanguageHighlighterColors.KEYWORD;
            case "modifier" -> HighlighterColors.TEXT;
            case "comment" -> DefaultLanguageHighlighterColors.LINE_COMMENT;
            case "string" -> DefaultLanguageHighlighterColors.STRING;
            case "number" -> DefaultLanguageHighlighterColors.NUMBER;
            case "regexp" -> HighlighterColors.TEXT;
            case "operator" -> DefaultLanguageHighlighterColors.OPERATION_SIGN;
            case "decorator" -> HighlighterColors.TEXT;
            default -> null;
        };
    }
}

