/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonUtil {
    private JsonUtil() {
    }

    @Nullable
    public static JsonObject tryParseJsonObject(@Nullable String content) {
        return JsonUtil.tryParseJsonObject(content, true);
    }

    @Nullable
    public static JsonObject tryParseJsonObject(@Nullable String content, boolean lenient) {
        try {
            return JsonUtil.parseJsonObject(content, lenient);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @NotNull
    public static JsonObject parseJsonObject(@Nullable String content) throws JsonIOException, JsonSyntaxException, IllegalStateException {
        return JsonUtil.parseJsonObject(content, true);
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static JsonObject parseJsonObject(@Nullable String content, boolean lenient) throws JsonIOException, JsonSyntaxException, IllegalStateException {
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(StringUtil.notNullize((String)content)));
        jsonReader.setLenient(lenient);
        JsonElement jsonElement = new JsonParser().parse(jsonReader);
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        jsonReader.close();
        JsonObject jsonObject2 = jsonObject;
        if (jsonObject2 == null) {
            JsonUtil.b(0);
        }
        return jsonObject2;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new JsonIOException((Throwable)iOException);
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static JsonArray parseJsonArray(@Nullable String content) throws JsonParseException {
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(StringUtil.notNullize((String)content)));
        JsonElement jsonElement = new JsonParser().parse(jsonReader);
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        jsonReader.close();
        JsonArray jsonArray2 = jsonArray;
        if (jsonArray2 == null) {
            JsonUtil.b(1);
        }
        return jsonArray2;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new JsonIOException((Throwable)iOException);
                }
            }
        }
    }

    @NotNull
    public static List<Object> nextList(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            JsonUtil.b(2);
        }
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            List<Object> list = Collections.emptyList();
            if (list == null) {
                JsonUtil.b(3);
            }
            return list;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        while (reader.hasNext()) {
            arrayList.add(JsonUtil.nextAny(reader));
        }
        reader.endArray();
        ArrayList<Object> arrayList2 = arrayList;
        if (arrayList2 == null) {
            JsonUtil.b(4);
        }
        return arrayList2;
    }

    @NotNull
    public static List<String> nextStringList(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            JsonUtil.b(5);
        }
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            List<String> list = Collections.emptyList();
            if (list == null) {
                JsonUtil.b(6);
            }
            return list;
        }
        ArrayList<String> arrayList = new ArrayList<String>(2);
        while (reader.hasNext()) {
            String string = JsonUtil.nextStringOrSkip(reader);
            if (string == null) continue;
            arrayList.add(string);
        }
        reader.endArray();
        ArrayList<String> arrayList2 = arrayList;
        if (arrayList2 == null) {
            JsonUtil.b(7);
        }
        return arrayList2;
    }

    @NotNull
    public static Map<String, Object> nextMap(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            JsonUtil.b(8);
        }
        reader.beginObject();
        if (!reader.hasNext()) {
            reader.endObject();
            Map<String, Object> map = Collections.emptyMap();
            if (map == null) {
                JsonUtil.b(9);
            }
            return map;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        while (reader.hasNext()) {
            hashMap.put(reader.nextName(), JsonUtil.nextAny(reader));
        }
        reader.endObject();
        HashMap<String, Object> hashMap2 = hashMap;
        if (hashMap2 == null) {
            JsonUtil.b(10);
        }
        return hashMap2;
    }

    @Nullable
    public static String nextStringOrSkip(@NotNull JsonReader reader) throws IOException {
        JsonToken jsonToken;
        if (reader == null) {
            JsonUtil.b(11);
        }
        if ((jsonToken = reader.peek()) == JsonToken.STRING) {
            return reader.nextString();
        }
        reader.skipValue();
        return null;
    }

    @Nullable
    public static Object nextAny(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            JsonUtil.b(12);
        }
        return switch (reader.peek()) {
            case JsonToken.BEGIN_ARRAY -> JsonUtil.nextList(reader);
            case JsonToken.BEGIN_OBJECT -> JsonUtil.nextMap(reader);
            case JsonToken.STRING -> reader.nextString();
            case JsonToken.NUMBER -> reader.nextDouble();
            case JsonToken.BOOLEAN -> reader.nextBoolean();
            case JsonToken.NULL -> {
                reader.nextNull();
                yield null;
            }
            default -> throw new IllegalStateException();
        };
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static String getString(@NotNull JsonObject object, @NotNull String key) {
        if (object == null) {
            JsonUtil.b(13);
        }
        if (key == null) {
            JsonUtil.b(14);
        }
        return JsonUtil.getChildAsString(object, key);
    }

    @Nullable
    public static String getChildAsString(@Nullable JsonObject object, @NotNull String key) {
        if (key == null) {
            JsonUtil.b(15);
        }
        JsonElement jsonElement = object != null ? object.get(key) : null;
        return JsonUtil.getString(jsonElement);
    }

    @Nullable
    public static JsonArray getChildAsArray(@Nullable JsonObject object, @NotNull String memberName) {
        JsonElement jsonElement;
        if (memberName == null) {
            JsonUtil.b(16);
        }
        JsonElement jsonElement2 = jsonElement = object != null ? object.get(memberName) : null;
        if (jsonElement != null && jsonElement.isJsonArray()) {
            return jsonElement.getAsJsonArray();
        }
        return null;
    }

    @Nullable
    public static List<String> getChildAsStringList(@Nullable JsonObject object, @NotNull String memberName) {
        if (memberName == null) {
            JsonUtil.b(17);
        }
        JsonElement jsonElement = object != null ? object.get(memberName) : null;
        return JsonUtil.getAsStringList(jsonElement);
    }

    @Nullable
    public static List<String> getAsStringList(@Nullable JsonElement element) {
        if (element != null && element.isJsonArray()) {
            return JsonUtil.arrayToStringList(element.getAsJsonArray());
        }
        return null;
    }

    @NotNull
    public static List<String> arrayToStringList(@NotNull JsonArray array) {
        if (array == null) {
            JsonUtil.b(18);
        }
        List list = ContainerUtil.mapNotNull((Iterable)array, JsonUtil::getString);
        if (list == null) {
            JsonUtil.b(19);
        }
        return list;
    }

    @Nullable
    public static JsonObject getChildAsObject(@Nullable JsonObject object, @NotNull String memberName) {
        if (memberName == null) {
            JsonUtil.b(20);
        }
        return JsonUtil.getAsObject(object != null ? object.get(memberName) : null);
    }

    @Nullable
    public static JsonObject getAsObject(@Nullable JsonElement value) {
        return value != null && value.isJsonObject() ? value.getAsJsonObject() : null;
    }

    @Nullable
    public static JsonElement findChild(@Nullable JsonObject object, String ... names) {
        if (object == null) {
            return null;
        }
        for (String string : names) {
            JsonElement jsonElement = object.get(string);
            if (jsonElement == null) continue;
            return jsonElement;
        }
        return null;
    }

    @NotNull
    public static List<String> keys(@NotNull JsonObject jsonObject) {
        if (jsonObject == null) {
            JsonUtil.b(21);
        }
        List list = ContainerUtil.map((Collection)jsonObject.entrySet(), entry -> (String)entry.getKey());
        if (list == null) {
            JsonUtil.b(22);
        }
        return list;
    }

    @Nullable
    public static Boolean getChildAsBooleanObj(@Nullable JsonObject object, @NotNull String memberName) {
        if (memberName == null) {
            JsonUtil.b(23);
        }
        return JsonUtil.getBoolean(object != null ? object.get(memberName) : null);
    }

    @Nullable
    public static Boolean getBoolean(@Nullable JsonElement element) {
        JsonPrimitive jsonPrimitive;
        if (element != null && element.isJsonPrimitive() && (jsonPrimitive = element.getAsJsonPrimitive()).isBoolean()) {
            return jsonPrimitive.getAsBoolean();
        }
        return null;
    }

    public static boolean getChildAsBoolean(@Nullable JsonObject object, @NotNull String memberName, boolean defaultValue) {
        if (memberName == null) {
            JsonUtil.b(24);
        }
        return (Boolean)ObjectUtils.notNull((Object)JsonUtil.getChildAsBooleanObj(object, memberName), (Object)defaultValue);
    }

    @Nullable
    public static String getString(@Nullable JsonElement element) {
        JsonPrimitive jsonPrimitive;
        if (element != null && element.isJsonPrimitive() && (jsonPrimitive = element.getAsJsonPrimitive()).isString()) {
            return jsonPrimitive.getAsString();
        }
        return null;
    }

    @Nullable
    public static String getChildAsString(@NotNull JsonReader reader, @NotNull String memberName) throws IOException {
        if (reader == null) {
            JsonUtil.b(25);
        }
        if (memberName == null) {
            JsonUtil.b(26);
        }
        return JsonUtil.getChildAsString(reader, memberName, null);
    }

    @NotNull
    public static Map<String, String> getTopLevelStringValues(@NotNull JsonReader reader, @NotNull Set<String> names) throws IOException {
        JsonToken jsonToken;
        if (reader == null) {
            JsonUtil.b(27);
        }
        if (names == null) {
            JsonUtil.b(28);
        }
        if ((jsonToken = reader.peek()) != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                JsonUtil.b(29);
            }
            return map;
        }
        reader.beginObject();
        HashMap<String, String> hashMap = new HashMap<String, String>(names.size(), 1.0f);
        while (reader.hasNext()) {
            String string = reader.nextName();
            if (names.contains(string)) {
                String string2 = JsonUtil.nextStringOrSkip(reader);
                if (string2 == null) continue;
                hashMap.put(string, string2);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        HashMap<String, String> hashMap2 = hashMap;
        if (hashMap2 == null) {
            JsonUtil.b(30);
        }
        return hashMap2;
    }

    @Nullable
    public static String getChildAsString(@NotNull JsonReader reader, @NotNull String memberName, @Nullable String failoverMemberName) throws IOException {
        if (reader == null) {
            JsonUtil.b(31);
        }
        if (memberName == null) {
            JsonUtil.b(32);
        }
        Set<String> set = failoverMemberName == null ? Collections.singleton(memberName) : Set.of(memberName, failoverMemberName);
        Map<String, String> map = JsonUtil.getTopLevelStringValues(reader, set);
        String string = map.get(memberName);
        return string != null ? string : map.get(failoverMemberName);
    }

    public static int getChildAsInteger(@Nullable JsonObject object, @NotNull String key, int defaultValue) {
        Integer n10;
        if (key == null) {
            JsonUtil.b(33);
        }
        return (n10 = JsonUtil.getChildAsIntegerObj(object, key)) != null ? n10 : defaultValue;
    }

    @Nullable
    public static Integer getChildAsIntegerObj(@Nullable JsonObject object, @NotNull String key) {
        JsonElement jsonElement;
        if (key == null) {
            JsonUtil.b(34);
        }
        JsonElement jsonElement2 = jsonElement = object != null ? object.get(key) : null;
        if (jsonElement instanceof JsonPrimitive && ((JsonPrimitive)jsonElement).isNumber()) {
            return jsonElement.getAsInt();
        }
        return null;
    }

    private static /* synthetic */ void b(int n10) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n10) {
            default -> 2;
            case 2, 5, 8, 11, 12, 13, 14, 15, 16, 17, 18, 20, 21, 23, 24, 25, 26, 27, 28, 31, 32, 33, 34 -> 3;
        }];
        switch (n10) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/util/JsonUtil";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 25: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 14: 
            case 15: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonObject";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseJsonObject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseJsonArray";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/util/JsonUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "nextList";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "nextStringList";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "nextMap";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayToStringList";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "keys";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelStringValues";
                break;
            }
        }
        switch (n10) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "nextList";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "nextStringList";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "nextMap";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "nextStringOrSkip";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "nextAny";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
            case 15: 
            case 25: 
            case 26: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsString";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsArray";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsStringList";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "arrayToStringList";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsObject";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "keys";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsBooleanObj";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsBoolean";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelStringValues";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsInteger";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsIntegerObj";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n10) {
            default -> new IllegalStateException(string);
            case 2, 5, 8, 11, 12, 13, 14, 15, 16, 17, 18, 20, 21, 23, 24, 25, 26, 27, 28, 31, 32, 33, 34 -> new IllegalArgumentException(string);
        };
    }
}

