/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.languagescope.common;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.clones.configuration.DuplicatesBundle;
import com.jetbrains.clones.structures.TextClone;
import com.jetbrains.clones.toolwindow.DuplicateViewManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/clones/languagescope/common/ShowDuplicatesLikeThisFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "textClone", "Lcom/jetbrains/clones/structures/TextClone;", "ShowDuplicatesLikeThisFix", "(Lcom/jetbrains/clones/structures/TextClone;)V", "version", "", "Ljava/lang/Long;", "b", "", "getName", "", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "startInWriteAction", "intellij.platform.duplicatesDetector"})
public final class ShowDuplicatesLikeThisFix
implements LocalQuickFix {
    @NotNull
    private final TextClone textClone;
    @Nullable
    private final Long version;

    public ShowDuplicatesLikeThisFix(@NotNull TextClone textClone) {
        Intrinsics.checkNotNullParameter((Object)textClone, (String)"textClone");
        this.textClone = textClone;
        Document document = FileDocumentManager.getInstance().getDocument(this.textClone.getMain().getFile());
        this.version = document != null ? Long.valueOf(document.getModificationStamp()) : null;
    }

    private final boolean b() {
        Document document = FileDocumentManager.getInstance().getDocument(this.textClone.getMain().getFile());
        return Intrinsics.areEqual((Object)(document != null ? Long.valueOf(document.getModificationStamp()) : null), (Object)this.version);
    }

    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{this.textClone.getDuplicates().size() + 1};
        return DuplicatesBundle.INSTANCE.message("duplicate.inspection.fix.name", objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return DuplicatesBundle.INSTANCE.message("duplicate.inspection.fix.family", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.b()) {
            DuplicateViewManager.Companion.getInstance(project).showClonesData(this.textClone);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

