/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.structures;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\f\u001a\u00020\rH\u0096\u0080\u0004J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0018\u001a\u00020\u0019H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/clones/structures/TextFragment;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "TextFragment", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/util/TextRange;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "toString", "", "lines", "Lkotlin/ranges/IntRange;", "getLines", "()Lkotlin/ranges/IntRange;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "intellij.platform.duplicatesDetector"})
public final class TextFragment {
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final TextRange range;

    public TextFragment(@NotNull VirtualFile file, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.file = file;
        this.range = range;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final TextRange getRange() {
        return this.range;
    }

    @NotNull
    public String toString() {
        return this.file.getName() + " " + this.range;
    }

    @NotNull
    public final IntRange getLines() {
        Document document = FileDocumentManager.getInstance().getDocument(this.file);
        if (document == null) {
            throw new IllegalStateException("Document " + this.file.getPresentableName() + " not found.");
        }
        Document document2 = document;
        int n10 = document2.getLineNumber(this.range.getStartOffset()) + 1;
        int n11 = document2.getLineNumber(this.range.getEndOffset()) + 1;
        return new IntRange(n10, n11);
    }

    @NotNull
    public final VirtualFile component1() {
        return this.file;
    }

    @NotNull
    public final TextRange component2() {
        return this.range;
    }

    @NotNull
    public final TextFragment copy(@NotNull VirtualFile file, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return new TextFragment(file, range);
    }

    public static /* synthetic */ TextFragment copy$default(TextFragment textFragment, VirtualFile virtualFile, TextRange textRange, int n10, Object object) {
        if ((n10 & 1) != 0) {
            virtualFile = textFragment.file;
        }
        if ((n10 & 2) != 0) {
            textRange = textFragment.range;
        }
        return textFragment.copy(virtualFile, textRange);
    }

    public int hashCode() {
        int n10 = this.file.hashCode();
        n10 = n10 * 31 + this.range.hashCode();
        return n10;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextFragment)) {
            return false;
        }
        TextFragment textFragment = (TextFragment)other;
        if (!Intrinsics.areEqual((Object)this.file, (Object)textFragment.file)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.range, (Object)textFragment.range);
    }
}

