/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.google.gson.JsonObject;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.linter.ServiceInactivityTracker;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceInitialState;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.PrettierBundle;
import com.intellij.prettierjs.PrettierConfig;
import com.intellij.prettierjs.PrettierError;
import com.intellij.prettierjs.PrettierLanguageService;
import com.intellij.prettierjs.PrettierLanguageServiceManager;
import com.intellij.prettierjs.PrettierUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.JsonUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0003:;<B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J<\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J \u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016Jl\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H!0\u0014\"\u0004\b\u0000\u0010!2\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H!0#23\u0010$\u001a/\b\u0001\u0012\u0013\u0012\u00110&\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b()\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001H!0*\u0012\u0006\u0012\u0004\u0018\u00010+0%H\u0002\u00a2\u0006\u0002\u0010,J\u0012\u0010-\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010.\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u001bH\u0002J\u0018\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\u001f2\u0006\u00101\u001a\u000202H\u0002J\u0012\u00106\u001a\u00020\u00122\b\u00107\u001a\u0004\u0018\u00010\fH\u0002J\u000e\u00108\u001a\u00020&H\u0094@\u00a2\u0006\u0002\u00109R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006="}, d2={"Lcom/intellij/prettierjs/PrettierLanguageServiceImpl;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceBase;", "Lcom/intellij/prettierjs/PrettierLanguageService;", "project", "Lcom/intellij/openapi/project/Project;", "workDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "inactivityTracker", "Lcom/intellij/lang/javascript/linter/ServiceInactivityTracker;", "error", "Lcom/intellij/prettierjs/PrettierError;", "getError", "()Lcom/intellij/prettierjs/PrettierError;", "setError", "(Lcom/intellij/prettierjs/PrettierError;)V", "dispose", "", "format", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/prettierjs/PrettierLanguageService$FormatResult;", "filePath", "", "ignoreFilePath", "text", "prettierPackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "range", "Lcom/intellij/openapi/util/TextRange;", "resolveConfig", "Lcom/intellij/prettierjs/PrettierLanguageService$ResolveConfigResult;", "withServiceAndEnv", "R", "errorResult", "Lkotlin/Function1;", "body", "Lkotlin/Function2;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue;", "Lkotlin/ParameterName;", "name", "process", "Lkotlin/coroutines/Continuation;", "", "(Lcom/intellij/javascript/nodejs/util/NodePackage;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)Ljava/util/concurrent/CompletableFuture;", "checkEnvAndSetError", "checkNodeAndPackage", "nodePackage", "parseReformatResponse", "response", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceAnswer;", "forceLineBreakAtEof", "", "parseResolveConfigResponse", "updateError", "newError", "createLanguageServiceQueue", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Protocol", "ReformatFileCommand", "ResolveConfigCommand", "intellij.prettierJS"})
public final class PrettierLanguageServiceImpl
extends JSLanguageServiceBase
implements PrettierLanguageService {
    @NotNull
    private final VirtualFile workDir;
    @NotNull
    private final ServiceInactivityTracker inactivityTracker;
    @Nullable
    private volatile PrettierError error;

    public PrettierLanguageServiceImpl(@NotNull Project project, @NotNull VirtualFile workDir) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)workDir, (String)"workDir");
        super(project);
        this.workDir = workDir;
        PrettierLanguageServiceManager manager = PrettierLanguageServiceManager.Companion.getInstance(project);
        this.inactivityTracker = ServiceInactivityTracker.Companion.startTracking(manager.getCs$intellij_prettierJS(), manager.getInactivityTimeoutMs(), () -> PrettierLanguageServiceImpl._init_$lambda$0(project, this));
    }

    @Nullable
    public final PrettierError getError() {
        return this.error;
    }

    public final void setError(@Nullable PrettierError prettierError) {
        this.error = prettierError;
    }

    public void dispose() {
        this.inactivityTracker.stopTracking();
        this.updateError(null);
        super.dispose();
    }

    @Override
    @NotNull
    public CompletableFuture<PrettierLanguageService.FormatResult> format(@NotNull String filePath, @Nullable String ignoreFilePath, @NotNull String text, @NotNull NodePackage prettierPackage, @Nullable TextRange range) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)prettierPackage, (String)"prettierPackage");
        boolean forceLineBreakAtEof = range != null && range.getEndOffset() < text.length() && StringsKt.endsWith$default((String)text, (String)"\n", (boolean)false, (int)2, null);
        return this.withServiceAndEnv(prettierPackage, PrettierLanguageServiceImpl::format$lambda$0, (Function2)new Function2<JSLanguageServiceQueue, Continuation<? super PrettierLanguageService.FormatResult>, Object>(this, filePath, prettierPackage, ignoreFilePath, text, range, forceLineBreakAtEof, null){
            Object L$1;
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ PrettierLanguageServiceImpl this$0;
            final /* synthetic */ String $filePath;
            final /* synthetic */ NodePackage $prettierPackage;
            final /* synthetic */ String $ignoreFilePath;
            final /* synthetic */ String $text;
            final /* synthetic */ TextRange $range;
            final /* synthetic */ boolean $forceLineBreakAtEof;
            {
                this.this$0 = $receiver;
                this.$filePath = $filePath;
                this.$prettierPackage = $prettierPackage;
                this.$ignoreFilePath = $ignoreFilePath;
                this.$text = $text;
                this.$range = $range;
                this.$forceLineBreakAtEof = $forceLineBreakAtEof;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (JSLanguageServiceQueue)this.L$0;
                var8_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        command = new ReformatFileCommand(this.this$0.getProject(), this.$filePath, this.$prettierPackage, this.$ignoreFilePath, this.$text, this.$range, false, -1);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)process);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)command);
                        this.label = 1;
                        v0 = process.execute((JSLanguageServiceCommand)command, (Continuation)this);
                        if (v0 == var8_3) {
                            return var8_3;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        command = (ReformatFileCommand)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        if ((v1 = (JSLanguageServiceQueue.CommandResult)v0) == null || (v1 = v1.getAnswer()) == null) {
                            return null;
                        }
                        answer = v1;
                        res = PrettierLanguageServiceImpl.access$parseReformatResponse(this.this$0, (JSLanguageServiceAnswer)answer, this.$forceLineBreakAtEof);
                        if (res.error != null) {
                            v2 = new PrettierError.ShowDetails(res.error);
                        } else if (res.unsupported) {
                            var7_8 = new Object[]{PathUtilRt.getFileName((String)this.$filePath)};
                            v3 = PrettierBundle.message("not.supported.file", var7_8);
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"message(...)");
                            v2 = new PrettierError.Unsupported(v3);
                        } else {
                            v2 = null;
                        }
                        newError = v2;
                        PrettierLanguageServiceImpl.access$updateError(this.this$0, newError);
                        return res;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(JSLanguageServiceQueue p1, Continuation<? super PrettierLanguageService.FormatResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    @NotNull
    public CompletableFuture<PrettierLanguageService.ResolveConfigResult> resolveConfig(@NotNull String filePath, @NotNull NodePackage prettierPackage) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)prettierPackage, (String)"prettierPackage");
        String normalizedPath = JSLanguageServiceUtil.normalizeNameAndPath((String)filePath);
        return this.withServiceAndEnv(prettierPackage, PrettierLanguageServiceImpl::resolveConfig$lambda$0, (Function2)new Function2<JSLanguageServiceQueue, Continuation<? super PrettierLanguageService.ResolveConfigResult>, Object>(this, normalizedPath, prettierPackage, null){
            Object L$1;
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ PrettierLanguageServiceImpl this$0;
            final /* synthetic */ String $normalizedPath;
            final /* synthetic */ NodePackage $prettierPackage;
            {
                this.this$0 = $receiver;
                this.$normalizedPath = $normalizedPath;
                this.$prettierPackage = $prettierPackage;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (JSLanguageServiceQueue)this.L$0;
                var9_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = this.this$0.getProject();
                        var4_4 = this.$normalizedPath;
                        Intrinsics.checkNotNull((Object)var4_4);
                        command = new ResolveConfigCommand(v0, var4_4, this.$prettierPackage, false);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)process);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)command);
                        this.label = 1;
                        v1 = process.execute((JSLanguageServiceCommand)command, (Continuation)this);
                        if (v1 == var9_3) {
                            return var9_3;
                        }
                        ** GOTO lbl21
                    }
                    case 1: {
                        command = (ResolveConfigCommand)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        if ((v2 = (JSLanguageServiceQueue.CommandResult)v1) == null || (v2 = v2.getAnswer()) == null) {
                            return null;
                        }
                        response = v2;
                        res = PrettierLanguageServiceImpl.access$parseResolveConfigResponse(this.this$0, (JSLanguageServiceAnswer)response);
                        v3 = this.this$0;
                        v4 = res.error;
                        if (v4 != null) {
                            var6_8 = v4;
                            var8_9 = v3;
                            $i$a$-let-PrettierLanguageServiceImpl$resolveConfig$2$1 = false;
                            v5 = new PrettierError.ShowDetails((String)it);
                            v3 = var8_9;
                        } else {
                            v5 = null;
                        }
                        PrettierLanguageServiceImpl.access$updateError(v3, v5);
                        return res;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(JSLanguageServiceQueue p1, Continuation<? super PrettierLanguageService.ResolveConfigResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final <R> CompletableFuture<R> withServiceAndEnv(NodePackage prettierPackage, Function1<? super String, ? extends R> errorResult, Function2<? super JSLanguageServiceQueue, ? super Continuation<? super R>, ? extends Object> body) {
        PrettierError prettierError = this.checkEnvAndSetError(prettierPackage);
        if (prettierError != null) {
            PrettierError err = prettierError;
            boolean bl = false;
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(errorResult.invoke((Object)err.getMessage()));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        return (CompletableFuture)this.inactivityTracker.useService(() -> PrettierLanguageServiceImpl.withServiceAndEnv$lambda$1(this, errorResult, body));
    }

    private final PrettierError checkEnvAndSetError(NodePackage prettierPackage) {
        PrettierError err = this.checkNodeAndPackage(this.getProject(), prettierPackage);
        if (err != null) {
            this.updateError(err);
        }
        return err;
    }

    private final PrettierError checkNodeAndPackage(Project project, NodePackage nodePackage) {
        NodeJsInterpreter nodeJsInterpreter;
        NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.createProjectRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreterRef, (String)"createProjectRef(...)");
        NodeJsInterpreterRef interpreterRef = nodeJsInterpreterRef;
        try {
            nodeJsInterpreter = NodeInterpreterUtil.getValidInterpreterOrThrow((NodeJsInterpreter)interpreterRef.resolve(project));
        }
        catch (ExecutionException executionException) {
            return new PrettierError.NodeSettings(null, 1, null);
        }
        NodeJsInterpreter nodeJsInterpreter2 = nodeJsInterpreter;
        Intrinsics.checkNotNull((Object)nodeJsInterpreter2);
        NodeJsInterpreter nodeJsInterpreter3 = nodeJsInterpreter2;
        if (nodePackage.isEmptyPath()) {
            return new PrettierError.EditSettings(null, 1, null);
        }
        if (!nodePackage.isValid(project, nodeJsInterpreter3)) {
            return new PrettierError.InstallPackage(null, 1, null);
        }
        SemVer nodePackageVersion = nodePackage.getVersion(project);
        if (nodePackageVersion != null && nodePackageVersion.compareTo(PrettierUtil.MIN_VERSION) < 0) {
            Object[] objectArray = new Object[]{PrettierUtil.MIN_VERSION.getRawVersion()};
            String string = PrettierBundle.message("error.unsupported.version", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return new PrettierError.ShowDetails(string);
        }
        return null;
    }

    private final PrettierLanguageService.FormatResult parseReformatResponse(JSLanguageServiceAnswer response2, boolean forceLineBreakAtEof) {
        String error;
        JsonObject jsonObject = response2.getElement();
        String string = error = JsonUtil.getChildAsString((JsonObject)jsonObject, (String)"error");
        boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl) {
            return PrettierLanguageService.FormatResult.Companion.error(error);
        }
        if (JsonUtil.getChildAsBoolean((JsonObject)jsonObject, (String)"ignored", (boolean)false)) {
            return PrettierLanguageService.FormatResult.Companion.getIGNORED();
        }
        if (JsonUtil.getChildAsBoolean((JsonObject)jsonObject, (String)"unsupported", (boolean)false)) {
            return PrettierLanguageService.FormatResult.UNSUPPORTED;
        }
        String string2 = JsonUtil.getChildAsString((JsonObject)jsonObject, (String)"formatted");
        Intrinsics.checkNotNull((Object)string2);
        Object formattedResult = string2;
        int cursorOffset = JsonUtil.getChildAsInteger((JsonObject)jsonObject, (String)"cursorOffset", (int)-1);
        if (forceLineBreakAtEof && !StringsKt.endsWith$default((String)formattedResult, (String)"\n", (boolean)false, (int)2, null)) {
            formattedResult = (String)formattedResult + "\n";
        }
        return PrettierLanguageService.FormatResult.Companion.formatted((String)formattedResult, cursorOffset);
    }

    private final PrettierLanguageService.ResolveConfigResult parseResolveConfigResponse(JSLanguageServiceAnswer response2) {
        String error;
        JsonObject jsonObject = response2.getElement();
        String string = error = JsonUtil.getChildAsString((JsonObject)jsonObject, (String)"error");
        boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl) {
            return PrettierLanguageService.ResolveConfigResult.Companion.error(error);
        }
        JsonObject config = JsonUtil.getChildAsObject((JsonObject)jsonObject, (String)"config");
        PrettierConfig prettierConfig2 = PrettierConfig.createFromJson(config);
        Intrinsics.checkNotNull((Object)prettierConfig2);
        return PrettierLanguageService.ResolveConfigResult.Companion.config(prettierConfig2);
    }

    private final void updateError(PrettierError newError) {
        if (Intrinsics.areEqual((Object)this.error, (Object)newError)) {
            return;
        }
        this.error = newError;
        PrettierLanguageServiceManager.Companion.getInstance(this.myProject).jsLinterStateChanged();
    }

    @Nullable
    protected Object createLanguageServiceQueue(@NotNull Continuation<? super JSLanguageServiceQueue> $completion) {
        return new JSLanguageServiceQueueImpl(this.myProject, (JSLanguageServiceProtocol)new Protocol(this.myProject), null, (JSLanguageServiceQueue.ServiceInfoReporter)this.myDefaultReporter, false, 16, null);
    }

    private static final Unit _init_$lambda$0(Project $project, PrettierLanguageServiceImpl this$0) {
        PrettierLanguageServiceManager.Companion.getInstance($project).terminateInactiveService(this$0);
        return Unit.INSTANCE;
    }

    private static final PrettierLanguageService.FormatResult format$lambda$0(String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        return PrettierLanguageService.FormatResult.Companion.error(msg);
    }

    private static final PrettierLanguageService.ResolveConfigResult resolveConfig$lambda$0(String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        return PrettierLanguageService.ResolveConfigResult.Companion.error(msg);
    }

    private static final CompletableFuture withServiceAndEnv$lambda$1(PrettierLanguageServiceImpl this$0, Function1 $errorResult, Function2 $body) {
        return FutureKt.future$default((CoroutineScope)PrettierLanguageServiceManager.Companion.getInstance(this$0.getProject()).getCs$intellij_prettierJS(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super R>, Object>(this$0, $errorResult, $body, null){
            Object L$0;
            int label;
            final /* synthetic */ PrettierLanguageServiceImpl this$0;
            final /* synthetic */ Function1<String, R> $errorResult;
            final /* synthetic */ Function2<JSLanguageServiceQueue, Continuation<? super R>, Object> $body;
            {
                this.this$0 = $receiver;
                this.$errorResult = $errorResult;
                this.$body = $body;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = PrettierLanguageServiceImpl.access$getProcess(this.this$0, (Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((process = (JSLanguageServiceQueue)v0) == null || !process.isValid()) {
                            v1 = PrettierBundle.message("service.not.started.message", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"message(...)");
                            msg = v1;
                            PrettierLanguageServiceImpl.access$updateError(this.this$0, new PrettierError.ShowDetails(msg));
                            return this.$errorResult.invoke((Object)msg);
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)process);
                        this.label = 2;
                        v2 = this.$body.invoke((Object)process, (Object)this);
                        if (v2 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl29
                    }
                    case 2: {
                        process = (JSLanguageServiceQueue)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl29:
                        // 2 sources

                        return v2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super R> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, (int)3, null);
    }

    public static final /* synthetic */ PrettierLanguageService.FormatResult access$parseReformatResponse(PrettierLanguageServiceImpl $this, JSLanguageServiceAnswer response2, boolean forceLineBreakAtEof) {
        return $this.parseReformatResponse(response2, forceLineBreakAtEof);
    }

    public static final /* synthetic */ void access$updateError(PrettierLanguageServiceImpl $this, PrettierError newError) {
        $this.updateError(newError);
    }

    public static final /* synthetic */ PrettierLanguageService.ResolveConfigResult access$parseResolveConfigResponse(PrettierLanguageServiceImpl $this, JSLanguageServiceAnswer response2) {
        return $this.parseResolveConfigResponse(response2);
    }

    public static final /* synthetic */ Object access$getProcess(PrettierLanguageServiceImpl $this, Continuation $completion) {
        return $this.getProcess($completion);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0014R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/intellij/prettierjs/PrettierLanguageServiceImpl$Protocol;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/prettierjs/PrettierLanguageServiceImpl;Lcom/intellij/openapi/project/Project;)V", "addNodeProcessAdditionalArguments", "", "targetRun", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "workingDirectory", "", "getWorkingDirectory", "()Ljava/lang/String;", "needReadActionToCreateState", "", "createState", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceInitialState;", "getNodeCommandLineConfiguratorOptions", "Lcom/intellij/javascript/nodejs/interpreter/NodeCommandLineConfigurator$Options;", "intellij.prettierJS"})
    @SourceDebugExtension(value={"SMAP\nPrettierLanguageServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrettierLanguageServiceImpl.kt\ncom/intellij/prettierjs/PrettierLanguageServiceImpl$Protocol\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,275:1\n1#2:276\n23#3:277\n*S KotlinDebug\n*F\n+ 1 PrettierLanguageServiceImpl.kt\ncom/intellij/prettierjs/PrettierLanguageServiceImpl$Protocol\n*L\n218#1:277\n*E\n"})
    private final class Protocol
    extends JSLanguageServiceNodeStdProtocolBase {
        public Protocol(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super("prettier", project, null, 4, null);
        }

        protected void addNodeProcessAdditionalArguments(@NotNull NodeTargetRun targetRun) {
            Intrinsics.checkNotNullParameter((Object)targetRun, (String)"targetRun");
            super.addNodeProcessAdditionalArguments(targetRun);
            JSLanguageServiceUtil.addNodeProcessArgumentsFromRegistry((TargetedCommandLineBuilder)targetRun.getCommandLineBuilder(), (String)this.getServiceName(), Protocol::addNodeProcessAdditionalArguments$lambda$0);
            PrettierUtil.addExperimentalStripTypesIfNeeded(targetRun, this.getServiceName());
            Path path = PrettierUtil.getPrettierLanguageServicePath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPrettierLanguageServicePath(...)");
            targetRun.path(((Object)path.toAbsolutePath()).toString());
        }

        @Nullable
        protected String getWorkingDirectory() {
            VirtualFile virtualFile;
            Application application = ApplicationManager.getApplication();
            boolean bl = application != null ? application.isUnitTestMode() : false;
            if (bl && (virtualFile = ProjectUtil.guessProjectDir((Project)this.myProject)) != null) {
                VirtualFile it = virtualFile;
                boolean bl2 = false;
                return it.getPath();
            }
            return JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks((VirtualFile)PrettierLanguageServiceImpl.this.workDir);
        }

        protected boolean needReadActionToCreateState() {
            return false;
        }

        @NotNull
        protected JSLanguageServiceInitialState createState() {
            JSLanguageServiceInitialState jSLanguageServiceInitialState;
            Path service = PrettierUtil.getPrettierLanguageServicePath().resolve("prettier-plugin-provider.js");
            Intrinsics.checkNotNull((Object)service);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isRegularFile(service, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Protocol $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Protocol.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("prettier language service plugin not found");
            }
            JSLanguageServiceInitialState it = jSLanguageServiceInitialState = new JSLanguageServiceInitialState();
            boolean bl = false;
            it.pluginName = "prettier";
            it.pluginPath = LocalFilePath.Companion.createNotNull(((Object)service.toAbsolutePath()).toString());
            return jSLanguageServiceInitialState;
        }

        @NotNull
        protected NodeCommandLineConfigurator.Options getNodeCommandLineConfiguratorOptions(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            NodeCommandLineConfigurator.Options options = NodeCommandLineConfigurator.defaultOptions((Project)this.myProject);
            Intrinsics.checkNotNullExpressionValue((Object)options, (String)"defaultOptions(...)");
            return options;
        }

        private static final String addNodeProcessAdditionalArguments$lambda$0() {
            return Registry.Companion.stringValue("prettier.service.node.arguments");
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002BK\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010(\u001a\u00020\u0001H\u0016J\u0010\u0010+\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0016R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0013\u0010\u001f\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0013\u0010\t\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001cR\u0015\u0010\"\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\n\n\u0002\u0010%\u001a\u0004\b#\u0010$R\u0015\u0010&\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\n\n\u0002\u0010%\u001a\u0004\b'\u0010$R\u0014\u0010)\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0014\u00a8\u0006,"}, d2={"Lcom/intellij/prettierjs/PrettierLanguageServiceImpl$ReformatFileCommand;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceObject;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceSimpleCommand;", "project", "Lcom/intellij/openapi/project/Project;", "filePath", "", "prettierPackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "ignoreFilePath", "content", "range", "Lcom/intellij/openapi/util/TextRange;", "flushConfigCache", "", "cursorOffset", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/javascript/nodejs/util/NodePackage;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;ZI)V", "getContent", "()Ljava/lang/String;", "getFlushConfigCache", "()Z", "getCursorOffset", "()I", "path", "Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "getPath", "()Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "prettierPath", "getPrettierPath", "packageJsonPath", "getPackageJsonPath", "getIgnoreFilePath", "start", "getStart", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "end", "getEnd", "toSerializableObject", "command", "getCommand", "getPresentableText", "intellij.prettierJS"})
    @SourceDebugExtension(value={"SMAP\nPrettierLanguageServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrettierLanguageServiceImpl.kt\ncom/intellij/prettierjs/PrettierLanguageServiceImpl$ReformatFileCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,275:1\n1#2:276\n*E\n"})
    private static final class ReformatFileCommand
    implements JSLanguageServiceObject,
    JSLanguageServiceSimpleCommand {
        @NotNull
        private final String content;
        private final boolean flushConfigCache;
        private final int cursorOffset;
        @NotNull
        private final LocalFilePath path;
        @NotNull
        private final LocalFilePath prettierPath;
        @Nullable
        private final LocalFilePath packageJsonPath;
        @Nullable
        private final LocalFilePath ignoreFilePath;
        @Nullable
        private final Integer start;
        @Nullable
        private final Integer end;
        @NotNull
        private final String command;

        /*
         * WARNING - void declaration
         */
        public ReformatFileCommand(@NotNull Project project, @NotNull String filePath, @NotNull NodePackage prettierPackage, @Nullable String ignoreFilePath, @NotNull String content, @Nullable TextRange range, boolean flushConfigCache, int cursorOffset) {
            LocalFilePath localFilePath;
            String string;
            ReformatFileCommand reformatFileCommand;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)prettierPackage, (String)"prettierPackage");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.content = content;
            this.flushConfigCache = flushConfigCache;
            this.cursorOffset = cursorOffset;
            String string2 = FileUtil.toSystemDependentName((String)filePath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
            this.path = LocalFilePath.Companion.createNotNull(string2);
            Object object = prettierPackage instanceof YarnPnpNodePackage ? (YarnPnpNodePackage)prettierPackage : null;
            if (object == null || (object = object.getName()) == null) {
                object = prettierPackage.getSystemDependentPath();
            }
            this.prettierPath = LocalFilePath.Companion.createNotNull((String)object);
            ReformatFileCommand reformatFileCommand2 = this;
            LocalFilePath.Companion companion = LocalFilePath.Companion;
            YarnPnpNodePackage yarnPnpNodePackage = prettierPackage instanceof YarnPnpNodePackage ? (YarnPnpNodePackage)prettierPackage : null;
            if (yarnPnpNodePackage != null) {
                void it;
                YarnPnpNodePackage yarnPnpNodePackage2 = yarnPnpNodePackage;
                LocalFilePath.Companion companion2 = companion;
                reformatFileCommand = reformatFileCommand2;
                boolean bl = false;
                String string3 = it.getPackageJsonPath(project);
                Intrinsics.checkNotNull((Object)string3);
                String string4 = FileUtil.toSystemDependentName((String)string3);
                reformatFileCommand2 = reformatFileCommand;
                companion = companion2;
                string = string4;
            } else {
                string = null;
            }
            reformatFileCommand2.packageJsonPath = companion.create(string);
            ReformatFileCommand reformatFileCommand3 = this;
            String string5 = ignoreFilePath;
            if (string5 != null) {
                void it;
                String string6 = string5;
                reformatFileCommand = reformatFileCommand3;
                boolean bl = false;
                String string7 = FileUtil.toSystemDependentName((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toSystemDependentName(...)");
                localFilePath = LocalFilePath.Companion.createNotNull(string7);
                reformatFileCommand3 = reformatFileCommand;
            } else {
                localFilePath = null;
            }
            reformatFileCommand3.ignoreFilePath = localFilePath;
            TextRange textRange = range;
            this.start = textRange != null ? Integer.valueOf(textRange.getStartOffset()) : null;
            TextRange textRange2 = range;
            this.end = textRange2 != null ? Integer.valueOf(textRange2.getEndOffset()) : null;
            this.command = "reformat";
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        public final boolean getFlushConfigCache() {
            return this.flushConfigCache;
        }

        public final int getCursorOffset() {
            return this.cursorOffset;
        }

        @NotNull
        public final LocalFilePath getPath() {
            return this.path;
        }

        @NotNull
        public final LocalFilePath getPrettierPath() {
            return this.prettierPath;
        }

        @Nullable
        public final LocalFilePath getPackageJsonPath() {
            return this.packageJsonPath;
        }

        @Nullable
        public final LocalFilePath getIgnoreFilePath() {
            return this.ignoreFilePath;
        }

        @Nullable
        public final Integer getStart() {
            return this.start;
        }

        @Nullable
        public final Integer getEnd() {
            return this.end;
        }

        @NotNull
        public JSLanguageServiceObject toSerializableObject() {
            return this;
        }

        @NotNull
        public String getCommand() {
            return this.command;
        }

        @NotNull
        public String getPresentableText(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String string = PrettierBundle.message("progress.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0017\u001a\u00020\u0001H\u0016J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0018\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lcom/intellij/prettierjs/PrettierLanguageServiceImpl$ResolveConfigCommand;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceObject;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceSimpleCommand;", "project", "Lcom/intellij/openapi/project/Project;", "filePath", "", "prettierPackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "flushConfigCache", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/javascript/nodejs/util/NodePackage;Z)V", "getFlushConfigCache", "()Z", "path", "Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "getPath", "()Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "prettierPath", "getPrettierPath", "packageJsonPath", "getPackageJsonPath", "toSerializableObject", "command", "getCommand", "()Ljava/lang/String;", "getPresentableText", "intellij.prettierJS"})
    private static final class ResolveConfigCommand
    implements JSLanguageServiceObject,
    JSLanguageServiceSimpleCommand {
        private final boolean flushConfigCache;
        @NotNull
        private final LocalFilePath path;
        @NotNull
        private final LocalFilePath prettierPath;
        @Nullable
        private final LocalFilePath packageJsonPath;
        @NotNull
        private final String command;

        /*
         * WARNING - void declaration
         */
        public ResolveConfigCommand(@NotNull Project project, @NotNull String filePath, @NotNull NodePackage prettierPackage, boolean flushConfigCache) {
            String string;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)prettierPackage, (String)"prettierPackage");
            this.flushConfigCache = flushConfigCache;
            String string2 = FileUtil.toSystemDependentName((String)filePath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
            this.path = LocalFilePath.Companion.createNotNull(string2);
            Object object = prettierPackage instanceof YarnPnpNodePackage ? (YarnPnpNodePackage)prettierPackage : null;
            if (object == null || (object = object.getName()) == null) {
                object = prettierPackage.getSystemDependentPath();
            }
            this.prettierPath = LocalFilePath.Companion.createNotNull((String)object);
            ResolveConfigCommand resolveConfigCommand = this;
            LocalFilePath.Companion companion = LocalFilePath.Companion;
            YarnPnpNodePackage yarnPnpNodePackage = prettierPackage instanceof YarnPnpNodePackage ? (YarnPnpNodePackage)prettierPackage : null;
            if (yarnPnpNodePackage != null) {
                void it;
                YarnPnpNodePackage yarnPnpNodePackage2 = yarnPnpNodePackage;
                LocalFilePath.Companion companion2 = companion;
                ResolveConfigCommand resolveConfigCommand2 = resolveConfigCommand;
                boolean bl = false;
                String string3 = it.getPackageJsonPath(project);
                Intrinsics.checkNotNull((Object)string3);
                String string4 = FileUtil.toSystemDependentName((String)string3);
                resolveConfigCommand = resolveConfigCommand2;
                companion = companion2;
                string = string4;
            } else {
                string = null;
            }
            resolveConfigCommand.packageJsonPath = companion.create(string);
            this.command = "resolveConfig";
        }

        public final boolean getFlushConfigCache() {
            return this.flushConfigCache;
        }

        @NotNull
        public final LocalFilePath getPath() {
            return this.path;
        }

        @NotNull
        public final LocalFilePath getPrettierPath() {
            return this.prettierPath;
        }

        @Nullable
        public final LocalFilePath getPackageJsonPath() {
            return this.packageJsonPath;
        }

        @NotNull
        public JSLanguageServiceObject toSerializableObject() {
            return this;
        }

        @NotNull
        public String getCommand() {
            return this.command;
        }

        @NotNull
        public String getPresentableText(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String string = PrettierBundle.message("progress.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }
}

