/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs.formatting;

import com.intellij.codeStyle.AbstractConvertLineSeparatorsAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.formatting.PrettierDiffFragment;
import com.intellij.prettierjs.formatting.PrettierFormattingContext;
import com.intellij.util.LineSeparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u00a8\u0006\u000f"}, d2={"applyTextDifferencesToDocument", "", "formattingContext", "Lcom/intellij/prettierjs/formatting/PrettierFormattingContext;", "diffFragments", "", "Lcom/intellij/prettierjs/formatting/PrettierDiffFragment;", "updateLineSeparatorIfNeeded", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "newSeparator", "Lcom/intellij/util/LineSeparator;", "intellij.prettierJS"})
public final class PrettierApplyStrategyKt {
    public static final void applyTextDifferencesToDocument(@NotNull PrettierFormattingContext formattingContext, @NotNull List<PrettierDiffFragment> diffFragments) {
        Intrinsics.checkNotNullParameter((Object)formattingContext, (String)"formattingContext");
        Intrinsics.checkNotNullParameter(diffFragments, (String)"diffFragments");
        Document document = formattingContext.getDocument();
        String formattedText = formattingContext.getFormattedContent();
        for (PrettierDiffFragment fragment : CollectionsKt.asReversed(diffFragments)) {
            String newText;
            int start1 = fragment.getStartOffset1();
            int end1 = fragment.getEndOffset1();
            int start2 = fragment.getStartOffset2();
            int end2 = fragment.getEndOffset2();
            int len1 = end1 - start1;
            int len2 = end2 - start2;
            if (len1 == 0) {
                Intrinsics.checkNotNullExpressionValue((Object)formattedText.substring(start2, end2), (String)"substring(...)");
                Object insertion = fragment.isCharFragment() ? newText : newText + "\n";
                document.insertString(start1, (CharSequence)insertion);
                continue;
            }
            if (len2 == 0) {
                document.deleteString(start1, end1);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)formattedText.substring(start2, end2), (String)"substring(...)");
            document.replaceString(start1, end1, (CharSequence)newText);
        }
    }

    public static final boolean updateLineSeparatorIfNeeded(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable LineSeparator newSeparator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (newSeparator != null && !Intrinsics.areEqual((Object)virtualFile.getDetectedLineSeparator(), (Object)newSeparator.getSeparatorString())) {
            AbstractConvertLineSeparatorsAction.changeLineSeparators((Project)project, (VirtualFile)virtualFile, (String)newSeparator.getSeparatorString());
            return true;
        }
        return false;
    }
}

