/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs.lsWidget;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.nodejs.npm.InstallNodeLocalDependenciesAction;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.settings.NodeSettingsConfigurable;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JsqtProcessOutputViewer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.PrettierBundle;
import com.intellij.prettierjs.PrettierConfigurable;
import com.intellij.prettierjs.PrettierError;
import com.intellij.prettierjs.PrettierUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/prettierjs/lsWidget/PerformPrettierErrorServiceAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "error", "Lcom/intellij/prettierjs/PrettierError;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/prettierjs/PrettierError;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.prettierJS"})
final class PerformPrettierErrorServiceAction
extends DumbAwareAction {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final PrettierError error;

    public PerformPrettierErrorServiceAction(@NotNull Project project, @NotNull VirtualFile file, @NotNull PrettierError error) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        PrettierError prettierError = error;
        if (prettierError instanceof PrettierError.ShowDetails) {
            string = PrettierBundle.message("prettier.action.show.details", new Object[0]);
        } else if (prettierError instanceof PrettierError.Unsupported) {
            string = PrettierBundle.message("prettier.action.show.details", new Object[0]);
        } else if (prettierError instanceof PrettierError.InstallPackage) {
            Object[] objectArray = new Object[]{NpmManager.getInstance((Project)project).getNpmInstallPresentableText()};
            string = PrettierBundle.message("prettier.action.install.package", objectArray);
        } else if (prettierError instanceof PrettierError.NodeSettings) {
            string = PrettierBundle.message("error.invalid.interpreter", new Object[0]);
        } else if (prettierError instanceof PrettierError.EditSettings) {
            string = PrettierBundle.message("error.no.valid.package", new Object[0]);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        super(string, null, AllIcons.General.Error);
        this.project = project;
        this.file = file;
        this.error = error;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PrettierError prettierError = this.error;
        if (prettierError instanceof PrettierError.InstallPackage) {
            VirtualFile packageJson = PackageJsonUtil.findUpPackageJson((VirtualFile)this.file);
            if (packageJson != null) {
                InstallNodeLocalDependenciesAction.runAndShowConsole((Project)this.project, (VirtualFile)packageJson);
            } else {
                ShowSettingsUtil.getInstance().editConfigurable(this.project, (Configurable)new PrettierConfigurable(this.project));
            }
        } else if (prettierError instanceof PrettierError.EditSettings) {
            ShowSettingsUtil.getInstance().editConfigurable(this.project, (Configurable)new PrettierConfigurable(this.project));
        } else if (prettierError instanceof PrettierError.NodeSettings) {
            NodeSettingsConfigurable.Companion.showSettingsDialog$default((NodeSettingsConfigurable.Companion)NodeSettingsConfigurable.Companion, (Project)this.project, null, (int)2, null);
        } else if (prettierError instanceof PrettierError.ShowDetails) {
            ProcessOutput output = new ProcessOutput();
            output.appendStderr(((PrettierError.ShowDetails)this.error).getMessage());
            JsqtProcessOutputViewer.show((Project)this.project, (String)PrettierBundle.message("prettier.formatter.notification.title", new Object[0]), (Icon)PrettierUtil.ICON, null, null, (ProcessOutput)output);
        } else if (prettierError instanceof PrettierError.Unsupported) {
            ProcessOutput output = new ProcessOutput();
            output.appendStderr(((PrettierError.Unsupported)this.error).getMessage());
            JsqtProcessOutputViewer.show((Project)this.project, (String)PrettierBundle.message("prettier.formatter.notification.title", new Object[0]), (Icon)PrettierUtil.ICON, null, null, (ProcessOutput)output);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }
}

