/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.jetbrains.rd.ide.model.HighlighterElement;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0010'\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\b\b\u0016\u0018\u0000 D2\u00020\u0001:\u0001DB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010(\u001a\u0004\u0018\u00010\t2\u0006\u0010)\u001a\u00020\bH\u0086\u0002J\u0018\u0010(\u001a\u0004\u0018\u00010\b2\u0006\u0010*\u001a\u00020\tH\u0086\u0002\u00a2\u0006\u0002\u0010+J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00100-J\u0018\u0010.\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100/0-J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\t0-H\u0016J\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0010J\u0016\u00104\u001a\u0002022\u0006\u0010*\u001a\u00020\t2\u0006\u00103\u001a\u00020\u0010J\u000e\u00105\u001a\u0002062\u0006\u00103\u001a\u00020\u0010J\u0010\u00107\u001a\u0002022\u0006\u0010*\u001a\u00020\tH\u0016J\u000e\u00108\u001a\u0002022\u0006\u00103\u001a\u00020\rJ\u0016\u00109\u001a\u0002022\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\tJ\u0010\u0010:\u001a\u0004\u0018\u00010\t2\u0006\u0010)\u001a\u00020\bJ\u0006\u0010;\u001a\u000202J\u0006\u0010<\u001a\u00020=J\u0006\u0010>\u001a\u000206J\u000e\u0010?\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\tJ\u0017\u0010A\u001a\u0004\u0018\u0001062\u0006\u0010@\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010BJ\n\u0010C\u001a\u00020=H\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\b0\u0007j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\b`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\t0\u0013j\b\u0012\u0004\u0012\u00020\t`\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R*\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0007j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001d\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010%\u00a8\u0006E"}, d2={"Lcom/jetbrains/rdclient/daemon/HighlighterStorage;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "highlightersMap", "Ljava/util/HashMap;", "", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "Lkotlin/collections/HashMap;", "highlightersBackMap", "invalidHighlighters", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "queuedForRegistration", "Ljava/util/LinkedHashMap;", "Lcom/jetbrains/rd/ide/model/HighlighterElement;", "queuedForUpdate", "queuedForDeletion", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getQueuedForDeletion", "()Ljava/util/HashSet;", "range2Lifetime", "Lcom/intellij/openapi/editor/RangeMarker;", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "registeredHighlighters", "", "getRegisteredHighlighters", "()Ljava/util/Collection;", "all", "", "getAll", "()Ljava/util/Map;", "invalidHighlightersCount", "", "getInvalidHighlightersCount", "()I", "count", "getCount", "get", "id", "highlighter", "(Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;)Ljava/lang/Long;", "flushNotRegistered", "", "flushNotUpdated", "", "flushNotDeleted", "queueRegistration", "", "model", "queueUpdate", "updateRegistration", "", "queueDeletion", "addInvalidHighlighter", "addHighlighter", "remove", "clear", "printQueued", "", "isFlushed", "getLifetime", "rangeMarker", "terminateLifetime", "(Lcom/intellij/openapi/editor/RangeMarker;)Ljava/lang/Boolean;", "toString", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nHighlighterStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighlighterStorage.kt\ncom/jetbrains/rdclient/daemon/HighlighterStorage\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,153:1\n67#2,4:154\n67#2,4:158\n67#2,4:162\n13#2:175\n1915#3,2:166\n383#4,7:168\n*S KotlinDebug\n*F\n+ 1 HighlighterStorage.kt\ncom/jetbrains/rdclient/daemon/HighlighterStorage\n*L\n72#1:154,4\n77#1:158,4\n90#1:162,4\n15#1:175\n129#1:166,2\n141#1:168,7\n*E\n"})
public class HighlighterStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final HashMap<Long, RangeHighlighterEx> highlightersMap;
    @NotNull
    private final HashMap<RangeHighlighterEx, Long> highlightersBackMap;
    @NotNull
    private final HashMap<Long, HighlighterModel> invalidHighlighters;
    @NotNull
    private final LinkedHashMap<Long, HighlighterElement> queuedForRegistration;
    @NotNull
    private final LinkedHashMap<RangeHighlighterEx, HighlighterElement> queuedForUpdate;
    @NotNull
    private final HashSet<RangeHighlighterEx> queuedForDeletion;
    @NotNull
    private final HashMap<RangeMarker, LifetimeDefinition> range2Lifetime;
    @NotNull
    private static final Logger logger;

    public HighlighterStorage(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.lifetime = lifetime;
        this.highlightersMap = new HashMap();
        this.highlightersBackMap = new HashMap();
        this.invalidHighlighters = new HashMap();
        this.queuedForRegistration = new LinkedHashMap(30);
        this.queuedForUpdate = new LinkedHashMap(30);
        this.queuedForDeletion = new HashSet();
        this.range2Lifetime = new HashMap();
    }

    @NotNull
    protected final HashSet<RangeHighlighterEx> getQueuedForDeletion() {
        return this.queuedForDeletion;
    }

    @NotNull
    public final Collection<RangeHighlighterEx> getRegisteredHighlighters() {
        Collection<RangeHighlighterEx> collection = this.highlightersMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    @NotNull
    public final Map<Long, RangeHighlighterEx> getAll() {
        return this.highlightersMap;
    }

    private final int getInvalidHighlightersCount() {
        return this.invalidHighlighters.size();
    }

    public final int getCount() {
        return this.highlightersMap.size() + this.getInvalidHighlightersCount();
    }

    @Nullable
    public final RangeHighlighterEx get(long id) {
        return this.highlightersMap.get(id);
    }

    @Nullable
    public final Long get(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        return this.highlightersBackMap.get(highlighter);
    }

    @NotNull
    public final List<HighlighterElement> flushNotRegistered() {
        Collection<HighlighterElement> collection = this.queuedForRegistration.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        List queued = CollectionsKt.toList((Iterable)collection);
        this.queuedForRegistration.clear();
        return queued;
    }

    @NotNull
    public final List<Map.Entry<RangeHighlighterEx, HighlighterElement>> flushNotUpdated() {
        Set<Map.Entry<RangeHighlighterEx, HighlighterElement>> set = this.queuedForUpdate.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        List queued = CollectionsKt.toList((Iterable)set);
        this.queuedForUpdate.clear();
        return queued;
    }

    @NotNull
    public List<RangeHighlighterEx> flushNotDeleted() {
        List queued = CollectionsKt.toList((Iterable)this.queuedForDeletion);
        this.queuedForDeletion.clear();
        return queued;
    }

    public final void queueRegistration(@NotNull HighlighterElement model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Deferred registration for " + HighlightersUtilKt.prettyPrint(model2.getHighlighter()));
        }
        ((Map)this.queuedForRegistration).put(model2.getHighlighter().getId(), model2);
    }

    public final void queueUpdate(@NotNull RangeHighlighterEx highlighter, @NotNull HighlighterElement model2) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Deferred update for " + HighlightersUtilKt.prettyPrint(model2.getHighlighter()));
        }
        ((Map)this.queuedForUpdate).put(highlighter, model2);
    }

    public final boolean updateRegistration(@NotNull HighlighterElement model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        if (this.queuedForRegistration.containsKey(model2.getHighlighter().getId())) {
            ((Map)this.queuedForRegistration).put(model2.getHighlighter().getId(), model2);
            return true;
        }
        return false;
    }

    public void queueDeletion(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Deferred deletion from markup for " + HighlightersUtilKt.prettyPrint((RangeHighlighter)highlighter));
        }
        this.queuedForDeletion.add(highlighter);
        this.terminateLifetime((RangeMarker)highlighter);
    }

    public final void addInvalidHighlighter(@NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.invalidHighlighters.put(model2.getId(), model2);
    }

    public final void addHighlighter(long id, @NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        ((Map)this.highlightersMap).put(id, highlighter);
        ((Map)this.highlightersBackMap).put(highlighter, id);
    }

    @Nullable
    public final RangeHighlighterEx remove(long id) {
        if (this.queuedForRegistration.remove(id) != null) {
            return null;
        }
        RangeHighlighterEx highlighter = this.highlightersMap.get(id);
        if (highlighter == null) {
            boolean notFound;
            boolean bl = id >= 0L && !((Map)this.invalidHighlighters).isEmpty() && this.invalidHighlighters.remove(id) == null ? true : (notFound = false);
            if (notFound) {
                logger.warn("Deleting non-existing highlighter " + id);
            }
            return null;
        }
        this.highlightersMap.remove(id);
        this.highlightersBackMap.remove(highlighter);
        this.terminateLifetime((RangeMarker)highlighter);
        return highlighter;
    }

    public final void clear() {
        this.highlightersMap.clear();
        this.highlightersBackMap.clear();
        this.invalidHighlighters.clear();
        this.queuedForRegistration.clear();
        this.queuedForDeletion.clear();
        this.queuedForUpdate.clear();
        Collection<LifetimeDefinition> collection = this.range2Lifetime.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LifetimeDefinition it = (LifetimeDefinition)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            LifetimeDefinition.terminate$default((LifetimeDefinition)it, (boolean)false, (int)1, null);
        }
        this.range2Lifetime.clear();
    }

    @NotNull
    public final String printQueued() {
        String string = CollectionsKt.joinToString$default((Iterable)this.queuedForDeletion, (CharSequence)"\n", (CharSequence)"Not Deleted: {\n", (CharSequence)"},", (int)0, null, HighlighterStorage::printQueued$lambda$0, (int)24, null);
        Collection<HighlighterElement> collection = this.queuedForRegistration.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        String string2 = CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"\n", (CharSequence)"Not Registered: {\n", (CharSequence)"},", (int)0, null, HighlighterStorage::printQueued$lambda$1, (int)24, null);
        Collection<HighlighterElement> collection2 = this.queuedForUpdate.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        return string + string2 + CollectionsKt.joinToString$default((Iterable)collection2, (CharSequence)"\n", (CharSequence)"Not Updated: {\n", (CharSequence)"}", (int)0, null, HighlighterStorage::printQueued$lambda$2, (int)24, null);
    }

    public final boolean isFlushed() {
        return this.queuedForDeletion.isEmpty() && this.queuedForRegistration.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Lifetime getLifetime(@NotNull RangeHighlighterEx rangeMarker) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
        Map map = this.range2Lifetime;
        RangeHighlighterEx key$iv = rangeMarker;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            LifetimeDefinition answer$iv = this.lifetime.createNested();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Lifetime)object;
    }

    private final Boolean terminateLifetime(RangeMarker rangeMarker) {
        LifetimeDefinition lifetimeDefinition = this.range2Lifetime.remove(rangeMarker);
        return lifetimeDefinition != null ? Boolean.valueOf(LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null)) : null;
    }

    @NotNull
    public String toString() {
        int registered = this.highlightersMap.size();
        int invalid = this.getInvalidHighlightersCount();
        int notRegistered = this.queuedForRegistration.size();
        int notDeleted = this.queuedForDeletion.size();
        int notUpdated = this.queuedForUpdate.size();
        return "All=" + this.getCount() + "\n; Registered=" + registered + "; Invalid=" + invalid + "; NotRegistered=" + notRegistered + "; NotDeleted=" + notDeleted + "; NotUpdated=" + notUpdated;
    }

    private static final CharSequence printQueued$lambda$0(RangeHighlighterEx it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HighlightersUtilKt.prettyPrint((RangeHighlighter)it);
    }

    private static final CharSequence printQueued$lambda$1(HighlighterElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HighlightersUtilKt.prettyPrint(it.getHighlighter());
    }

    private static final CharSequence printQueued$lambda$2(HighlighterElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HighlightersUtilKt.prettyPrint(it.getHighlighter());
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(HighlighterStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        HighlighterStorage.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/daemon/HighlighterStorage$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

