/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.kubernetes.frontend.editor.floatingToolbar;

import com.intellij.clouds.kubernetes.frontend.editor.floatingToolbar.KubernetesFloatingToolbarExpandableComboAction;
import com.intellij.clouds.kubernetes.frontend.editor.floatingToolbar.KubernetesFloatingToolbarUtilsKt;
import com.intellij.clouds.kubernetes.frontend.i18n.KubernetesFrontendBundle;
import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesApiProviderInterface;
import com.intellij.kubernetes.frontend.FrontendKubernetesApiProvider;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.ui.actions.PopupUtilsKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/clouds/kubernetes/frontend/editor/floatingToolbar/KubernetesNamespaceSwitcherAction;", "Lcom/intellij/clouds/kubernetes/frontend/editor/floatingToolbar/KubernetesFloatingToolbarExpandableComboAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "event", "NamespaceSelectorPopupItemAction", "intellij.clouds.kubernetes.frontend"})
@SourceDebugExtension(value={"SMAP\nKubernetesNamespaceSwitcherAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesNamespaceSwitcherAction.kt\ncom/intellij/clouds/kubernetes/frontend/editor/floatingToolbar/KubernetesNamespaceSwitcherAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,123:1\n13#2:124\n*S KotlinDebug\n*F\n+ 1 KubernetesNamespaceSwitcherAction.kt\ncom/intellij/clouds/kubernetes/frontend/editor/floatingToolbar/KubernetesNamespaceSwitcherAction\n*L\n75#1:124\n*E\n"})
public final class KubernetesNamespaceSwitcherAction
extends KubernetesFloatingToolbarExpandableComboAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            KubernetesNamespaceSwitcherAction $this$update_u24lambda_u240 = this;
            boolean bl = false;
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Project project2 = project;
        KubernetesApiProviderInterface k8sApiProvider = FrontendKubernetesApiProvider.Companion.getInstance(project2);
        Context currentContext = k8sApiProvider.getSelectedContext();
        if (currentContext == null) {
            Set contexts = k8sApiProvider.getConfiguredContexts();
            if (contexts.isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
            } else {
                e.getPresentation().setText(KubernetesFrontendBundle.INSTANCE.message("floating.toolbar.namespace.placeholder.combobox.action.text", new Object[0]));
                e.getPresentation().setDescription(null);
                e.getPresentation().setEnabled(false);
                e.getPresentation().setVisible(true);
            }
        } else {
            KubernetesApiModelInterface apiModel = k8sApiProvider.findModel(currentContext);
            if (apiModel == null) {
                e.getPresentation().setText(KubernetesFrontendBundle.INSTANCE.message("floating.toolbar.namespace.placeholder.combobox.action.text", new Object[0]));
                e.getPresentation().setDescription(null);
                e.getPresentation().setEnabled(false);
                e.getPresentation().setVisible(true);
            } else {
                String fullName = apiModel.getNamespace();
                String shortName = KubernetesFloatingToolbarUtilsKt.shortenIfNeed(fullName, 15, 6);
                e.getPresentation().setText(shortName);
                e.getPresentation().setDescription(fullName);
                e.getPresentation().setEnabledAndVisible(true);
            }
        }
    }

    @Nullable
    public JBPopup createPopup(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        DefaultActionGroup group = new DefaultActionGroup();
        KubernetesApiProviderInterface apiProvider = FrontendKubernetesApiProvider.Companion.getInstance(project2);
        Context currentContext = apiProvider.getSelectedContext();
        KubernetesApiModelInterface kubernetesApiModelInterface = apiProvider.findModel(currentContext);
        if (kubernetesApiModelInterface == null) {
            KubernetesNamespaceSwitcherAction $this$createPopup_u24lambda_u240 = this;
            boolean bl = false;
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(KubernetesNamespaceSwitcherAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot find k8s api model for the current context: " + currentContext);
            return null;
        }
        KubernetesApiModelInterface apiModel = kubernetesApiModelInterface;
        Set namespaces2 = (Set)PopupUtilsKt.computeWithProgressIcon((AnActionEvent)event, (Function1)((Function1)new Function1<Continuation<? super Set<? extends String>>, Object>(apiModel, null){
            int label;
            final /* synthetic */ KubernetesApiModelInterface $apiModel;
            {
                this.$apiModel = $apiModel;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$apiModel.getKnownNamespaces((Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Set<String>> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        String string = KubernetesBundle.message((String)"action.Kubernetes.AllNamespaces.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        NamespaceSelectorPopupItemAction allNsAction = new NamespaceSelectorPopupItemAction(apiModel, "Kubernetes.All.Namespaces.Label", string);
        group.add((AnAction)allNsAction);
        group.addSeparator();
        for (String namespace : SetsKt.minus((Set)namespaces2, (Object)"Kubernetes.All.Namespaces.Label")) {
            NamespaceSelectorPopupItemAction action2 = new NamespaceSelectorPopupItemAction(apiModel, namespace, namespace);
            group.add((AnAction)action2);
        }
        JBPopupFactory factory = JBPopupFactory.getInstance();
        return (JBPopup)factory.createActionGroupPopup(null, (ActionGroup)group, event.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, 10, null, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000b\u0010\u0006\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/clouds/kubernetes/frontend/editor/floatingToolbar/KubernetesNamespaceSwitcherAction$NamespaceSelectorPopupItemAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "namespace", "", "actionText", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "<init>", "(Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;Ljava/lang/String;Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.clouds.kubernetes.frontend"})
    private static final class NamespaceSelectorPopupItemAction
    extends AnAction {
        @NotNull
        private final KubernetesApiModelInterface apiModel;
        @NotNull
        private final String namespace;

        public NamespaceSelectorPopupItemAction(@NotNull KubernetesApiModelInterface apiModel, @NotNull String namespace, @NotNull String actionText) {
            Intrinsics.checkNotNullParameter((Object)apiModel, (String)"apiModel");
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)actionText, (String)"actionText");
            super(actionText);
            this.apiModel = apiModel;
            this.namespace = namespace;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            KubernetesUsageTriggerCollector.INSTANCE.getFLOATING_TOOLBAR_ACTION_TRIGGERED_EVENT().log(e.getProject(), (Object)"floating-toolbar.select-namespace");
            this.apiModel.scheduleSetNamespace(this.namespace);
        }
    }
}

