/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.project.actions;

import com.intellij.ide.util.gotoByName.SimpleChooseByNameModel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.uml.java.project.ui.ModulesListCellRenderer;
import com.intellij.uml.java.utils.DiagramJavaBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

class ModulesChooseByNameModel
extends SimpleChooseByNameModel
implements DumbAware {
    private final Map<String, Module> modules;
    private final Map<String, Library> libraries;

    ModulesChooseByNameModel(@NotNull Project project) {
        if (project == null) {
            ModulesChooseByNameModel.$$$reportNull$$$0(0);
        }
        super(project, DiagramJavaBundle.message("enter.module.name", new Object[0]), null);
        this.modules = new HashMap<String, Module>();
        this.libraries = new HashMap<String, Library>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            this.modules.put(module.getName(), module);
        }
        for (Module module : LibraryTablesRegistrar.getInstance().getLibraryTable(project).getLibraries()) {
            this.libraries.put(module.getName(), (Library)module);
        }
    }

    public String[] getNames() {
        return ArrayUtil.mergeArrays((String[])ArrayUtilRt.toStringArray(this.modules.keySet()), (String[])ArrayUtilRt.toStringArray(this.libraries.keySet()));
    }

    protected Object[] getElementsByName(String name, String pattern) {
        Object[] objectArray;
        Module module = this.modules.get(name);
        Library library = this.libraries.get(name);
        if (module == null && library == null) {
            objectArray = AnAction.EMPTY_ARRAY;
        } else if (module != null && library == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = module;
        } else if (module == null) {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = library;
        } else {
            Object[] objectArray4 = new Object[2];
            objectArray4[0] = module;
            objectArray = objectArray4;
            objectArray4[1] = library;
        }
        return objectArray;
    }

    @NotNull
    public ListCellRenderer getListCellRenderer() {
        return new ModulesListCellRenderer();
    }

    public String getElementName(@NotNull Object element) {
        if (element == null) {
            ModulesChooseByNameModel.$$$reportNull$$$0(1);
        }
        return element instanceof Module ? ((Module)element).getName() : (element instanceof Library ? ((Library)element).getName() : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uml/java/project/actions/ModulesChooseByNameModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

