/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.introspection.ScriptedName;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlTokenType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\bH\u0002\u001a\f\u0010\t\u001a\u00020\u0001*\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0002\u001a\u0010\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00040\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00040\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"publicSchemaName", "Lcom/intellij/database/introspection/ScriptedName;", "psiReplaceOrUpdateTypes", "", "Lcom/intellij/sql/psi/SqlTokenType;", "kotlin.jvm.PlatformType", "psiTypeOrPackageTypes", "getScriptedName", "Lcom/intellij/sql/psi/SqlNameElement;", "unquoteIfNeeded", "intellij.database.dialects.oracle"})
public final class OraAffectAnalyzerKt {
    @NotNull
    private static final ScriptedName publicSchemaName = new ScriptedName("PUBLIC", false);
    @NotNull
    private static final Set<SqlTokenType> psiReplaceOrUpdateTypes;
    @NotNull
    private static final Set<SqlTokenType> psiTypeOrPackageTypes;

    private static final ScriptedName getScriptedName(SqlNameElement $this$getScriptedName) {
        String string = $this$getScriptedName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return ScriptedName.Companion.of(string, $this$getScriptedName.isQuotedIdentifier());
    }

    private static final ScriptedName unquoteIfNeeded(ScriptedName $this$unquoteIfNeeded) {
        String name2 = $this$unquoteIfNeeded.getName();
        int n = name2.length();
        if (n >= 3 && StringsKt.startsWith$default((CharSequence)name2, (char)'\"', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)name2, (char)'\"', (boolean)false, (int)2, null)) {
            String string = name2.substring(1, n - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return ScriptedName.Companion.of(string, true);
        }
        return $this$unquoteIfNeeded;
    }

    public static final /* synthetic */ Set access$getPsiTypeOrPackageTypes$p() {
        return psiTypeOrPackageTypes;
    }

    public static final /* synthetic */ ScriptedName access$getScriptedName(SqlNameElement $receiver) {
        return OraAffectAnalyzerKt.getScriptedName($receiver);
    }

    public static final /* synthetic */ ScriptedName access$unquoteIfNeeded(ScriptedName $receiver) {
        return OraAffectAnalyzerKt.unquoteIfNeeded($receiver);
    }

    public static final /* synthetic */ ScriptedName access$getPublicSchemaName$p() {
        return publicSchemaName;
    }

    public static final /* synthetic */ Set access$getPsiReplaceOrUpdateTypes$p() {
        return psiReplaceOrUpdateTypes;
    }

    static {
        Object[] objectArray = new SqlTokenType[]{SqlCommonKeywords.SQL_REPLACE, SqlCommonKeywords.SQL_UPDATE};
        psiReplaceOrUpdateTypes = SetsKt.setOf((Object[])objectArray);
        objectArray = new SqlTokenType[]{SqlCommonKeywords.SQL_TYPE, SqlCommonKeywords.SQL_PACKAGE};
        psiTypeOrPackageTypes = SetsKt.setOf((Object[])objectArray);
    }
}

