/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.ui;

import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.ToolbarPanel;
import com.intellij.execution.testframework.ui.SameHeightPanel;
import com.intellij.execution.testframework.ui.TestStatusLine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SideBorder;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestResultsPanel
extends JPanel
implements Disposable,
UiCompatibleDataProvider {
    private JScrollPane myLeftPane;
    protected final JComponent myConsole;
    protected ToolbarPanel myToolbarPanel;
    private final String mySplitterProportionProperty;
    private final float mySplitterDefaultProportion;
    protected final AnAction[] myConsoleActions;
    protected final TestConsoleProperties myProperties;
    protected TestStatusLine myStatusLine;
    private JBSplitter mySplitter;
    private JComponent myToolbarComponent;

    protected TestResultsPanel(@NotNull JComponent console, AnAction[] consoleActions, TestConsoleProperties properties, @NotNull String splitterProportionProperty, float splitterDefaultProportion) {
        if (console == null) {
            TestResultsPanel.$$$reportNull$$$0(0);
        }
        if (splitterProportionProperty == null) {
            TestResultsPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout(0, 1));
        this.myConsole = console;
        this.myConsoleActions = consoleActions;
        this.myProperties = properties;
        this.mySplitterProportionProperty = splitterProportionProperty;
        this.mySplitterDefaultProportion = splitterDefaultProportion;
        ToolWindowManagerListener listener2 = new ToolWindowManagerListener(){

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                if (toolWindowManager == null) {
                    1.$$$reportNull$$$0(0);
                }
                TestResultsPanel.this.mySplitter.setOrientation(TestResultsPanel.this.splitVertically());
                TestResultsPanel.this.revalidate();
                TestResultsPanel.this.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "com/intellij/execution/testframework/ui/TestResultsPanel$1", "stateChanged"));
            }
        };
        properties.getProject().getMessageBus().connect((Disposable)this).subscribe(ToolWindowManagerListener.TOPIC, (Object)listener2);
    }

    @NotNull
    public TestStatusLine getStatusLine() {
        TestStatusLine testStatusLine = this.myStatusLine;
        if (testStatusLine == null) {
            TestResultsPanel.$$$reportNull$$$0(2);
        }
        return testStatusLine;
    }

    protected void hideToolbar() {
        this.myLeftPane.setBorder((Border)JBUI.Borders.empty());
    }

    public void initUI() {
        this.myLeftPane = ScrollPaneFactory.createScrollPane();
        this.myLeftPane.putClientProperty(UIUtil.KEEP_BORDER_SIDES, 2);
        this.myStatusLine = this.createStatusLine();
        JComponent testTreeView = this.createTestTreeView();
        this.myToolbarPanel = this.createToolbarPanel();
        Disposer.register((Disposable)this, (Disposable)this.myToolbarPanel);
        boolean splitVertically = this.splitVertically();
        this.mySplitter = TestResultsPanel.createSplitter(this.mySplitterProportionProperty, this.mySplitterDefaultProportion, splitVertically);
        if (this.mySplitter instanceof OnePixelSplitter) {
            ((OnePixelSplitter)this.mySplitter).setBlindZone(() -> JBUI.insetsTop((int)this.myToolbarPanel.getHeight()));
        }
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                TestResultsPanel.this.remove((Component)TestResultsPanel.this.mySplitter);
                TestResultsPanel.this.mySplitter.dispose();
            }
        });
        this.mySplitter.setOpaque(false);
        this.add((Component)this.mySplitter, "Center");
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.myLeftPane, "Center");
        leftPanel.add((Component)this.myToolbarPanel, "North");
        this.mySplitter.setFirstComponent((JComponent)leftPanel);
        this.myStatusLine.setMinimumSize(new Dimension(0, this.myStatusLine.getMinimumSize().height));
        NonOpaquePanel rightPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        rightPanel.add((Component)((Object)SameHeightPanel.wrap((JComponent)((Object)this.myStatusLine), this.myToolbarPanel)), "North");
        NonOpaquePanel outputTab = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.myConsole.setFocusable(true);
        Color editorBackground = EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
        this.myConsole.setBorder(new CompoundBorder(IdeBorderFactory.createBorder((int)4), (Border)new SideBorder(editorBackground, 1)));
        outputTab.add((Component)this.myConsole, "Center");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("TestRunnerResults", (ActionGroup)new DefaultActionGroup(this.myConsoleActions), false);
        toolbar.setTargetComponent(this.myConsole instanceof ComponentContainer ? ((ComponentContainer)this.myConsole).getPreferredFocusableComponent() : this.myConsole);
        this.myToolbarComponent = toolbar.getComponent();
        outputTab.add((Component)this.myToolbarComponent, "East");
        rightPanel.add((Component)outputTab, "Center");
        this.mySplitter.setSecondComponent((JComponent)rightPanel);
        if (!ExperimentalUI.isNewUI()) {
            testTreeView.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        }
        this.setLeftComponent(testTreeView);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.myStatusLine.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, this.myToolbarComponent.getPreferredSize().width));
    }

    private boolean splitVertically() {
        String windowId = this.myProperties.getExecutor().getToolWindowId();
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProperties.getProject()).getToolWindow(windowId);
        boolean splitVertically = false;
        if (toolWindow != null) {
            ToolWindowAnchor anchor = toolWindow.getAnchor();
            splitVertically = anchor == ToolWindowAnchor.LEFT || anchor == ToolWindowAnchor.RIGHT;
        }
        return splitVertically;
    }

    @ApiStatus.Internal
    protected ToolbarPanel createToolbarPanel() {
        return new ToolbarPanel(this.myProperties, this);
    }

    protected TestStatusLine createStatusLine() {
        return new TestStatusLine();
    }

    protected abstract JComponent createTestTreeView();

    @Nullable
    protected TestTreeView getTreeView() {
        return null;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            TestResultsPanel.$$$reportNull$$$0(3);
        }
        DataSink.uiDataSnapshot((DataSink)sink, (DataProvider)this.getTreeView());
    }

    public void dispose() {
    }

    @NotNull
    protected static JBSplitter createSplitter(@NotNull String proportionProperty, float defaultProportion, boolean splitVertically) {
        if (proportionProperty == null) {
            TestResultsPanel.$$$reportNull$$$0(4);
        }
        OnePixelSplitter splitter = new OnePixelSplitter(splitVertically, proportionProperty, defaultProportion);
        splitter.setHonorComponentsMinimumSize(true);
        OnePixelSplitter onePixelSplitter = splitter;
        if (onePixelSplitter == null) {
            TestResultsPanel.$$$reportNull$$$0(5);
        }
        return onePixelSplitter;
    }

    protected void setLeftComponent(JComponent component) {
        if (component != this.myLeftPane.getViewport().getView()) {
            this.myLeftPane.setViewportView(component);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitterProportionProperty";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/ui/TestResultsPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proportionProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/ui/TestResultsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusLine";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSplitter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }
}

