/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui;

import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.ui.GroupInputDialog;
import com.intellij.ide.bookmark.ui.GroupInputValidator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0014\u001a\u0004\u0018\u00010\nR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/bookmark/ui/GroupRenameDialog;", "Lcom/intellij/ide/bookmark/ui/GroupInputDialog;", "Ljavax/swing/JTextField;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Ljava/awt/Component;", "manager", "Lcom/intellij/ide/bookmark/BookmarksManager;", "group", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/awt/Component;Lcom/intellij/ide/bookmark/BookmarksManager;Lcom/intellij/ide/bookmark/BookmarkGroup;)V", "getManager", "()Lcom/intellij/ide/bookmark/BookmarksManager;", "getGroup", "()Lcom/intellij/ide/bookmark/BookmarkGroup;", "component", "getComponent", "()Ljavax/swing/JTextField;", "showAndGetGroup", "intellij.platform.bookmarks"})
public final class GroupRenameDialog
extends GroupInputDialog<JTextField> {
    @NotNull
    private final BookmarksManager manager;
    @NotNull
    private final BookmarkGroup group;
    @NotNull
    private final JTextField component;

    public GroupRenameDialog(@Nullable Project project, @Nullable Component parent, @NotNull BookmarksManager manager, @NotNull BookmarkGroup group) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        super(project, parent);
        this.manager = manager;
        this.group = group;
        this.component = new JTextField(this.group.getName(), 30);
    }

    @NotNull
    public final BookmarksManager getManager() {
        return this.manager;
    }

    @NotNull
    public final BookmarkGroup getGroup() {
        return this.group;
    }

    @Override
    @NotNull
    public JTextField getComponent() {
        return this.component;
    }

    @Nullable
    public final BookmarkGroup showAndGetGroup() {
        GroupInputValidator groupInputValidator = new GroupInputValidator(this.manager, CollectionsKt.listOf((Object)this.group));
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        groupInputValidator.install$intellij_platform_bookmarks(disposable, this.getComponent(), (Function0<String>)((Function0)() -> GroupRenameDialog.showAndGetGroup$lambda$0(this))).andRegisterOnDocumentListener((JTextComponent)this.getComponent()).revalidate();
        this.setTitle(BookmarkBundle.message("dialog.group.rename.title", new Object[0]));
        this.setOKButtonText(BookmarkBundle.message("dialog.group.rename.button", new Object[0]));
        return this.showAndGetGroup(this.group.isDefault(), (Function1<Boolean, BookmarkGroup>)((Function1)arg_0 -> GroupRenameDialog.showAndGetGroup$lambda$1(this, arg_0)));
    }

    private static final String showAndGetGroup$lambda$0(GroupRenameDialog this$0) {
        return this$0.getComponent().getText();
    }

    private static final BookmarkGroup showAndGetGroup$lambda$1(GroupRenameDialog this$0, boolean it) {
        BookmarkGroup bookmarkGroup;
        BookmarkGroup $this$showAndGetGroup_u24lambda_u241_u240 = bookmarkGroup = this$0.group;
        boolean bl = false;
        String string = this$0.getComponent().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        $this$showAndGetGroup_u24lambda_u241_u240.setName(((Object)StringsKt.trim((CharSequence)string)).toString());
        $this$showAndGetGroup_u24lambda_u241_u240.setDefault(it);
        return bookmarkGroup;
    }
}

