/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.remote.RemoteFile;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteProcessUtil {
    @Contract(value="null -> null")
    public static String toRemoteFileSystemStyle(@Nullable String path) {
        return path == null ? null : RemoteFile.createRemoteFile(path).getPath();
    }

    public static String[] buildRemoteCommand(@NotNull AbstractPathMapper pathMapper, @NotNull Collection<String> commands) {
        if (pathMapper == null) {
            RemoteProcessUtil.$$$reportNull$$$0(0);
        }
        if (commands == null) {
            RemoteProcessUtil.$$$reportNull$$$0(1);
        }
        return ArrayUtilRt.toStringArray((Collection)pathMapper.convertToRemote(commands));
    }

    @NotNull
    public static String remapPathsList(@NotNull String pathsValue, @NotNull PathMapper pathMapper, @NotNull String interpreterPath) {
        if (pathsValue == null) {
            RemoteProcessUtil.$$$reportNull$$$0(2);
        }
        if (pathMapper == null) {
            RemoteProcessUtil.$$$reportNull$$$0(3);
        }
        if (interpreterPath == null) {
            RemoteProcessUtil.$$$reportNull$$$0(4);
        }
        boolean isWin = RemoteFile.isWindowsPath(interpreterPath);
        ArrayList<String> mappedPaths = new ArrayList<String>();
        for (String path : pathsValue.split(File.pathSeparator)) {
            mappedPaths.add(RemoteFile.createRemoteFile(pathMapper.convertToRemote(path), isWin).getPath());
        }
        String string = String.join((CharSequence)(isWin ? ";" : ":"), mappedPaths);
        if (string == null) {
            RemoteProcessUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathsValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/RemoteProcessUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/RemoteProcessUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "remapPathsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildRemoteCommand";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "remapPathsList";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

