/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunDialog;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurationManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationTypesRegistrar;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DeploymentConfigurationManagerImpl
extends DeploymentConfigurationManager {
    @NotNull
    private final Project myProject;

    DeploymentConfigurationManagerImpl(@NotNull Project project) {
        if (project == null) {
            DeploymentConfigurationManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Override
    @NotNull
    public List<RunnerAndConfigurationSettings> getDeploymentConfigurations(@NotNull ServerType<?> serverType) {
        if (serverType == null) {
            DeploymentConfigurationManagerImpl.$$$reportNull$$$0(1);
        }
        DeployToServerConfigurationType<?> configurationType = DeployToServerConfigurationTypesRegistrar.getInstance().getConfigurationType(serverType);
        List<RunnerAndConfigurationSettings> list2 = RunManager.getInstance(this.myProject).getConfigurationSettingsList(configurationType);
        if (list2 == null) {
            DeploymentConfigurationManagerImpl.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    public void createAndRunConfiguration(@NotNull ServerType<?> serverType, @Nullable RemoteServer<?> remoteServer, @Nullable DeploymentSourceType<?> sourceType) {
        if (serverType == null) {
            DeploymentConfigurationManagerImpl.$$$reportNull$$$0(3);
        }
        DeployToServerConfigurationType<?> configurationType = DeployToServerConfigurationTypesRegistrar.getInstance().getConfigurationType(serverType);
        RunManager runManager = RunManager.getInstance(this.myProject);
        ConfigurationFactory factory = configurationType.getFactoryForType(sourceType);
        RunnerAndConfigurationSettings settings = runManager.createConfiguration(configurationType.getDisplayName(), factory);
        DeployToServerRunConfiguration runConfiguration = (DeployToServerRunConfiguration)settings.getConfiguration();
        runConfiguration.onNewConfigurationCreated();
        if (remoteServer != null) {
            runConfiguration.setServerName(remoteServer.getName());
        }
        if (RunDialog.editConfiguration((Project)this.myProject, (RunnerAndConfigurationSettings)settings, (String)CloudBundle.message("dialog.title.create.deployment.configuration", new Object[0]), (Executor)DefaultRunExecutor.getRunExecutorInstance())) {
            runManager.addConfiguration(settings);
            runManager.setSelectedConfiguration(settings);
            ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)settings, (Executor)DefaultRunExecutor.getRunExecutorInstance());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/configuration/deployment/DeploymentConfigurationManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/DeploymentConfigurationManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDeploymentConfigurations";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAndRunConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

