/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.jpa.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.jpa.jpb.model.repository.RepositoryMethodModel;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.data.jpa.inspections.fix.CreatePageableParameterFix;
import com.intellij.spring.data.jpa.inspections.fix.ReplacePageToListFix;
import com.intellij.spring.data.utils.SpringDataBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00052\u0006\u0010\u0016\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0017J1\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0002\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/spring/data/jpa/inspections/SpringDataPageableParameterMissingInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "isInspectionAvailable", "getProblemPsiElements", "Lcom/intellij/psi/PsiElement;", "uClass", "Lorg/jetbrains/uast/UClass;", "(Lorg/jetbrains/uast/UClass;)[Lcom/intellij/psi/PsiElement;", "getFixes", "Lcom/intellij/codeInspection/LocalQuickFix;", "psiElement", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/codeInspection/LocalQuickFix;", "createProblemDescriptors", "psiElements", "(Lcom/intellij/codeInspection/InspectionManager;Z[Lcom/intellij/psi/PsiElement;)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getProblemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "intellij.spring.data.jpa"})
@SourceDebugExtension(value={"SMAP\nSpringDataPageableParameterMissingInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringDataPageableParameterMissingInspection.kt\ncom/intellij/spring/data/jpa/inspections/SpringDataPageableParameterMissingInspection\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 SUastUtils.kt\ncom/intellij/jpa/jpb/model/util/SUastUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,87:1\n12033#2,10:88\n14060#2:98\n14061#2:101\n12043#2:102\n20240#2,2:111\n3938#2:116\n4474#2,2:117\n93#3:99\n93#3:115\n1#4:100\n1391#5:103\n1480#5,5:104\n1586#5:119\n1661#5,3:120\n37#6,2:109\n37#6,2:113\n37#6,2:123\n*S KotlinDebug\n*F\n+ 1 SpringDataPageableParameterMissingInspection.kt\ncom/intellij/spring/data/jpa/inspections/SpringDataPageableParameterMissingInspection\n*L\n24#1:88,10\n24#1:98\n24#1:101\n24#1:102\n57#1:111,2\n74#1:116\n74#1:117,2\n24#1:99\n66#1:115\n24#1:100\n25#1:103\n25#1:104,5\n75#1:119\n75#1:120,3\n34#1:109,2\n62#1:113,2\n81#1:123,2\n*E\n"})
public final class SpringDataPageableParameterMissingInspection
extends LocalInspectionTool {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (this.isInspectionAvailable(file)) {
            void $this$toTypedArray$iv;
            void $this$flatMapTo$iv$iv;
            Collection $this$flatMap$iv;
            void $this$mapNotNullTo$iv$iv;
            PsiClass[] classes;
            PsiClass[] psiClassArray = ((PsiClassOwner)file).getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getClasses(...)");
            Object $this$mapNotNull$iv = classes = psiClassArray;
            boolean $i$f$mapNotNull = false;
            PsiClass[] psiClassArray2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                UClass it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                PsiElement $this$toUElementWithType$iv = (PsiElement)it;
                boolean $i$f$toUElementWithType = false;
                if ((UClass)UastContextKt.toUElement((PsiElement)$this$toUElementWithType$iv, UClass.class) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                UClass it = (UClass)element$iv$iv;
                boolean bl = false;
                PsiElement[] problemPsiElements = this.getProblemPsiElements(it);
                Iterable list$iv$iv = problemPsiElements.length == 0 ? CollectionsKt.emptyList() : ArraysKt.toList((Object[])this.createProblemDescriptors(manager, isOnTheFly, problemPsiElements));
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new ProblemDescriptor[0]);
        }
        return new ProblemDescriptor[0];
    }

    private final boolean isInspectionAvailable(PsiFile file) {
        boolean inspectionAvailable;
        boolean bl = inspectionAvailable = JpaUtil.isJpaAvailable((Module)ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)file))) && file instanceof PsiClassOwner;
        if (!inspectionAvailable) {
            return false;
        }
        return JpaUtils.isSpringDataProject((Project)((PsiClassOwner)file).getProject());
    }

    private final PsiElement[] getProblemPsiElements(UClass uClass) {
        List result = new ArrayList();
        if (!uClass.isInterface() || !SpringDataUtil.isRepository((PsiClass)uClass.getJavaPsi())) {
            return new PsiElement[0];
        }
        for (UMethod method : uClass.getMethods()) {
            boolean bl;
            block3: {
                String pageFgn = RepositoryMethodModel.WrapType.Page.getFqn();
                UTypeReferenceExpression uTypeReferenceExpression = method.getReturnTypeReference();
                if (!Intrinsics.areEqual((Object)pageFgn, (Object)(uTypeReferenceExpression != null ? uTypeReferenceExpression.getQualifiedName() : null))) continue;
                PsiType psiType = method.getReturnType();
                if (Intrinsics.areEqual((Object)pageFgn, (Object)(psiType != null ? psiType.getCanonicalText() : null))) continue;
                PsiParameter[] psiParameterArray = method.getJavaPsi().getParameterList().getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
                Object[] $this$none$iv = psiParameterArray;
                boolean $i$f$none = false;
                for (Object element$iv : $this$none$iv) {
                    PsiParameter it = (PsiParameter)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getType().getCanonicalText(), (Object)"org.springframework.data.domain.Pageable")) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            if (!bl) continue;
            UElement uElement = method.getUastAnchor();
            Object object = uElement != null ? uElement.getSourcePsi() : null;
            Intrinsics.checkNotNull((Object)object);
            result.add(object);
        }
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiElement[0]);
    }

    private final LocalQuickFix[] getFixes(PsiElement psiElement) {
        PsiElement $this$toUElementWithType$iv = psiElement.getParent();
        boolean $i$f$toUElementWithType = false;
        Object object = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementWithType$iv, UMethod.class);
        if (object == null || (object = object.getReturnType()) == null || (object = object.getPresentableText()) == null) {
            return new LocalQuickFix[0];
        }
        Object presentableType = object;
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new CreatePageableParameterFix(), new ReplacePageToListFix((String)presentableType)};
        return localQuickFixArray;
    }

    /*
     * WARNING - void declaration
     */
    private final ProblemDescriptor[] createProblemDescriptors(InspectionManager manager, boolean isOnTheFly, PsiElement[] psiElements) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        PsiElement[] psiElementArray = psiElements;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (PsiElement element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!it.isPhysical()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void psiElement;
            PsiElement element$iv$iv;
            element$iv$iv = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v0 = psiElement;
            Intrinsics.checkNotNull((Object)v0);
            collection.add(manager.createProblemDescriptor((PsiElement)v0, SpringDataBundle.message((String)"inspection.SpringDataPageableParameterMissing", (Object[])new Object[0]), isOnTheFly, this.getFixes((PsiElement)psiElement), this.getProblemHighlightType()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new ProblemDescriptor[0]);
    }

    private final ProblemHighlightType getProblemHighlightType() {
        return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }
}

