/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.actions.BaseShowDiffAction;
import com.intellij.diff.actions.impl.MutableDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.util.BlankDiffWindowUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.Side;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CompareClipboardWithSelectionAction
extends BaseShowDiffAction {
    @Nullable
    private static Editor getEditor(@NotNull AnActionEvent e) {
        Editor editor;
        if (e == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(0);
        }
        if ((editor = (Editor)e.getData(CommonDataKeys.EDITOR)) != null) {
            return editor;
        }
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        return FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
    }

    @Nullable
    private static FileType getEditorFileType(@NotNull AnActionEvent e) {
        DiffContent content;
        if (e == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(1);
        }
        if ((content = (DiffContent)e.getData(DiffDataKeys.CURRENT_CONTENT)) != null && content.getContentType() != null) {
            return content.getContentType();
        }
        DiffRequest request = (DiffRequest)e.getData(DiffDataKeys.DIFF_REQUEST);
        if (request instanceof ContentDiffRequest) {
            for (DiffContent diffContent : ((ContentDiffRequest)request).getContents()) {
                FileType type = diffContent.getContentType();
                if (type == null || type == UnknownFileType.INSTANCE) continue;
                return type;
            }
        }
        return null;
    }

    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        Editor editor;
        if (e == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(2);
        }
        return (editor = CompareClipboardWithSelectionAction.getEditor(e)) != null;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    @Override
    @Nullable
    protected DiffRequestChain getDiffRequestChain(@NotNull AnActionEvent e) {
        String editorContentTitle;
        if (e == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(4);
        }
        Project project = e.getProject();
        Editor editor = CompareClipboardWithSelectionAction.getEditor(e);
        FileType editorFileType = CompareClipboardWithSelectionAction.getEditorFileType(e);
        assert (editor != null);
        DiffContent selectedContent = (DiffContent)e.getData(DiffDataKeys.CURRENT_CONTENT);
        DocumentContent content2 = CompareClipboardWithSelectionAction.createContent(project, editor, editorFileType, selectedContent, e);
        DocumentContent content1 = DiffContentFactory.getInstance().createClipboardContent(project, content2);
        content1.putUserData(BlankDiffWindowUtil.REMEMBER_CONTENT_KEY, (Object)true);
        VirtualFile editorFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
        String string = editorContentTitle = editorFile != null ? DiffRequestFactory.getInstance().getTitle(editorFile) : DiffBundle.message((String)"diff.content.editor.content.title", (Object[])new Object[0]);
        if (editor.getSelectionModel().hasSelection()) {
            editorContentTitle = DiffBundle.message((String)"diff.content.selection.from.file.content.title", (Object[])new Object[]{editorContentTitle});
        }
        MutableDiffRequestChain chain = BlankDiffWindowUtil.createBlankDiffRequestChain(content1, content2, null, project);
        String windowTitle = editorFile != null ? DiffBundle.message((String)"diff.clipboard.vs.editor.dialog.title.with.filename", (Object[])new Object[]{editorFile.getName()}) : DiffBundle.message((String)"diff.clipboard.vs.editor.dialog.title", (Object[])new Object[0]);
        chain.setWindowTitle(windowTitle);
        chain.setTitle1(DiffBundle.message((String)"diff.content.clipboard.content.title", (Object[])new Object[0]));
        chain.setTitle2(editorContentTitle);
        int currentLine = editor.getCaretModel().getLogicalPosition().line;
        chain.putRequestUserData(DiffUserDataKeys.SCROLL_TO_LINE, Pair.create((Object)Side.RIGHT, (Object)currentLine));
        return chain;
    }

    @NotNull
    private static DocumentContent createContent(@Nullable Project project, @NotNull Editor editor, @Nullable FileType type, @Nullable DiffContent selectedContent, @NotNull AnActionEvent e) {
        SelectionModel selectionModel;
        Document editorDocument;
        Document contentDocument;
        if (editor == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(5);
        }
        if (e == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(6);
        }
        DocumentContent content = null;
        if (selectedContent instanceof DocumentContent && (contentDocument = ((DocumentContent)selectedContent).getDocument()).equals((Object)(editorDocument = editor.getDocument()))) {
            content = (DocumentContent)selectedContent;
        }
        if (content == null) {
            content = DiffContentFactory.getInstance().create(project, editor.getDocument(), type);
        }
        if ((selectionModel = editor.getSelectionModel()).hasSelection() && !EditorUtil.contextMenuInvokedOutsideOfSelection((AnActionEvent)e)) {
            TextRange range = new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
            content = DiffContentFactory.getInstance().createFragment(project, content, range);
        }
        if (editor.isViewer()) {
            content.putUserData(DiffUserDataKeys.FORCE_READ_ONLY, (Object)true);
        }
        DocumentContent documentContent = content;
        if (documentContent == null) {
            CompareClipboardWithSelectionAction.$$$reportNull$$$0(7);
        }
        return documentContent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/actions/CompareClipboardWithSelectionAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/actions/CompareClipboardWithSelectionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getEditorFileType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDiffRequestChain";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7 -> new IllegalStateException(string);
        };
    }
}

