/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharCollections;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.io.Serializable;
import java.util.Set;

public final class CharSets {
    public static final EmptySet EMPTY_SET = new EmptySet();
    static final CharSet UNMODIFIABLE_EMPTY_SET = CharSets.unmodifiable(new CharArraySet(CharArrays.EMPTY_ARRAY));

    public static CharSet emptySet() {
        return EMPTY_SET;
    }

    public static CharSet unmodifiable(CharSet s) {
        return new UnmodifiableSet(s);
    }

    public static class EmptySet
    extends CharCollections.EmptyCollection
    implements CharSet,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySet() {
        }

        @Override
        public boolean remove(char ok) {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return EMPTY_SET;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Set && ((Set)o).isEmpty();
        }

        @Override
        @Deprecated
        public boolean rem(char k) {
            return super.rem(k);
        }

        private Object readResolve() {
            return EMPTY_SET;
        }
    }

    public static class UnmodifiableSet
    extends CharCollections.UnmodifiableCollection
    implements CharSet,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected UnmodifiableSet(CharSet s) {
            super(s);
        }

        @Override
        public boolean remove(char k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return this.collection.equals(o);
        }

        @Override
        public int hashCode() {
            return this.collection.hashCode();
        }

        @Override
        @Deprecated
        public boolean rem(char k) {
            return super.rem(k);
        }
    }
}

