/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.configuration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SerializablePersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.io.FileUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.configuration.TextMatePersistentBundle;
import org.jetbrains.plugins.textmate.configuration.TextMateUserBundleServiceState;

@State(name="TextMateUserBundlesSettings", storages={@Storage(value="textmate.xml", roamingType=RoamingType.DISABLED)}, category=SettingsCategory.TOOLS, exportable=true)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006J\b\u0010\r\u001a\u00020\fH\u0016J\u0016\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0007R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/textmate/configuration/TextMateUserBundlesSettings;", "Lcom/intellij/openapi/components/SerializablePersistentStateComponent;", "Lorg/jetbrains/plugins/textmate/configuration/TextMateUserBundleServiceState;", "<init>", "()V", "bundles", "", "", "Lorg/jetbrains/plugins/textmate/configuration/TextMatePersistentBundle;", "getBundles", "()Ljava/util/Map;", "setBundlesConfig", "", "noStateLoaded", "addBundle", "path", "name", "removeBundle", "disableBundle", "hasEnabledBundle", "", "Companion", "intellij.textmate"})
@SourceDebugExtension(value={"SMAP\nTextMateUserBundlesSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateUserBundlesSettings.kt\norg/jetbrains/plugins/textmate/configuration/TextMateUserBundlesSettings\n+ 2 SerializablePersistentStateComponent.kt\ncom/intellij/openapi/components/SerializablePersistentStateComponent\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n91#2,5:71\n97#2,5:82\n102#2,2:88\n91#2,11:90\n102#2,2:102\n91#2,5:104\n97#2,5:116\n102#2,2:122\n91#2,11:124\n102#2,2:136\n481#3:76\n427#3:77\n540#3:109\n525#3,6:110\n1266#4,4:78\n1#5:87\n1#5:101\n1#5:121\n1#5:135\n*S KotlinDebug\n*F\n+ 1 TextMateUserBundlesSettings.kt\norg/jetbrains/plugins/textmate/configuration/TextMateUserBundlesSettings\n*L\n20#1:71,5\n20#1:82,5\n20#1:88,2\n31#1:90,11\n31#1:102,2\n38#1:104,5\n38#1:116,5\n38#1:122,2\n45#1:124,11\n45#1:136,2\n21#1:76\n21#1:77\n39#1:109\n39#1:110,6\n21#1:78,4\n20#1:87\n31#1:101\n38#1:121\n45#1:135\n*E\n"})
public final class TextMateUserBundlesSettings
extends SerializablePersistentStateComponent<TextMateUserBundleServiceState> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public TextMateUserBundlesSettings() {
        super((Object)new TextMateUserBundleServiceState(null, 1, null));
    }

    @NotNull
    public final Map<String, TextMatePersistentBundle> getBundles() {
        return ((TextMateUserBundleServiceState)this.getState()).bundles;
    }

    /*
     * WARNING - void declaration
     */
    public final void setBundlesConfig(@NotNull Map<String, TextMatePersistentBundle> bundles) {
        Intrinsics.checkNotNullParameter(bundles, (String)"bundles");
        SerializablePersistentStateComponent this_$iv = this;
        boolean $i$f$updateState = false;
        Object prev$iv = null;
        prev$iv = this_$iv.getState();
        TextMateUserBundleServiceState next$iv = null;
        while (true) {
            void it$iv;
            Object object;
            if (next$iv == null) {
                void $this$associateByTo$iv$iv$iv;
                void $this$mapKeysTo$iv$iv;
                TextMateUserBundleServiceState it = (TextMateUserBundleServiceState)prev$iv;
                boolean bl = false;
                Map<String, TextMatePersistentBundle> $this$mapKeys$iv = bundles;
                boolean $i$f$mapKeys = false;
                Map<String, TextMatePersistentBundle> map = $this$mapKeys$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                boolean $i$f$mapKeysTo = false;
                Iterable iterable = $this$mapKeysTo$iv$iv.entrySet();
                Map destination$iv$iv$iv = destination$iv$iv;
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    String string;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map2 = destination$iv$iv$iv;
                    boolean bl2 = false;
                    String path = (String)entry.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemIndependentName((String)path), (String)"toSystemIndependentName(...)");
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Map map3 = map2;
                    boolean bl3 = false;
                    entry = it$iv$iv.getValue();
                    map3.put(string, entry);
                }
                Map map4 = destination$iv$iv$iv;
                next$iv = new TextMateUserBundleServiceState(map4);
            }
            if (SerializablePersistentStateComponent.Companion.compareAndSet(this_$iv, prev$iv, next$iv)) break;
            Object object2 = object = this_$iv.getState();
            Object object3 = prev$iv;
            boolean bl = false;
            prev$iv = it$iv;
            boolean haveNext$iv = object3 == object;
            if (haveNext$iv) continue;
            next$iv = null;
        }
    }

    public void noStateLoaded() {
        this.loadState(new TextMateUserBundleServiceState(null, 1, null));
    }

    /*
     * WARNING - void declaration
     */
    public final void addBundle(@NotNull String path, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = FileUtil.toSystemIndependentName((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String normalizedPath = string;
        SerializablePersistentStateComponent this_$iv = this;
        boolean $i$f$updateState = false;
        Object prev$iv = null;
        prev$iv = this_$iv.getState();
        TextMateUserBundleServiceState next$iv = null;
        while (true) {
            void it$iv;
            Object object;
            if (next$iv == null) {
                TextMateUserBundleServiceState state = (TextMateUserBundleServiceState)prev$iv;
                boolean bl = false;
                next$iv = new TextMateUserBundleServiceState(MapsKt.plus(state.bundles, (Pair)TuplesKt.to((Object)normalizedPath, (Object)new TextMatePersistentBundle(name, true))));
            }
            if (SerializablePersistentStateComponent.Companion.compareAndSet(this_$iv, prev$iv, next$iv)) break;
            Object object2 = object = this_$iv.getState();
            Object object3 = prev$iv;
            boolean bl = false;
            prev$iv = it$iv;
            boolean haveNext$iv = object3 == object;
            if (haveNext$iv) continue;
            next$iv = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeBundle(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = FileUtil.toSystemIndependentName((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String normalizedPath = string;
        SerializablePersistentStateComponent this_$iv = this;
        boolean $i$f$updateState = false;
        Object prev$iv = null;
        prev$iv = this_$iv.getState();
        TextMateUserBundleServiceState next$iv = null;
        while (true) {
            void it$iv;
            Object object;
            if (next$iv == null) {
                void $this$filterTo$iv$iv;
                TextMateUserBundleServiceState state = (TextMateUserBundleServiceState)prev$iv;
                boolean bl = false;
                Map<String, TextMatePersistentBundle> $this$filter$iv = state.bundles;
                boolean $i$f$filter = false;
                Map<String, TextMatePersistentBundle> map = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it = element$iv$iv = iterator.next();
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual(it.getKey(), (Object)normalizedPath))) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Map map2 = destination$iv$iv;
                next$iv = new TextMateUserBundleServiceState(map2);
            }
            if (SerializablePersistentStateComponent.Companion.compareAndSet(this_$iv, prev$iv, next$iv)) break;
            Object object2 = object = this_$iv.getState();
            Object object3 = prev$iv;
            boolean bl = false;
            prev$iv = it$iv;
            boolean haveNext$iv = object3 == object;
            if (haveNext$iv) continue;
            next$iv = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void disableBundle(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = FileUtil.toSystemIndependentName((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String normalizedPath = string;
        SerializablePersistentStateComponent this_$iv = this;
        boolean $i$f$updateState = false;
        Object prev$iv = null;
        prev$iv = this_$iv.getState();
        TextMateUserBundleServiceState next$iv = null;
        while (true) {
            void it$iv;
            Object object;
            if (next$iv == null) {
                TextMateUserBundleServiceState state = (TextMateUserBundleServiceState)prev$iv;
                boolean bl = false;
                if (state.bundles.get(normalizedPath) != null) {
                    TextMatePersistentBundle bundle;
                    boolean bl2 = false;
                    v1 = new TextMateUserBundleServiceState(MapsKt.plus(state.bundles, (Pair)TuplesKt.to((Object)normalizedPath, (Object)TextMatePersistentBundle.copy$default(bundle, null, false, 1, null))));
                } else {
                    v1 = next$iv = state;
                }
            }
            if (SerializablePersistentStateComponent.Companion.compareAndSet(this_$iv, prev$iv, next$iv)) break;
            Object object2 = object = this_$iv.getState();
            Object object3 = prev$iv;
            boolean bl = false;
            prev$iv = it$iv;
            boolean haveNext$iv = object3 == object;
            if (haveNext$iv) continue;
            next$iv = null;
        }
    }

    public final boolean hasEnabledBundle(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = FileUtil.toSystemIndependentName((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String normalizedPath = string;
        TextMatePersistentBundle textMatePersistentBundle = this.getBundles().get(normalizedPath);
        return textMatePersistentBundle != null ? textMatePersistentBundle.getEnabled() : false;
    }

    @JvmStatic
    @Nullable
    public static final TextMateUserBundlesSettings getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/textmate/configuration/TextMateUserBundlesSettings$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/plugins/textmate/configuration/TextMateUserBundlesSettings;", "intellij.textmate"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final TextMateUserBundlesSettings getInstance() {
            return (TextMateUserBundlesSettings)((Object)ApplicationManager.getApplication().getService(TextMateUserBundlesSettings.class));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

