/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.utils.mpp.time;

import ai.grazie.utils.mpp.MPPComparable;
import ai.grazie.utils.mpp.time.Duration;
import ai.grazie.utils.mpp.time.Time;
import ai.grazie.utils.mpp.time.TimePeriod;
import ai.grazie.utils.mpp.time.TimeUtils;
import ai.grazie.utils.multiplatform.SafeJsExport;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SafeJsExport
@Serializable(with=Serializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0087\b\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002)*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0011\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0086\u0002J\u0018\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bH\u0007J\u0011\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0086\u0002J\u0018\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bH\u0007J\u0011\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010!\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010&\u001a\u00020\u001f2\b\u0010\u001c\u001a\u0004\u0018\u00010'H\u00d6\u0003J\t\u0010(\u001a\u00020\u000bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0012\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\r\u00a8\u0006+"}, d2={"Lai/grazie/utils/mpp/time/Timestamp;", "Lai/grazie/utils/mpp/MPPComparable;", "millis", "", "<init>", "(J)V", "getMillis", "()J", "toString", "", "seconds", "", "getSeconds", "()I", "minutes", "getMinutes", "hours", "getHours", "days", "getDays", "plus", "duration", "Lai/grazie/utils/mpp/time/Duration;", "period", "Lai/grazie/utils/mpp/time/TimePeriod;", "number", "minus", "compareTo", "other", "between", "before", "", "beforeOrEqual", "after", "afterOrEqual", "atStartOf", "component1", "copy", "equals", "", "hashCode", "Companion", "Serializer", "utils-common"})
public final class Timestamp
implements MPPComparable<Timestamp> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long millis;

    public Timestamp(long millis) {
        this.millis = millis;
    }

    public final long getMillis() {
        return this.millis;
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.millis);
    }

    public final int getSeconds() {
        return MathKt.roundToInt((double)((double)this.millis / (double)1000));
    }

    public final int getMinutes() {
        return MathKt.roundToInt((double)((double)this.getSeconds() / (double)60));
    }

    public final int getHours() {
        return MathKt.roundToInt((double)((double)this.getMinutes() / (double)60));
    }

    public final int getDays() {
        return MathKt.roundToInt((double)((double)this.getHours() / (double)24));
    }

    @NotNull
    public final Timestamp plus(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return new Timestamp(this.millis + duration.getMillis());
    }

    @NotNull
    public final Timestamp plus(@NotNull TimePeriod period, int number) {
        Intrinsics.checkNotNullParameter((Object)((Object)period), (String)"period");
        return TimeUtils.INSTANCE.plus(this, period, number);
    }

    @NotNull
    public final Timestamp minus(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return new Timestamp(Math.max(0L, this.millis - duration.getMillis()));
    }

    @NotNull
    public final Timestamp minus(@NotNull TimePeriod period, int number) {
        Intrinsics.checkNotNullParameter((Object)((Object)period), (String)"period");
        return TimeUtils.INSTANCE.minus(this, period, number);
    }

    @Override
    public int compareTo(@NotNull Timestamp other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((long)this.millis, (long)other.millis);
    }

    @NotNull
    public final Duration between(@NotNull Timestamp other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Duration(Math.abs(this.millis - other.millis));
    }

    public final boolean before(@NotNull Timestamp other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) < 0;
    }

    public final boolean beforeOrEqual(@NotNull Timestamp other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) <= 0;
    }

    public final boolean after(@NotNull Timestamp other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) >= 0;
    }

    public final boolean afterOrEqual(@NotNull Timestamp other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.millis >= other.millis;
    }

    @NotNull
    public final Timestamp atStartOf(@NotNull TimePeriod period) {
        Intrinsics.checkNotNullParameter((Object)((Object)period), (String)"period");
        return TimeUtils.INSTANCE.atStartOf(this, period);
    }

    public final long component1() {
        return this.millis;
    }

    @NotNull
    public final Timestamp copy(long millis) {
        return new Timestamp(millis);
    }

    public static /* synthetic */ Timestamp copy$default(Timestamp timestamp, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = timestamp.millis;
        }
        return timestamp.copy(l);
    }

    public int hashCode() {
        return Long.hashCode(this.millis);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Timestamp)) {
            return false;
        }
        Timestamp timestamp = (Timestamp)other;
        return this.millis == timestamp.millis;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010\u0007\u001a\u00020\u0005J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010\u00a8\u0006\u0011"}, d2={"Lai/grazie/utils/mpp/time/Timestamp$Companion;", "", "<init>", "()V", "now", "Lai/grazie/utils/mpp/time/Timestamp;", "epoch", "max", "ofFullDate", "value", "", "ofHttpDate", "of", "millis", "", "serializer", "Lkotlinx/serialization/KSerializer;", "utils-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Timestamp now() {
            return new Timestamp(Time.INSTANCE.epochMillis$utils_common());
        }

        @NotNull
        public final Timestamp epoch() {
            return new Timestamp(0L);
        }

        @NotNull
        public final Timestamp max() {
            return new Timestamp(Long.MAX_VALUE);
        }

        @NotNull
        public final Timestamp ofFullDate(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return TimeUtils.INSTANCE.ofFullDate(value);
        }

        @NotNull
        public final Timestamp ofHttpDate(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return TimeUtils.INSTANCE.ofHttpDate(value);
        }

        @NotNull
        public final Timestamp of(double millis) {
            return new Timestamp((long)millis);
        }

        @NotNull
        public final KSerializer<Timestamp> serializer() {
            return Serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lai/grazie/utils/mpp/time/Timestamp$Serializer;", "Lkotlinx/serialization/KSerializer;", "Lai/grazie/utils/mpp/time/Timestamp;", "<init>", "()V", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "utils-common"})
    public static final class Serializer
    implements KSerializer<Timestamp> {
        @NotNull
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @NotNull
        public Timestamp deserialize(@NotNull Decoder decoder) {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            return new Timestamp(decoder.decodeLong());
        }

        @NotNull
        public SerialDescriptor getDescriptor() {
            return SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"Timestamp", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.LONG.INSTANCE));
        }

        public void serialize(@NotNull Encoder encoder, @NotNull Timestamp value) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            encoder.encodeLong(value.getMillis());
        }
    }
}

