/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.properties;

import com.intellij.microservices.jvm.config.ConfigKeyParts;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.quarkus.config.QsMetaConfigKey;
import com.intellij.quarkus.config.QsMetaConfigKeyManager;
import com.intellij.quarkus.config.properties.QsConfigKeyPathArbitraryEntryKeyReference;
import com.intellij.quarkus.config.properties.QsPropertySubKeyMetaConfigKeyReference;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/intellij/quarkus/config/properties/QsConfigKeyPathReferenceSet;", "", "element", "Lcom/intellij/psi/PsiElement;", "configKey", "Lcom/intellij/quarkus/config/QsMetaConfigKey;", "text", "", "offset", "", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/quarkus/config/QsMetaConfigKey;Ljava/lang/String;I)V", "references", "", "Lcom/intellij/psi/PsiReference;", "getReferences", "()Ljava/util/List;", "parse", "", "parseSubKey", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQsConfigKeyPathReferenceSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsConfigKeyPathReferenceSet.kt\ncom/intellij/quarkus/config/properties/QsConfigKeyPathReferenceSet\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n296#2,2:80\n296#2,2:82\n*S KotlinDebug\n*F\n+ 1 QsConfigKeyPathReferenceSet.kt\ncom/intellij/quarkus/config/properties/QsConfigKeyPathReferenceSet\n*L\n67#1:80,2\n70#1:82,2\n*E\n"})
public final class QsConfigKeyPathReferenceSet {
    @NotNull
    private final PsiElement element;
    @NotNull
    private final QsMetaConfigKey configKey;
    @NotNull
    private final List<PsiReference> references;

    public QsConfigKeyPathReferenceSet(@NotNull PsiElement element, @NotNull QsMetaConfigKey configKey, @NotNull String text, int offset) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)configKey), (String)"configKey");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.element = element;
        this.configKey = configKey;
        this.references = (List)new SmartList();
        MetaConfigKey.AccessType[] accessTypeArray = new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.INDEXED, MetaConfigKey.AccessType.MAP, MetaConfigKey.AccessType.ENUM_MAP};
        boolean bl = this.configKey.isAccessType(accessTypeArray);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            QsMetaConfigKey qsMetaConfigKey = this.configKey;
            throw new AssertionError((Object)qsMetaConfigKey);
        }
        this.parse(text, offset);
    }

    @NotNull
    public final List<PsiReference> getReferences() {
        return this.references;
    }

    private final void parse(String text, int offset) {
        MetaConfigKey.AccessType[] accessTypeArray = new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.INDEXED};
        if (this.configKey.isAccessType(accessTypeArray)) {
            int closingBracketIndex = StringsKt.indexOf$default((CharSequence)text, (String)"].", (int)0, (boolean)false, (int)6, null);
            if (closingBracketIndex == -1) {
                return;
            }
            int subKeyIndex = closingBracketIndex + 2;
            String string = text.substring(subKeyIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String subKeyText = string;
            this.parseSubKey(subKeyText, offset + subKeyIndex);
            return;
        }
        ConfigKeyParts configKeyParts = ConfigKeyParts.splitToParts((MetaConfigKey)((MetaConfigKey)this.configKey), (String)text, (boolean)false);
        if (configKeyParts == null) {
            return;
        }
        ConfigKeyParts parts = configKeyParts;
        int entryOffset = parts.getConfigKey().length() + 1;
        if (entryOffset > text.length()) {
            return;
        }
        String string = text.substring(entryOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String entryText = string;
        String string2 = parts.getKeyIndex();
        int separatorIndex = StringsKt.indexOf$default((CharSequence)entryText, (char)'.', (int)(string2 != null ? string2.length() : 0), (boolean)false, (int)4, null);
        if (separatorIndex < 0) {
            separatorIndex = entryText.length();
        }
        TextRange textRange = TextRange.create((int)0, (int)separatorIndex).shiftRight(offset + entryOffset);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
        TextRange entryKeyRange = textRange;
        this.references.add((PsiReference)new QsConfigKeyPathArbitraryEntryKeyReference(this.element, entryKeyRange));
        if (separatorIndex < entryText.length()) {
            ++separatorIndex;
        }
        String string3 = entryText.substring(separatorIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String subKeyText = string3;
        this.parseSubKey(subKeyText, offset + entryOffset + separatorIndex);
    }

    private final void parseSubKey(String text, int offset) {
        MetaConfigKeyManager.ConfigKeyNameBinder binder;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.element);
        if (module == null) {
            return;
        }
        List<QsMetaConfigKey> subKeys = this.configKey.getSubKeys(module);
        if (subKeys.isEmpty()) {
            return;
        }
        QsMetaConfigKey subKey = null;
        if (((CharSequence)text).length() > 0) {
            Object v0;
            block7: {
                Iterable $this$firstOrNull$iv = subKeys;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    QsMetaConfigKey it = (QsMetaConfigKey)((Object)element$iv);
                    boolean bl = false;
                    MetaConfigKey.AccessType[] accessTypeArray = new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL};
                    if (!(it.isAccessType(accessTypeArray) && Comparing.equal((String)it.getName(), (String)text, (boolean)true))) continue;
                    v0 = element$iv;
                    break block7;
                }
                v0 = null;
            }
            subKey = v0;
            if (subKey == null) {
                Object v1;
                block8: {
                    binder = QsMetaConfigKeyManager.Companion.getInstance().getConfigKeyNameBinder(module);
                    Iterable $this$firstOrNull$iv = subKeys;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        QsMetaConfigKey it = (QsMetaConfigKey)((Object)element$iv);
                        boolean bl = false;
                        if (!binder.bindsTo((MetaConfigKey)it, text)) continue;
                        v1 = element$iv;
                        break block8;
                    }
                    v1 = null;
                }
                subKey = v1;
            }
        }
        this.references.add((PsiReference)new QsPropertySubKeyMetaConfigKeyReference(this.element, text, this.configKey, offset));
        if (subKey != null && !subKey.isAccessType((MetaConfigKey.AccessType[])(binder = new MetaConfigKeyManager.ConfigKeyNameBinder[]{MetaConfigKey.AccessType.NORMAL}))) {
            QsConfigKeyPathReferenceSet subReferenceSet = new QsConfigKeyPathReferenceSet(this.element, subKey, text, offset);
            this.references.addAll((Collection<PsiReference>)subReferenceSet.references);
        }
    }
}

