/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.console;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bJ\u001c\u0010\u0010\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t2\n\u0010\u000f\u001a\u00060\bj\u0002`\u000bH\u0002J\u0018\u0010\u0010\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u000e\u0010\u0019\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tJ\"\u0010\u001a\u001a\u00020\u00172\n\u0010\u0019\u001a\u00060\bj\u0002`\t2\u000e\u0010\u0018\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\b\u0012\u00060\bj\u0002`\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jupyter/core/console/JupyterConsoleUtil;", "", "<init>", "()V", "JUPYTER_CONSOLE_FILE_NAME_PREFIX", "", "ORIGINAL_VIRTUAL_FILE", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "Lcom/intellij/jupyter/core/console/OriginalNotebookFile;", "CONSOLE_VIRTUAL_FILE", "Lcom/intellij/jupyter/core/console/ConsoleNotebookFile;", "getOriginal", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "notebookVirtualFile", "getOriginalByConsoleVirtualFile", "isJupyterConsoleView", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isJupyterConsoleFile", "setOriginalFile", "", "consoleNotebookFile", "originalFile", "setConsoleFile", "intellij.jupyter.core"})
public final class JupyterConsoleUtil {
    @NotNull
    public static final JupyterConsoleUtil INSTANCE = new JupyterConsoleUtil();
    @NotNull
    public static final String JUPYTER_CONSOLE_FILE_NAME_PREFIX = "PycharmJupyterConsole";
    @NotNull
    private static final Key<BackedNotebookVirtualFile> ORIGINAL_VIRTUAL_FILE;
    @NotNull
    private static final Key<BackedNotebookVirtualFile> CONSOLE_VIRTUAL_FILE;

    private JupyterConsoleUtil() {
    }

    @NotNull
    public final BackedNotebookVirtualFile getOriginal(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        BackedNotebookVirtualFile backedNotebookVirtualFile = this.getOriginalByConsoleVirtualFile(virtualFile);
        if (backedNotebookVirtualFile == null) {
            backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeBackend(virtualFile);
        }
        return backedNotebookVirtualFile;
    }

    @NotNull
    public final BackedNotebookVirtualFile getOriginal(@NotNull BackedNotebookVirtualFile notebookVirtualFile2) {
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile2, (String)"notebookVirtualFile");
        BackedNotebookVirtualFile backedNotebookVirtualFile = this.getOriginalByConsoleVirtualFile(notebookVirtualFile2);
        if (backedNotebookVirtualFile == null) {
            backedNotebookVirtualFile = notebookVirtualFile2;
        }
        return backedNotebookVirtualFile;
    }

    private final BackedNotebookVirtualFile getOriginalByConsoleVirtualFile(BackedNotebookVirtualFile notebookVirtualFile2) {
        return (BackedNotebookVirtualFile)notebookVirtualFile2.getFile().getUserData(ORIGINAL_VIRTUAL_FILE);
    }

    private final BackedNotebookVirtualFile getOriginalByConsoleVirtualFile(VirtualFile virtualFile) {
        return (BackedNotebookVirtualFile)virtualFile.getUserData(ORIGINAL_VIRTUAL_FILE);
    }

    public final boolean isJupyterConsoleView(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        return this.isJupyterConsoleFile(file) && JupyterEditorExtensionsKt.getNotebookFileOrNull(editor) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isJupyterConsoleFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        String string = virtualFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.startsWith$default((String)string, (String)JUPYTER_CONSOLE_FILE_NAME_PREFIX, (boolean)false, (int)2, null)) return true;
        String string2 = virtualFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        Object[] objectArray = new Object[]{""};
        if (!StringsKt.startsWith$default((String)string2, (String)JupyterBundle.message("tab.title.JupyterConsole", objectArray), (boolean)false, (int)2, null)) return false;
        return true;
    }

    public final void setOriginalFile(@NotNull VirtualFile consoleNotebookFile, @Nullable BackedNotebookVirtualFile originalFile) {
        Intrinsics.checkNotNullParameter((Object)consoleNotebookFile, (String)"consoleNotebookFile");
        consoleNotebookFile.putUserData(ORIGINAL_VIRTUAL_FILE, (Object)originalFile);
    }

    public final void setConsoleFile(@NotNull BackedNotebookVirtualFile originalFile, @Nullable BackedNotebookVirtualFile consoleNotebookFile) {
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        originalFile.putUserData(CONSOLE_VIRTUAL_FILE, consoleNotebookFile);
    }

    static {
        Key key = Key.create((String)"ORIGINAL_VIRTUAL_FILE_FOR_CONSOLE");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        ORIGINAL_VIRTUAL_FILE = key;
        Key key2 = Key.create((String)"CONSOLE_VIRTUAL_FILE_FOR_ORIGINAL");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        CONSOLE_VIRTUAL_FILE = key2;
    }
}

