/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.actions;

import com.intellij.jupyter.core.core.impl.actions.NotebookEditorActionBase;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterCellOutputUtils;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/jupyter/actions/JupyterClearCellOutputAction;", "Lcom/intellij/jupyter/core/core/impl/actions/NotebookEditorActionBase;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.jupyter.core"})
public final class JupyterClearCellOutputAction
extends NotebookEditorActionBase {
    private JupyterClearCellOutputAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor);
        if (backedNotebookVirtualFile == null) {
            return;
        }
        BackedNotebookVirtualFile file = backedNotebookVirtualFile;
        if (e.isFromContextMenu()) {
            DataContext dataContext2 = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
            object = JupyterHelper.INSTANCE.getHoveredInterval(dataContext2);
        } else {
            DataContext dataContext3 = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"getDataContext(...)");
            List<NotebookCellLines.Interval> list = JupyterHelper.INSTANCE.getSelectedIntervals(dataContext3);
            object = list != null ? (NotebookCellLines.Interval)CollectionsKt.singleOrNull(list) : null;
        }
        if (object == null) {
            return;
        }
        NotebookCellLines.Interval interval = object;
        NotebookIntervalPointer intervalPointer = NotebookIntervalPointerFactory.Companion.get((Editor)editor).create(interval);
        JupyterCellOutputUtils.INSTANCE.clearOutput(file, intervalPointer);
    }
}

