/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.actions;

import com.intellij.jupyter.core.jupyter.editor.actions.JupyterCutHandler;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/actions/JupyterSelectionLastLineFixer;", "Lcom/intellij/openapi/editor/actionSystem/EditorWriteActionHandler;", "defaultHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "executeWriteAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "modifySelectionsIfNecessary", "intellij.jupyter.core"})
public final class JupyterSelectionLastLineFixer
extends EditorWriteActionHandler {
    @NotNull
    private final EditorActionHandler defaultHandler;

    public JupyterSelectionLastLineFixer(@NotNull EditorActionHandler defaultHandler) {
        Intrinsics.checkNotNullParameter((Object)defaultHandler, (String)"defaultHandler");
        this.defaultHandler = defaultHandler;
    }

    public void executeWriteAction(@NotNull Editor editor, @Nullable Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (JupyterEditorExtensionsKt.isJupyter(editor)) {
            if (caret != null) {
                this.modifySelectionsIfNecessary(caret, editor);
            } else {
                for (Caret eachCaret : editor.getCaretModel().getAllCarets()) {
                    Intrinsics.checkNotNull((Object)eachCaret);
                    this.modifySelectionsIfNecessary(eachCaret, editor);
                }
            }
        }
        this.defaultHandler.execute(editor, caret, dataContext);
    }

    private final void modifySelectionsIfNecessary(Caret caret, Editor editor) {
        int selectionEnd;
        if (!caret.hasSelection()) {
            return;
        }
        int selectionStart = caret.getSelectionStart();
        TextRange improvedSelection = JupyterCutHandler.Companion.improvedSelection$intellij_jupyter_core(editor, selectionStart, selectionEnd = caret.getSelectionEnd());
        if (improvedSelection.getStartOffset() != selectionStart || improvedSelection.getEndOffset() != selectionEnd) {
            caret.setSelection(improvedSelection.getStartOffset(), improvedSelection.getEndOffset());
        }
    }
}

