/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.editor.outputs.error;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.jupyter.core.editor.JupyterExecutionHistoryProvider;
import com.intellij.jupyter.core.fus.JupyterFeaturesCollector;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.jupyter.py.editor.outputs.error.PythonLinkFilter;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorMode;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000f\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u0014J\u000f\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jupyter/py/editor/outputs/error/JupyterCellHyperlinkInfo;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "executionCount", "", "cellLine", "filter", "Lcom/intellij/jupyter/py/editor/outputs/error/PythonLinkFilter;", "<init>", "(IILcom/intellij/jupyter/py/editor/outputs/error/PythonLinkFilter;)V", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookBase;", "cellLines", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "navigate", "", "project", "Lcom/intellij/openapi/project/Project;", "getCurrentSessionIndex", "()Ljava/lang/Integer;", "suggestCellIndex", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterCellHyperlinkInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterCellHyperlinkInfo.kt\ncom/intellij/jupyter/py/editor/outputs/error/JupyterCellHyperlinkInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n296#2,2:55\n777#2:57\n873#2,2:58\n777#2:60\n873#2,2:61\n*S KotlinDebug\n*F\n+ 1 JupyterCellHyperlinkInfo.kt\ncom/intellij/jupyter/py/editor/outputs/error/JupyterCellHyperlinkInfo\n*L\n41#1:55,2\n46#1:57\n46#1:58,2\n47#1:60\n47#1:61,2\n*E\n"})
public final class JupyterCellHyperlinkInfo
implements HyperlinkInfo {
    private final int executionCount;
    private final int cellLine;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final JupyterNotebookBase notebook;
    @NotNull
    private final NotebookCellLines cellLines;

    public JupyterCellHyperlinkInfo(int executionCount, int cellLine, @NotNull PythonLinkFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        this.executionCount = executionCount;
        this.cellLine = cellLine;
        this.editor = filter.getEditor();
        this.notebook = filter.getNotebook();
        this.cellLines = NotebookCellLines.Companion.get((Editor)this.editor);
    }

    public void navigate(@NotNull Project project) {
        int n;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Integer n2 = this.getCurrentSessionIndex();
        if (n2 != null) {
            n = n2;
        } else {
            Integer n3 = this.suggestCellIndex();
            if (n3 != null) {
                n = n3;
            } else {
                return;
            }
        }
        int index = n;
        NotebookCellLines.Interval cellLines = (NotebookCellLines.Interval)this.cellLines.getIntervals().get(index);
        int line = cellLines.getFirstContentLine() + this.cellLine - 1;
        int lineStartOffset = this.editor.getDocument().getLineStartOffset(line);
        IdeFocusManager.getInstance((Project)project).requestFocus((Component)this.editor.getComponent(), true);
        NotebookEditorModeKt.setMode((Editor)((Editor)this.editor), (NotebookEditorMode)NotebookEditorMode.EDIT);
        this.editor.getCaretModel().moveToOffset(lineStartOffset);
        this.editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        JupyterFeaturesCollector.Companion.onLinkToCellInError();
    }

    private final Integer getCurrentSessionIndex() {
        JupyterCell cell;
        Object v1;
        block2: {
            JupyterExecutionHistoryProvider executionHistoryManager = JupyterExecutionHistoryProvider.Companion.getOrInstall((Editor)this.editor);
            String string = executionHistoryManager.getIdForExecutionCount(this.executionCount);
            if (string == null) {
                return null;
            }
            String cellId = string;
            Iterable $this$firstOrNull$iv = this.notebook.computeCells();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JupyterCell it = (JupyterCell)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)cellId)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        JupyterCell jupyterCell = cell = (JupyterCell)v1;
        return jupyterCell != null ? jupyterCell.getIndex() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final Integer suggestCellIndex() {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv = this.notebook.computeCells();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            JupyterCell it = (JupyterCell)element$iv$iv;
            boolean bl = false;
            Integer n = it.getExecutionCount();
            int n2 = this.executionCount;
            if (!(n != null && n == n2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List supportedCells = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = supportedCells;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            JupyterCell it = (JupyterCell)element$iv$iv;
            boolean bl2 = false;
            Integer n = it.getIndex();
            if (n == null) {
                bl = false;
            } else {
                int index = n;
                NotebookCellLines.Interval pointer = (NotebookCellLines.Interval)this.cellLines.getIntervals().get(index);
                bl = this.cellLine <= pointer.getLines().getLast() - pointer.getLines().getFirst();
            }
            if (!bl) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List enoughLongCells = (List)destination$iv$iv2;
        JupyterCell jupyterCell = (JupyterCell)CollectionsKt.firstOrNull((List)enoughLongCells);
        return jupyterCell != null ? jupyterCell.getIndex() : null;
    }
}

